/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples.raw;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.HdrHistogram.Histogram;
import uk.co.real_logic.aeron.samples.raw.Common;
import uk.co.real_logic.agrona.concurrent.SigInt;

public class TransferToPing {
    private static final String LOCALHOST = "localhost";

    public static void main(String[] args) throws IOException {
        Histogram histogram = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
        FileChannel sendFileChannel = Common.createTmpFileChannel();
        MappedByteBuffer sendByteBuffer = sendFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 4096L);
        DatagramChannel sendDatagramChannel = DatagramChannel.open();
        Common.init(sendDatagramChannel);
        sendDatagramChannel.bind(new InetSocketAddress(LOCALHOST, 40123));
        sendDatagramChannel.connect(new InetSocketAddress(LOCALHOST, 40124));
        FileChannel receiveFileChannel = Common.createTmpFileChannel();
        MappedByteBuffer receiveByteBuffer = receiveFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 4096L);
        DatagramChannel receiveDatagramChannel = DatagramChannel.open();
        Common.init(receiveDatagramChannel);
        receiveDatagramChannel.bind(new InetSocketAddress(LOCALHOST, 40126));
        receiveDatagramChannel.connect(new InetSocketAddress(LOCALHOST, 40125));
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            TransferToPing.measureRoundTrip(histogram, receiveFileChannel, receiveDatagramChannel, receiveByteBuffer, sendFileChannel, sendDatagramChannel, sendByteBuffer, running);
            histogram.reset();
            System.gc();
            LockSupport.parkNanos(1000000000L);
        }
    }

    private static void measureRoundTrip(Histogram histogram, FileChannel receiveFileChannel, DatagramChannel receiveDatagramChannel, ByteBuffer receiveByteBuffer, FileChannel sendFileChannel, DatagramChannel sendDatagramChannel, ByteBuffer sendByteBuffer, AtomicBoolean running) throws IOException {
        int packetSize = 16;
        for (int sequenceNumber = 0; sequenceNumber < 10000; ++sequenceNumber) {
            long timestamp = System.nanoTime();
            sendByteBuffer.putLong(0, sequenceNumber);
            sendByteBuffer.putLong(8, timestamp);
            long bytesSent = sendFileChannel.transferTo(0L, 16L, sendDatagramChannel);
            if (16L != bytesSent) {
                throw new IllegalStateException("Invalid bytes sent " + bytesSent);
            }
            boolean available = false;
            while (!available) {
                if (!running.get()) {
                    return;
                }
                long bytesReceived = receiveFileChannel.transferFrom(receiveDatagramChannel, 0L, 16L);
                if (16L != bytesReceived) continue;
                available = true;
            }
            long receivedSequenceNumber = receiveByteBuffer.getLong(0);
            if (receivedSequenceNumber != (long)sequenceNumber) {
                throw new IllegalStateException("Data Loss:" + sequenceNumber + " to " + receivedSequenceNumber);
            }
            long duration = System.nanoTime() - receiveByteBuffer.getLong(8);
            histogram.recordValue(duration);
        }
        histogram.outputPercentileDistribution(System.out, Double.valueOf(1000.0));
    }
}

