/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.builder.Printer;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.DecoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Message;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

class PrinterGenerator {
    private static final String CLASS_NAME = "PrinterImpl";
    private static final String CLASS_DECLARATION = GenerationUtil.importFor(Printer.class) + GenerationUtil.importFor(AsciiBuffer.class) + GenerationUtil.importFor(Generated.class) + "\n" + "@Generated(\"uk.co.real_logic.artio\")\n" + "public class PrinterImpl implements Printer\n{\n\n";
    private final Dictionary dictionary;
    private final String builderPackage;
    private final OutputManager outputManager;

    PrinterGenerator(Dictionary dictionary, String builderPackage, OutputManager outputManager) {
        this.dictionary = dictionary;
        this.builderPackage = builderPackage;
        this.outputManager = outputManager;
    }

    public void generate() {
        if (this.dictionary.shared()) {
            return;
        }
        this.outputManager.withOutput(CLASS_NAME, out -> {
            out.append(GenerationUtil.fileHeader(this.builderPackage));
            out.append(CLASS_DECLARATION);
            out.append(this.generateDecoderFields());
            out.append(this.generateToString());
            out.append("}\n");
        });
    }

    private String generateDecoderFields() {
        return this.messages().map(this::generateDecoderField).collect(Collectors.joining()) + "\n";
    }

    private String generateDecoderField(Aggregate aggregate) {
        return String.format("    private final %s %s = new %1$s();\n", DecoderGenerator.decoderClassName(aggregate), this.decoderFieldName(aggregate));
    }

    private String decoderFieldName(Aggregate aggregate) {
        return JavaUtil.formatPropertyName((String)aggregate.name());
    }

    private String generateToString() {
        Function<Message, String> mapper = aggregate -> String.format("            if (messageType == %sL)\n            {\n                %s.decode(input, offset, length);\n                return %2$s.toString();\n            }\n\n", aggregate.packedType(), this.decoderFieldName((Aggregate)aggregate));
        String cases = this.messages().map(mapper).collect(Collectors.joining());
        return "    public String toString(\n        final AsciiBuffer input,\n        final int offset,\n        final int length,\n        final long messageType)\n    {\n" + cases + "            else\n            {\n                throw new IllegalArgumentException(\"Unknown Message Type: \" + messageType);\n            }\n    }\n\n";
    }

    private Stream<Message> messages() {
        return this.dictionary.messages().stream();
    }
}

