/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.agrona.AsciiEncoding;

public class SystemUtil {
    public static final long PID_NOT_FOUND = 0L;
    private static final String SUN_PID_PROP_NAME = "sun.java.launcher.pid";
    private static final long MAX_G_VALUE = 0x1FFFFFFFFL;
    private static final long MAX_M_VALUE = 0x7FFFFFFFFFFL;
    private static final long MAX_K_VALUE = 9007199254739968L;
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final long PID;

    public static String osName() {
        return OS_NAME;
    }

    public static long getPid() {
        return PID;
    }

    public static boolean isDebuggerAttached() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMXBean.getInputArguments()) {
            if (!arg.contains("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    public static String tmpDirName() {
        String tmpDirName = System.getProperty("java.io.tmpdir");
        if (!tmpDirName.endsWith(File.separator)) {
            tmpDirName = tmpDirName + File.separator;
        }
        return tmpDirName;
    }

    public static String threadDump() {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE)) {
            sb.append('\"').append(info.getThreadName()).append("\": ").append((Object)info.getThreadState());
            for (StackTraceElement stackTraceElement : info.getStackTrace()) {
                sb.append("\n    at ").append(stackTraceElement.toString());
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static void loadPropertiesFile(String filenameOrUrl) {
        Throwable throwable;
        InputStream in3;
        File file;
        Properties properties = new Properties(System.getProperties());
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::put));
        URL resource = ClassLoader.getSystemClassLoader().getResource(filenameOrUrl);
        if (null != resource) {
            try (InputStream in22 = resource.openStream();){
                properties.load(in22);
            }
            catch (Exception in22) {
                // empty catch block
            }
        }
        if ((file = new File(filenameOrUrl)).exists()) {
            try {
                in3 = new FileInputStream(file);
                throwable = null;
                try {
                    properties.load(in3);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in3 != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)in3).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileInputStream)in3).close();
                        }
                    }
                }
            }
            catch (Exception in3) {
                // empty catch block
            }
        }
        try {
            in3 = new URL(filenameOrUrl).openStream();
            throwable = null;
            try {
                properties.load(in3);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in3 != null) {
                    if (throwable != null) {
                        try {
                            in3.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in3.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(properties);
    }

    public static void loadPropertiesFiles(String[] filenamesOrUrls) {
        for (String filenameOrUrl : filenamesOrUrls) {
            SystemUtil.loadPropertiesFile(filenameOrUrl);
        }
    }

    public static int getSizeAsInt(String propertyName, int defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            long value = SystemUtil.parseSize(propertyName, propertyValue);
            if (value < 0L || value > Integer.MAX_VALUE) {
                throw new NumberFormatException(propertyName + " must positive and less than Integer.MAX_VALUE :" + value);
            }
            return (int)value;
        }
        return defaultValue;
    }

    public static long getSizeAsLong(String propertyName, long defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            long value = SystemUtil.parseSize(propertyName, propertyValue);
            if (value < 0L) {
                throw new NumberFormatException(propertyName + " must be positive: " + value);
            }
            return value;
        }
        return defaultValue;
    }

    public static long parseSize(String propertyName, String propertyValue) {
        int lengthMinusSuffix = propertyValue.length() - 1;
        char lastCharacter = propertyValue.charAt(lengthMinusSuffix);
        if (Character.isDigit(lastCharacter)) {
            return Long.valueOf(propertyValue);
        }
        long value = AsciiEncoding.parseLongAscii(propertyValue, 0, lengthMinusSuffix);
        switch (lastCharacter) {
            case 'K': 
            case 'k': {
                if (value > 9007199254739968L) {
                    throw new NumberFormatException(propertyName + " would overflow long: " + propertyValue);
                }
                return value * 1024L;
            }
            case 'M': 
            case 'm': {
                if (value > 0x7FFFFFFFFFFL) {
                    throw new NumberFormatException(propertyName + " would overflow long: " + propertyValue);
                }
                return value * 1024L * 1024L;
            }
            case 'G': 
            case 'g': {
                if (value > 0x1FFFFFFFFL) {
                    throw new NumberFormatException(propertyName + " would overflow long: " + propertyValue);
                }
                return value * 1024L * 1024L * 1024L;
            }
        }
        throw new NumberFormatException(propertyName + ": " + propertyValue + " should end with: k, m, or g.");
    }

    public static long getDurationInNanos(String propertyName, long defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            long value = SystemUtil.parseDuration(propertyName, propertyValue);
            if (value < 0L) {
                throw new NumberFormatException(propertyName + " must be positive: " + value);
            }
            return value;
        }
        return defaultValue;
    }

    public static long parseDuration(String propertyName, String propertyValue) {
        char lastCharacter = propertyValue.charAt(propertyValue.length() - 1);
        if (Character.isDigit(lastCharacter)) {
            return Long.valueOf(propertyValue);
        }
        if (lastCharacter != 's' && lastCharacter != 'S') {
            throw new NumberFormatException(propertyName + ": " + propertyValue + " should end with: s, ms, us, or ns.");
        }
        char secondLastCharacter = propertyValue.charAt(propertyValue.length() - 2);
        if (Character.isDigit(secondLastCharacter)) {
            long value = AsciiEncoding.parseLongAscii(propertyValue, 0, propertyValue.length() - 1);
            return TimeUnit.SECONDS.toNanos(value);
        }
        long value = AsciiEncoding.parseLongAscii(propertyValue, 0, propertyValue.length() - 2);
        switch (secondLastCharacter) {
            case 'N': 
            case 'n': {
                return value;
            }
            case 'U': 
            case 'u': {
                return TimeUnit.MICROSECONDS.toNanos(value);
            }
            case 'M': 
            case 'm': {
                return TimeUnit.MILLISECONDS.toNanos(value);
            }
        }
        throw new NumberFormatException(propertyName + ": " + propertyValue + " should end with: s, ms, us, or ns.");
    }

    static {
        long pid = 0L;
        try {
            String pidPropertyValue = System.getProperty(SUN_PID_PROP_NAME);
            if (null != pidPropertyValue) {
                pid = Long.parseLong(pidPropertyValue);
            } else {
                String jvmName = ManagementFactory.getRuntimeMXBean().getName();
                pid = Long.parseLong(jvmName.split("@")[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PID = pid;
    }
}

