/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Objects;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;

public class CountedErrorHandler
implements ErrorHandler {
    private final ErrorHandler errorHandler;
    private final AtomicCounter errorCounter;

    public CountedErrorHandler(ErrorHandler errorHandler, AtomicCounter errorCounter) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(errorCounter, "errorCounter");
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
    }

    @Override
    public void onError(Throwable throwable) {
        if (!this.errorCounter.isClosed()) {
            this.errorCounter.increment();
        }
        this.errorHandler.onError(throwable);
    }
}

