/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;

public class RustFlatFileOutputManager
implements OutputManager {
    private final File outputFile;

    RustFlatFileOutputManager(String baseDirName, String packageName) {
        boolean outputDirAvailable;
        Verify.notNull(baseDirName, "baseDirName");
        Verify.notNull(packageName, "packageName");
        String outputDirName = baseDirName.endsWith("" + File.separatorChar) ? baseDirName : baseDirName + File.separatorChar;
        File outputDir = new File(outputDirName);
        boolean bl = outputDirAvailable = outputDir.exists() || outputDir.mkdirs();
        if (!outputDirAvailable) {
            throw new IllegalStateException("Unable to create directory: " + outputDirName);
        }
        this.outputFile = new File(outputDirName + packageName.replace('.', '_') + ".rs");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.append("/// Generated code for SBE package ").append(packageName).append("\n\n");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to write header for : " + outputDirName, ex);
        }
    }

    @Override
    public Writer createOutput(String name) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(this.outputFile.toPath(), StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        writer.append("\n/// ").append(name).append("\n");
        return writer;
    }
}

