/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Int2ObjectHashMap<V>
implements Map<Integer, V>,
Serializable {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private int[] keys;
    private Object[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Int2ObjectHashMap() {
        this(8, 0.55f, true);
    }

    public Int2ObjectHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, true);
    }

    public Int2ObjectHashMap(int initialCapacity, float loadFactor, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.keys = new int[capacity];
        this.values = new Object[capacity];
    }

    public Int2ObjectHashMap(Int2ObjectHashMap<V> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.shouldAvoidAllocation = mapToCopy.shouldAvoidAllocation;
        this.keys = (int[])mapToCopy.keys.clone();
        this.values = (Object[])mapToCopy.values.clone();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    public boolean containsKey(int key) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        Object val = this.mapNullValue(value);
        if (null != val) {
            for (Object v : this.values) {
                if (!val.equals(v)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Integer)key);
    }

    public V get(int key) {
        return this.unmapNullValue(this.getMapped(key));
    }

    protected V getMapped(int key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index]) && key != this.keys[index]) {
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        V value = this.getMapped(key);
        if (value == null) {
            value = mappingFunction.apply(key);
            if (value != null) {
                this.put(key, value);
            }
        } else {
            value = this.unmapNullValue(value);
        }
        return value;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public V put(int key, V value) {
        Object val = this.mapNullValue(value);
        Objects.requireNonNull(val, "value cannot be null");
        Object oldValue = null;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (null == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = val;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return this.unmapNullValue(oldValue);
    }

    @Override
    public V remove(Object key) {
        return this.remove((Integer)key);
    }

    public V remove(int key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index])) {
            if (key == this.keys[index]) {
                this.values[index] = null;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return this.unmapNullValue(value);
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.values, null);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getIntKey()).append('=').append(this.unmapNullValue(entryIterator.getValue()));
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = this.values[i];
            if (null == thisValue || thisValue.equals(this.mapNullValue(thatValue = that.get(this.keys[i])))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            result += Integer.hashCode(this.keys[i]) ^ value.hashCode();
        }
        return result;
    }

    protected Object mapNullValue(Object value) {
        return value;
    }

    protected V unmapNullValue(Object value) {
        return (V)value;
    }

    @Override
    public V replace(int key, V value) {
        V currentValue = this.get(key);
        if (currentValue != null) {
            currentValue = this.put(key, value);
        }
        return currentValue;
    }

    @Override
    public boolean replace(int key, V oldValue, V newValue) {
        V curValue = this.get(key);
        if (curValue == null || !Objects.equals(this.unmapNullValue(curValue), oldValue)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        int[] tempKeys = new int[newCapacity];
        Object[] tempValues = new Object[newCapacity];
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            int key = this.keys[i];
            int index = Hashing.hash(key, mask);
            while (null != tempValues[index]) {
                ++index;
                index &= mask;
            }
            tempKeys[index] = key;
            tempValues[index] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (null == this.values[index &= mask]) break;
            int hash = Hashing.hash(this.keys[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.values[index] = null;
            deleteIndex = index;
        }
    }

    public class EntryIterator
    extends AbstractIterator<Map.Entry<Integer, V>>
    implements Map.Entry<Integer, V> {
        @Override
        public Map.Entry<Integer, V> next() {
            this.findNext();
            if (Int2ObjectHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Integer, V> allocateDuplicateEntry() {
            return new MapEntry(this.getIntKey(), this.getValue());
        }

        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2ObjectHashMap.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Int2ObjectHashMap.this.unmapNullValue(Int2ObjectHashMap.this.values[this.position()]);
        }

        @Override
        public V setValue(V value) {
            Object val = Int2ObjectHashMap.this.mapNullValue(value);
            Objects.requireNonNull(val, "value cannot be null");
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int pos = this.position();
            Object oldValue = Int2ObjectHashMap.this.values[pos];
            ((Int2ObjectHashMap)Int2ObjectHashMap.this).values[pos] = val;
            return oldValue;
        }

        public final class MapEntry
        implements Map.Entry<Integer, V> {
            private final int k;
            private final V v;

            public MapEntry(int k, V v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public Integer getKey() {
                return this.k;
            }

            @Override
            public V getValue() {
                return this.v;
            }

            @Override
            public V setValue(V value) {
                return Int2ObjectHashMap.this.put(this.k, value);
            }

            @Override
            public int hashCode() {
                return Integer.hashCode(EntryIterator.this.getIntKey()) ^ (this.v != null ? this.v.hashCode() : 0);
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return e.getKey() != null && e.getKey().equals(this.k) && (e.getValue() == null && this.v == null || e.getValue().equals(this.v));
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public class KeyIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Int2ObjectHashMap.this.keys[this.position()];
        }
    }

    public class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Int2ObjectHashMap.this.unmapNullValue(Int2ObjectHashMap.this.values[this.position()]);
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T>,
    Serializable {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Int2ObjectHashMap.this.values.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] values = Int2ObjectHashMap.this.values;
            int mask = values.length - 1;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (null == values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((Int2ObjectHashMap)Int2ObjectHashMap.this).values[position] = null;
            --Int2ObjectHashMap.this.size;
            Int2ObjectHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        final void reset() {
            int capacity;
            this.remaining = Int2ObjectHashMap.this.size;
            Object[] values = Int2ObjectHashMap.this.values;
            int i = capacity = values.length;
            if (null != values[capacity - 1]) {
                for (i = 0; i < capacity && null != values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>>
    implements Serializable {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            int key = (Integer)entry.getKey();
            Object value = Int2ObjectHashMap.this.getMapped(key);
            return value != null && value.equals(Int2ObjectHashMap.this.mapNullValue(entry.getValue()));
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Int2ObjectHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Int2ObjectHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V>
    implements Serializable {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }
    }

    public final class KeySet
    extends AbstractSet<Integer>
    implements Serializable {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectHashMap.this.containsKey(o);
        }

        public boolean contains(int key) {
            return Int2ObjectHashMap.this.containsKey(key);
        }

        @Override
        public boolean remove(Object o) {
            return null != Int2ObjectHashMap.this.remove(o);
        }

        public boolean remove(int key) {
            return null != Int2ObjectHashMap.this.remove(key);
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }
    }
}

