/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.cpp;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ValidationUtil;
import uk.co.real_logic.sbe.generation.Generators;

public class CppUtil {
    private static final Map<PrimitiveType, String> PRIMITIVE_TYPE_STRING_ENUM_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String cppTypeName(PrimitiveType primitiveType) {
        return PRIMITIVE_TYPE_STRING_ENUM_MAP.get((Object)primitiveType);
    }

    public static String formatPropertyName(String value) {
        return CppUtil.formatForCppKeyword(Generators.toLowerFirstChar(value));
    }

    public static String formatForCppKeyword(String value) {
        if (ValidationUtil.isCppKeyword(value)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + value + "' please correct the schema or consider setting system property: " + "sbe.keyword.append.token");
            }
            return value + keywordAppendToken;
        }
        return value;
    }

    public static String formatClassName(String value) {
        return Generators.toUpperFirstChar(value);
    }

    public static String formatByteOrderEncoding(ByteOrder byteOrder, PrimitiveType primitiveType) {
        switch (primitiveType.size()) {
            case 2: {
                return "SBE_" + byteOrder + "_ENCODE_16";
            }
            case 4: {
                return "SBE_" + byteOrder + "_ENCODE_32";
            }
            case 8: {
                return "SBE_" + byteOrder + "_ENCODE_64";
            }
        }
        return "";
    }

    public static String closingBraces(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("}\n");
        }
        return sb.toString();
    }

    static CharSequence generateLiteral(PrimitiveType type, String value) {
        String literal = "";
        switch (type) {
            case CHAR: 
            case UINT8: 
            case UINT16: 
            case INT8: 
            case INT16: {
                literal = "static_cast<" + CppUtil.cppTypeName(type) + ">(" + value + ")";
                break;
            }
            case UINT32: {
                literal = "UINT32_C(0x" + Integer.toHexString((int)Long.parseLong(value)) + ")";
                break;
            }
            case INT32: {
                long intValue = Long.parseLong(value);
                if (intValue == Integer.MIN_VALUE) {
                    literal = "INT32_MIN";
                    break;
                }
                literal = "INT32_C(" + value + ")";
                break;
            }
            case FLOAT: {
                literal = value.endsWith("NaN") ? "SBE_FLOAT_NAN" : value + "f";
                break;
            }
            case INT64: {
                long longValue = Long.parseLong(value);
                if (longValue == Long.MIN_VALUE) {
                    literal = "INT64_MIN";
                    break;
                }
                literal = "INT64_C(" + value + ")";
                break;
            }
            case UINT64: {
                literal = "UINT64_C(0x" + Long.toHexString(Long.parseLong(value)) + ")";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "SBE_DOUBLE_NAN" : value;
            }
        }
        return literal;
    }

    static {
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.CHAR, "char");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT8, "std::int8_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT16, "std::int16_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT32, "std::int32_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT64, "std::int64_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT8, "std::uint8_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT16, "std::uint16_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT32, "std::uint32_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT64, "std::uint64_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.FLOAT, "float");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.DOUBLE, "double");
    }
}

