/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.java;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.agrona.LangUtil;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.java.JavaUtil;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class JavaDtoGenerator
implements CodeGenerator {
    private static final Predicate<Token> ALWAYS_FALSE_PREDICATE = ignored -> false;
    private static final String INDENT = "    ";
    private static final String BASE_INDENT = "";
    private final Ir ir;
    private final OutputManager outputManager;

    public JavaDtoGenerator(Ir ir, OutputManager outputManager) {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    @Override
    public void generate() throws IOException {
        this.generateDtosForTypes();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String encoderClassName = JavaUtil.encoderName(msgToken.name());
            String decoderClassName = JavaUtil.decoderName(msgToken.name());
            String dtoClassName = JavaDtoGenerator.formatDtoClassName(msgToken.name());
            List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
            int offset = 0;
            ClassBuilder classBuilder = new ClassBuilder(dtoClassName, BASE_INDENT, "public final");
            ArrayList<Token> fields = new ArrayList<Token>();
            offset = GenerationUtil.collectFields(messageBody, offset, fields);
            this.generateFields(classBuilder, decoderClassName, fields, INDENT);
            ArrayList<Token> groups = new ArrayList<Token>();
            offset = GenerationUtil.collectGroups(messageBody, offset, groups);
            this.generateGroups(classBuilder, dtoClassName, encoderClassName, decoderClassName, groups, INDENT);
            ArrayList<Token> varData = new ArrayList<Token>();
            GenerationUtil.collectVarData(messageBody, offset, varData);
            this.generateVarData(classBuilder, varData, INDENT);
            this.generateDecodeWith(classBuilder, dtoClassName, decoderClassName, fields, groups, varData, INDENT, fieldToken -> fieldToken.version() > msgToken.version());
            JavaDtoGenerator.generateDecodeFrom(classBuilder, dtoClassName, decoderClassName, INDENT);
            this.generateEncodeWith(classBuilder, dtoClassName, encoderClassName, fields, groups, varData, INDENT);
            JavaDtoGenerator.generateEncodeWithOverloads(classBuilder, dtoClassName, encoderClassName, INDENT);
            this.generateComputeEncodedLength(classBuilder, decoderClassName, decoderClassName + ".BLOCK_LENGTH", groups, varData, INDENT);
            this.generateDisplay(classBuilder, encoderClassName, "computeEncodedLength()", INDENT);
            Writer out = this.outputManager.createOutput(dtoClassName);
            Throwable throwable = null;
            try {
                out.append(JavaDtoGenerator.generateDtoFileHeader(this.ir.applicableNamespace()));
                out.append("import org.agrona.DirectBuffer;\n");
                out.append("import org.agrona.MutableDirectBuffer;\n");
                out.append("import org.agrona.concurrent.UnsafeBuffer;\n\n");
                out.append("import java.util.ArrayList;\n");
                out.append("import java.util.List;\n\n");
                out.append(JavaDtoGenerator.generateDocumentation(BASE_INDENT, msgToken));
                classBuilder.appendTo(out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private void generateGroups(ClassBuilder classBuilder, String qualifiedParentDtoClassName, String qualifiedParentEncoderClassName, String qualifiedParentDecoderClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String groupClassName = JavaDtoGenerator.formatDtoClassName(groupName);
            String qualifiedDtoClassName = qualifiedParentDtoClassName + "." + groupClassName;
            Token dimToken = tokens.get(i + 1);
            if (dimToken.signal() != Signal.BEGIN_COMPOSITE) {
                throw new IllegalStateException("groups must start with BEGIN_COMPOSITE: token=" + dimToken);
            }
            int sinceVersion = dimToken.version();
            String fieldName = JavaDtoGenerator.formatFieldName(groupName);
            String formattedPropertyName = JavaUtil.formatPropertyName(groupName);
            classBuilder.appendField().append(indent).append("private List<").append(qualifiedDtoClassName).append("> ").append(fieldName).append(" = new ArrayList<>();\n");
            ClassBuilder groupClassBuilder = new ClassBuilder(groupClassName, indent, "public static final");
            ++i;
            i += tokens.get(i).componentTokenCount();
            String qualifiedEncoderClassName = qualifiedParentEncoderClassName + "." + JavaUtil.encoderName(groupName);
            String qualifiedDecoderClassName = qualifiedParentDecoderClassName + "." + JavaUtil.decoderName(groupName);
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            this.generateFields(groupClassBuilder, qualifiedDecoderClassName, fields, indent + INDENT);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateGroups(groupClassBuilder, qualifiedDtoClassName, qualifiedEncoderClassName, qualifiedDecoderClassName, groups, indent + INDENT);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            this.generateVarData(groupClassBuilder, varData, indent + INDENT);
            Predicate<Token> wasAddedAfterGroup = token -> {
                boolean addedAfterParent;
                boolean bl = addedAfterParent = token.version() > sinceVersion;
                if (addedAfterParent && token.signal() == Signal.BEGIN_VAR_DATA) {
                    throw new IllegalStateException("Cannot extend var data inside a group.");
                }
                return addedAfterParent;
            };
            this.generateDecodeListWith(groupClassBuilder, groupClassName, qualifiedDecoderClassName, indent + INDENT);
            this.generateDecodeWith(groupClassBuilder, groupClassName, qualifiedDecoderClassName, fields, groups, varData, indent + INDENT, wasAddedAfterGroup);
            this.generateEncodeWith(groupClassBuilder, groupClassName, qualifiedEncoderClassName, fields, groups, varData, indent + INDENT);
            this.generateComputeEncodedLength(groupClassBuilder, qualifiedDecoderClassName, qualifiedDecoderClassName + ".sbeBlockLength()", groups, varData, indent + INDENT);
            groupClassBuilder.appendTo(classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, groupToken)));
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, groupToken)).append(indent).append("public List<").append(qualifiedDtoClassName).append("> ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, groupToken)).append(indent).append("public void ").append(formattedPropertyName).append("(").append("List<").append(qualifiedDtoClassName).append("> value)").append(indent).append("{\n").append(indent).append(INDENT).append(fieldName).append(" = value;\n").append(indent).append("}\n");
        }
    }

    private void generateComputeEncodedLength(ClassBuilder classBuilder, String qualifiedDecoderClassName, String blockLengthExpression, List<Token> groupTokens, List<Token> varDataTokens, String indent) {
        int i;
        StringBuilder lengthBuilder = classBuilder.appendPublic().append("\n").append(indent).append("public int computeEncodedLength()\n").append(indent).append("{\n");
        lengthBuilder.append(indent).append(INDENT).append("int encodedLength = 0;\n");
        lengthBuilder.append(indent).append(INDENT).append("encodedLength += ").append(blockLengthExpression).append(";\n\n");
        int size = groupTokens.size();
        for (i = 0; i < size; ++i) {
            Token groupToken = groupTokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            ++i;
            i += groupTokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(groupTokens, i, fields);
            ArrayList<Token> subGroups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(groupTokens, i, subGroups);
            ArrayList<Token> subVarData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(groupTokens, i, subVarData);
            String groupName = groupToken.name();
            String fieldName = JavaDtoGenerator.formatFieldName(groupName);
            String groupDecoderClassName = qualifiedDecoderClassName + "." + JavaUtil.decoderName(groupName);
            String groupDtoClassName = JavaDtoGenerator.formatDtoClassName(groupName);
            lengthBuilder.append(indent).append(INDENT).append("encodedLength += ").append(groupDecoderClassName).append(".sbeHeaderSize();\n\n").append(indent).append(INDENT).append("for (").append(groupDtoClassName).append(" group : ").append(fieldName).append(")\n").append(indent).append(INDENT).append("{\n").append(indent).append(INDENT).append(INDENT).append("encodedLength += group.computeEncodedLength();\n").append(indent).append(INDENT).append("}\n\n");
        }
        size = varDataTokens.size();
        for (i = 0; i < size; ++i) {
            Token token = varDataTokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            Token varDataToken = Generators.findFirst("varData", varDataTokens, i);
            String fieldName = JavaDtoGenerator.formatFieldName(propertyName);
            lengthBuilder.append(indent).append(INDENT).append("encodedLength += ").append(qualifiedDecoderClassName).append(".").append(JavaUtil.formatPropertyName(propertyName)).append("HeaderLength();\n");
            String characterEncoding = varDataToken.encoding().characterEncoding();
            String lengthAccessor = characterEncoding == null ? ".length" : ".length()";
            lengthBuilder.append(indent).append(INDENT).append("encodedLength += ").append(fieldName).append(lengthAccessor);
            int elementByteLength = varDataToken.encoding().primitiveType().size();
            if (elementByteLength != 1) {
                lengthBuilder.append(" * ").append(elementByteLength);
            }
            lengthBuilder.append(";\n\n");
        }
        lengthBuilder.append(indent).append(INDENT).append("return encodedLength;\n").append(indent).append("}\n");
    }

    private void generateCompositeDecodeWith(ClassBuilder classBuilder, String dtoClassName, String decoderClassName, List<Token> tokens, String indent) {
        StringBuilder decodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("public static void decodeWith(").append(decoderClassName).append(" decoder, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n");
        for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            this.generateFieldDecodeWith(decodeBuilder, token, token, decoderClassName, indent + INDENT, ALWAYS_FALSE_PREDICATE);
        }
        decodeBuilder.append(indent).append("}\n");
    }

    private void generateCompositeEncodeWith(ClassBuilder classBuilder, String dtoClassName, String encoderClassName, List<Token> tokens, String indent) {
        StringBuilder encodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("public static void encodeWith(").append(encoderClassName).append(" encoder, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n");
        for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            this.generateFieldEncodeWith(encodeBuilder, token, token, indent + INDENT);
        }
        encodeBuilder.append(indent).append("}\n");
    }

    private void generateDecodeListWith(ClassBuilder classBuilder, String dtoClassName, String decoderClassName, String indent) {
        classBuilder.appendPublic().append("\n").append(indent).append("public static List<").append(dtoClassName).append("> decodeManyWith(").append(decoderClassName).append(" decoder)\n").append(indent).append("{\n").append(indent).append(INDENT).append("List<").append(dtoClassName).append("> dtos = new ArrayList<>(decoder.count());\n").append(indent).append(INDENT).append("while (decoder.hasNext())\n").append(indent).append(INDENT).append("{\n").append(indent).append(INDENT).append(INDENT).append(dtoClassName).append(" dto = new ").append(dtoClassName).append("();\n").append(indent).append(INDENT).append(INDENT).append(dtoClassName).append(".decodeWith(decoder.next(), dto);\n").append(indent).append(INDENT).append(INDENT).append("dtos.add(dto);\n").append(indent).append(INDENT).append("}\n").append(indent).append(INDENT).append("return dtos;\n").append(indent).append("}\n");
    }

    private void generateDecodeWith(ClassBuilder classBuilder, String dtoClassName, String decoderClassName, List<Token> fields, List<Token> groups, List<Token> varData, String indent, Predicate<Token> wasAddedAfterParent) {
        StringBuilder decodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("public static void decodeWith(").append(decoderClassName).append(" decoder, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n");
        this.generateMessageFieldsDecodeWith(decodeBuilder, fields, decoderClassName, indent + INDENT, wasAddedAfterParent);
        this.generateGroupsDecodeWith(decodeBuilder, groups, indent + INDENT);
        this.generateVarDataDecodeWith(decodeBuilder, decoderClassName, varData, indent + INDENT, wasAddedAfterParent);
        decodeBuilder.append(indent).append("}\n");
    }

    private static void generateDecodeFrom(ClassBuilder classBuilder, String dtoClassName, String decoderClassName, String indent) {
        classBuilder.appendPublic().append("\n").append(indent).append("public static ").append(dtoClassName).append(" decodeFrom(").append("DirectBuffer buffer, int offset, ").append("short actingBlockLength, short actingVersion)\n").append(indent).append("{\n").append(indent).append(INDENT).append(decoderClassName).append(" decoder = new ").append(decoderClassName).append("();\n").append(indent).append(INDENT).append("decoder.wrap(buffer, offset, actingBlockLength, actingVersion);\n").append(indent).append(INDENT).append(dtoClassName).append(" dto = new ").append(dtoClassName).append("();\n").append(indent).append(INDENT).append("decodeWith(decoder, dto);\n").append(indent).append(INDENT).append("return dto;\n").append(indent).append("}\n");
    }

    private void generateMessageFieldsDecodeWith(StringBuilder sb, List<Token> tokens, String decoderClassName, String indent, Predicate<Token> wasAddedAfterParent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            this.generateFieldDecodeWith(sb, signalToken, encodingToken, decoderClassName, indent, wasAddedAfterParent);
        }
    }

    private void generateFieldDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String decoderClassName, String indent, Predicate<Token> wasAddedAfterParent) {
        switch (typeToken.signal()) {
            case ENCODING: {
                this.generatePrimitiveDecodeWith(sb, fieldToken, typeToken, decoderClassName, indent, wasAddedAfterParent);
                break;
            }
            case BEGIN_SET: {
                String bitSetName = JavaDtoGenerator.formatDtoClassName(typeToken.applicableTypeName());
                this.generateBitSetDecodeWith(sb, decoderClassName, fieldToken, bitSetName, indent, wasAddedAfterParent);
                break;
            }
            case BEGIN_ENUM: {
                this.generateEnumDecodeWith(sb, fieldToken, indent);
                break;
            }
            case BEGIN_COMPOSITE: {
                this.generateCompositePropertyDecodeWith(sb, fieldToken, typeToken, indent);
                break;
            }
        }
    }

    private void generatePrimitiveDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String decoderClassName, String indent, Predicate<Token> wasAddedAfterParent) {
        if (typeToken.isConstantEncoding()) {
            return;
        }
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            String decoderNullValue = decoderClassName + "." + JavaUtil.formatPropertyName(fieldToken.name()) + "NullValue()";
            if (fieldToken.isConstantEncoding()) {
                return;
            }
            String propertyName = fieldToken.name();
            String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
            this.generateRecordPropertyAssignment(sb, fieldToken, indent, "decoder.actingVersion() >= " + decoderClassName + "." + formattedPropertyName + "SinceVersion()", "decoder." + formattedPropertyName + "()", decoderNullValue, wasAddedAfterParent);
        } else if (arrayLength > 1) {
            this.generateArrayDecodeWith(sb, decoderClassName, fieldToken, typeToken, indent, wasAddedAfterParent);
        }
    }

    private void generateArrayDecodeWith(StringBuilder sb, String decoderClassName, Token fieldToken, Token typeToken, String indent, Predicate<Token> wasAddedAfterParent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        PrimitiveType primitiveType = typeToken.encoding().primitiveType();
        if (primitiveType == PrimitiveType.CHAR) {
            this.generateRecordPropertyAssignment(sb, fieldToken, indent, "decoder.actingVersion() >= " + decoderClassName + "." + formattedPropertyName + "SinceVersion()", "decoder." + formattedPropertyName + "()", "\"\"", wasAddedAfterParent);
        } else {
            StringBuilder initializerList = new StringBuilder();
            String elementType = JavaUtil.javaTypeName(primitiveType);
            initializerList.append("new ").append(elementType).append("[] { ");
            int arrayLength = typeToken.arrayLength();
            for (int i = 0; i < arrayLength; ++i) {
                initializerList.append("decoder.").append(formattedPropertyName).append("(").append(i).append("),");
            }
            assert (arrayLength > 0);
            initializerList.setLength(initializerList.length() - 1);
            initializerList.append(" }");
            this.generateRecordPropertyAssignment(sb, fieldToken, indent, "decoder.actingVersion() >= " + decoderClassName + "." + formattedPropertyName + "SinceVersion()", initializerList, "new " + elementType + "[0]", wasAddedAfterParent);
        }
    }

    private void generateBitSetDecodeWith(StringBuilder sb, String decoderClassName, Token fieldToken, String dtoTypeName, String indent, Predicate<Token> wasAddedAfterParent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        if (wasAddedAfterParent.test(fieldToken)) {
            sb.append(indent).append("if (decoder.actingVersion() >= ").append(decoderClassName).append(".").append(formattedPropertyName).append("SinceVersion())\n").append(indent).append("{\n");
            sb.append(indent).append(INDENT).append(dtoTypeName).append(".decodeWith(decoder.").append(formattedPropertyName).append("(), ").append("dto.").append(formattedPropertyName).append("());\n");
            sb.append(indent).append("}\n").append(indent).append("else\n").append(indent).append("{\n").append(indent).append(INDENT).append("dto.").append(formattedPropertyName).append("().clear();\n").append(indent).append("}\n");
        } else {
            sb.append(indent).append(dtoTypeName).append(".decodeWith(decoder.").append(formattedPropertyName).append("(), ").append("dto.").append(formattedPropertyName).append("());\n");
        }
    }

    private void generateEnumDecodeWith(StringBuilder sb, Token fieldToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        sb.append(indent).append("dto.").append(formattedPropertyName).append("(").append("decoder.").append(formattedPropertyName).append("());\n");
    }

    private void generateCompositePropertyDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        String propertyName = fieldToken.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        String dtoClassName = JavaDtoGenerator.formatDtoClassName(typeToken.applicableTypeName());
        sb.append(indent).append(dtoClassName).append(".decodeWith(decoder.").append(formattedPropertyName).append("(), ").append("dto.").append(formattedPropertyName).append("());\n");
    }

    private void generateGroupsDecodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String formattedPropertyName = JavaUtil.formatPropertyName(groupName);
            String groupDtoClassName = JavaDtoGenerator.formatDtoClassName(groupName);
            sb.append(indent).append("dto.").append(formattedPropertyName).append("(").append(groupDtoClassName).append(".decodeManyWith(decoder.").append(formattedPropertyName).append("()));\n");
            ++i;
            i += tokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
        }
    }

    private void generateVarDataDecodeWith(StringBuilder sb, String decoderClassName, List<Token> tokens, String indent, Predicate<Token> wasAddedAfterParent) {
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            boolean isOptional = wasAddedAfterParent.test(token);
            String blockIndent = isOptional ? indent + INDENT : indent;
            String dataVar = Generators.toLowerFirstChar(propertyName) + "Data";
            StringBuilder decoderValueExtraction = new StringBuilder();
            if (characterEncoding == null) {
                decoderValueExtraction.append(blockIndent).append("byte[] ").append(dataVar).append(" = new byte[decoder.").append(formattedPropertyName).append("Length()];\n").append(blockIndent).append("decoder.get").append(Generators.toUpperFirstChar(formattedPropertyName)).append("(").append(dataVar).append(", 0, decoder.").append(formattedPropertyName).append("Length());\n");
            } else {
                decoderValueExtraction.append(blockIndent).append("String ").append(dataVar).append(" = decoder.").append(formattedPropertyName).append("();\n");
            }
            if (isOptional) {
                sb.append(indent).append("if (decoder.actingVersion() >= ").append(decoderClassName).append(".").append(formattedPropertyName).append("SinceVersion())\n").append(indent).append("{\n");
                sb.append((CharSequence)decoderValueExtraction);
                sb.append(indent).append(INDENT).append("dto.").append(formattedPropertyName).append("(").append(dataVar).append(");\n");
                String nullDtoValue = characterEncoding == null ? "new byte[0]" : "\"\"";
                sb.append(indent).append("}\n").append(indent).append("else\n").append(indent).append("{\n").append(indent).append(INDENT).append("dto.").append(formattedPropertyName).append("(").append(nullDtoValue).append(");\n").append(indent).append("}\n");
                continue;
            }
            sb.append((CharSequence)decoderValueExtraction);
            sb.append(indent).append("dto.").append(formattedPropertyName).append("(").append(dataVar).append(");\n");
        }
    }

    private void generateRecordPropertyAssignment(StringBuilder sb, Token token, String indent, String presenceExpression, CharSequence getExpression, String nullDecoderValue, Predicate<Token> wasAddedAfterParent) {
        String propertyName = token.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        if (wasAddedAfterParent.test(token)) {
            sb.append(indent).append("if (").append(presenceExpression).append(")\n").append(indent).append("{\n");
            sb.append(indent).append(INDENT).append("dto.").append(formattedPropertyName).append("(").append(getExpression).append(");\n");
            sb.append(indent).append("}\n").append(indent).append("else\n").append(indent).append("{\n").append(indent).append(INDENT).append("dto.").append(formattedPropertyName).append("(").append(nullDecoderValue).append(");\n").append(indent).append("}\n");
        } else {
            sb.append(indent).append("dto.").append(formattedPropertyName).append("(").append(getExpression).append(");\n");
        }
    }

    private void generateEncodeWith(ClassBuilder classBuilder, String dtoClassName, String encoderClassName, List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        StringBuilder encodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("public static void encodeWith(").append(encoderClassName).append(" encoder, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n");
        this.generateFieldsEncodeWith(encodeBuilder, fields, indent + INDENT);
        this.generateGroupsEncodeWith(encodeBuilder, encoderClassName, groups, indent + INDENT);
        this.generateVarDataEncodeWith(encodeBuilder, varData, indent + INDENT);
        encodeBuilder.append(indent).append("}\n");
    }

    private static void generateEncodeWithOverloads(ClassBuilder classBuilder, String dtoClassName, String encoderClassName, String indent) {
        classBuilder.appendPublic().append("\n").append(indent).append("public static int encodeWith(").append(dtoClassName).append(" dto, ").append("MutableDirectBuffer buffer, int offset)\n").append(indent).append("{\n").append(indent).append(INDENT).append(encoderClassName).append(" encoder = new ").append(encoderClassName).append("();\n").append(indent).append(INDENT).append("encoder.wrap(buffer, offset);\n").append(indent).append(INDENT).append("encodeWith(encoder, dto);\n").append(indent).append(INDENT).append("return encoder.encodedLength();\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(indent).append("public static int encodeWithHeaderWith(").append(dtoClassName).append(" dto, ").append("MutableDirectBuffer buffer, int offset)\n").append(indent).append("{\n").append(indent).append(INDENT).append(encoderClassName).append(" encoder = new ").append(encoderClassName).append("();\n").append(indent).append(INDENT).append("encoder.wrapAndApplyHeader(buffer, offset, new MessageHeaderEncoder());\n").append(indent).append(INDENT).append("encodeWith(encoder, dto);\n").append(indent).append(INDENT).append("return encoder.limit() - offset;\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(indent).append("public static byte[] bytes(").append(dtoClassName).append(" dto)\n").append(indent).append("{\n").append(indent).append(INDENT).append("byte[] bytes = new byte[dto.computeEncodedLength()];\n").append(indent).append(INDENT).append("encodeWith(dto, new UnsafeBuffer(bytes), 0);\n").append(indent).append(INDENT).append("return bytes;\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(indent).append("public static byte[] bytesWithHeader(").append(dtoClassName).append(" dto)\n").append(indent).append("{\n").append(indent).append(INDENT).append("byte[] bytes = new byte[dto.computeEncodedLength() + ").append("MessageHeaderEncoder.ENCODED_LENGTH];\n").append(indent).append(INDENT).append("encodeWithHeaderWith(dto, new UnsafeBuffer(bytes), 0);\n").append(indent).append(INDENT).append("return bytes;\n").append(indent).append("}\n");
    }

    private void generateFieldsEncodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            this.generateFieldEncodeWith(sb, signalToken, encodingToken, indent);
        }
    }

    private void generateFieldEncodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        switch (typeToken.signal()) {
            case ENCODING: {
                this.generatePrimitiveEncodeWith(sb, fieldToken, typeToken, indent);
                break;
            }
            case BEGIN_ENUM: {
                this.generateEnumEncodeWith(sb, fieldToken, indent);
                break;
            }
            case BEGIN_SET: 
            case BEGIN_COMPOSITE: {
                this.generateComplexPropertyEncodeWith(sb, fieldToken, typeToken, indent);
                break;
            }
        }
    }

    private void generatePrimitiveEncodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.isConstantEncoding()) {
            return;
        }
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            this.generatePrimitiveValueEncodeWith(sb, fieldToken, indent);
        } else if (arrayLength > 1) {
            this.generateArrayEncodeWith(sb, fieldToken, typeToken, indent);
        }
    }

    private void generateArrayEncodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        PrimitiveType primitiveType = typeToken.encoding().primitiveType();
        if (primitiveType == PrimitiveType.CHAR) {
            sb.append(indent).append("encoder.").append(Generators.toLowerFirstChar(propertyName)).append("(").append("dto.").append(formattedPropertyName).append("());\n");
        } else {
            String javaTypeName = JavaUtil.javaTypeName(primitiveType);
            sb.append(indent).append(javaTypeName).append("[] ").append(formattedPropertyName).append(" = ").append("dto.").append(formattedPropertyName).append("();\n").append(indent).append("for (int i = 0; i < ").append(formattedPropertyName).append(".length; i++)\n").append(indent).append("{\n").append(indent).append(INDENT).append("encoder.").append(formattedPropertyName).append("(").append("i, ").append(formattedPropertyName).append("[i]);\n").append(indent).append("}\n");
        }
    }

    private void generatePrimitiveValueEncodeWith(StringBuilder sb, Token fieldToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        String accessor = "dto." + formattedPropertyName + "()";
        sb.append(indent).append("encoder.").append(formattedPropertyName).append("(").append(accessor).append(");\n");
    }

    private void generateEnumEncodeWith(StringBuilder sb, Token fieldToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        sb.append(indent).append("encoder.").append(formattedPropertyName).append("(dto.").append(formattedPropertyName).append("());\n");
    }

    private void generateComplexPropertyEncodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        String propertyName = fieldToken.name();
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        String typeName = JavaDtoGenerator.formatDtoClassName(typeToken.applicableTypeName());
        sb.append(indent).append(typeName).append(".encodeWith(encoder.").append(formattedPropertyName).append("(), dto.").append(formattedPropertyName).append("());\n");
    }

    private void generateGroupsEncodeWith(StringBuilder sb, String parentEncoderClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String formattedPropertyName = JavaUtil.formatPropertyName(groupName);
            String groupEncoderVarName = groupName + "Encoder";
            String groupDtoTypeName = JavaDtoGenerator.formatDtoClassName(groupName);
            String groupEncoderTypeName = parentEncoderClassName + "." + JavaUtil.encoderName(groupName);
            sb.append("\n").append(indent).append("List<").append(groupDtoTypeName).append("> ").append(formattedPropertyName).append(" = dto.").append(formattedPropertyName).append("();\n\n").append(indent).append(groupEncoderTypeName).append(" ").append(groupEncoderVarName).append(" = encoder.").append(formattedPropertyName).append("Count(").append(formattedPropertyName).append(".size());\n\n").append(indent).append("for (").append(groupDtoTypeName).append(" group : ").append(formattedPropertyName).append(")\n").append(indent).append("{\n").append(indent).append(INDENT).append(groupDtoTypeName).append(".encodeWith(").append(groupEncoderVarName).append(".next(), group);\n").append(indent).append("}\n\n");
            ++i;
            i += tokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
        }
    }

    private void generateVarDataEncodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            if (characterEncoding == null) {
                sb.append(indent).append("encoder.put").append(Generators.toUpperFirstChar(propertyName)).append("(").append("dto.").append(formattedPropertyName).append("(),").append("0,").append("dto.").append(formattedPropertyName).append("().length);\n");
                continue;
            }
            sb.append(indent).append("encoder.").append(formattedPropertyName).append("(").append("dto.").append(formattedPropertyName).append("());\n");
        }
    }

    private void generateDisplay(ClassBuilder classBuilder, String encoderClassName, String lengthExpression, String indent) {
        StringBuilder sb = classBuilder.appendPublic();
        sb.append("\n").append(indent).append("public String toString()\n").append(indent).append("{\n").append(indent).append(INDENT).append("MutableDirectBuffer buffer = new UnsafeBuffer(new byte[").append(lengthExpression).append("]);\n").append(indent).append(INDENT).append(encoderClassName).append(" encoder = new ").append(encoderClassName).append("();\n").append(indent).append(INDENT).append("encoder.");
        sb.append("wrap").append("(buffer, 0);\n");
        sb.append(indent).append(INDENT).append("encodeWith(encoder, this);\n").append(indent).append(INDENT).append("StringBuilder sb = new StringBuilder();\n").append(indent).append(INDENT).append("encoder.appendTo(sb);\n").append(indent).append(INDENT).append("return sb.toString();\n").append(indent).append("}\n");
    }

    private void generateFields(ClassBuilder classBuilder, String decoderClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        block5: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = signalToken.name();
            switch (encodingToken.signal()) {
                case ENCODING: {
                    this.generatePrimitiveProperty(classBuilder, decoderClassName, propertyName, signalToken, encodingToken, indent);
                    continue block5;
                }
                case BEGIN_ENUM: {
                    this.generateEnumProperty(classBuilder, propertyName, signalToken, encodingToken, indent);
                    continue block5;
                }
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: {
                    this.generateComplexProperty(classBuilder, propertyName, signalToken, encodingToken, indent);
                    continue block5;
                }
            }
        }
    }

    private void generateComplexProperty(ClassBuilder classBuilder, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String typeName = JavaDtoGenerator.formatDtoClassName(typeToken.applicableTypeName());
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        String fieldName = JavaDtoGenerator.formatFieldName(propertyName);
        classBuilder.appendField().append(indent).append("private ").append(typeName).append(" ").append(fieldName).append(" = new ").append(typeName).append("();\n");
        classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(typeName).append(" ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public void ").append(formattedPropertyName).append("(").append(typeName).append(" value)\n").append(indent).append("{\n").append(indent).append(INDENT).append(fieldName).append(" = value;\n").append(indent).append("}\n");
    }

    private void generateEnumProperty(ClassBuilder classBuilder, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String enumName = JavaUtil.formatClassName(typeToken.applicableTypeName());
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        if (fieldToken.isConstantEncoding()) {
            String constValue = fieldToken.encoding().constValue().toString();
            String caseName = constValue.substring(constValue.indexOf(".") + 1);
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public static ").append(enumName).append(" ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(enumName).append(".").append(caseName).append(";\n").append(indent).append("}\n");
        } else {
            String fieldName = JavaDtoGenerator.formatFieldName(propertyName);
            classBuilder.appendField().append(indent).append("private ").append(enumName).append(" ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(enumName).append(" ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public void ").append(formattedPropertyName).append("(").append(enumName).append(" value)\n").append(indent).append("{\n").append(indent).append(INDENT).append(fieldName).append(" = value;\n").append(indent).append("}\n");
        }
    }

    private void generatePrimitiveProperty(ClassBuilder classBuilder, String decoderClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.isConstantEncoding()) {
            this.generateConstPropertyMethods(classBuilder, propertyName, fieldToken, typeToken, indent);
        } else {
            this.generatePrimitivePropertyMethods(classBuilder, decoderClassName, propertyName, fieldToken, typeToken, indent);
        }
    }

    private void generatePrimitivePropertyMethods(ClassBuilder classBuilder, String decoderClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            this.generateSingleValueProperty(classBuilder, decoderClassName, propertyName, fieldToken, typeToken, indent);
        } else if (arrayLength > 1) {
            this.generateArrayProperty(classBuilder, decoderClassName, propertyName, fieldToken, typeToken, indent);
        }
    }

    private void generateArrayProperty(ClassBuilder classBuilder, String decoderClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        String fieldName = JavaDtoGenerator.formatFieldName(propertyName);
        String validateMethod = "validate" + Generators.toUpperFirstChar(propertyName);
        PrimitiveType primitiveType = typeToken.encoding().primitiveType();
        if (primitiveType == PrimitiveType.CHAR) {
            String typeName = "String";
            classBuilder.appendField().append(indent).append("private ").append((CharSequence)typeName).append(" ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append((CharSequence)typeName).append(" ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("void ").append(formattedPropertyName).append("(").append((CharSequence)typeName).append(" value)\n").append(indent).append("{\n").append(indent).append(INDENT).append(validateMethod).append("(value);\n").append(indent).append(INDENT).append(fieldName).append(" = value;\n").append(indent).append("}\n");
            JavaDtoGenerator.generateArrayValidateMethod(classBuilder, decoderClassName, indent, validateMethod, typeName, ".length()", formattedPropertyName);
        } else {
            String elementTypeName = JavaUtil.javaTypeName(primitiveType);
            String typeName = elementTypeName + "[]";
            classBuilder.appendField().append(indent).append("private ").append(typeName).append(" ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(typeName).append(" ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public void ").append(formattedPropertyName).append("(").append(typeName).append(" value").append(")\n").append(indent).append("{\n").append(indent).append(INDENT).append(validateMethod).append("(value);\n").append(indent).append(INDENT).append(fieldName).append(" = value;\n").append(indent).append("}\n");
            JavaDtoGenerator.generateArrayValidateMethod(classBuilder, decoderClassName, indent, validateMethod, typeName, ".length", formattedPropertyName);
        }
    }

    private static void generateArrayValidateMethod(ClassBuilder classBuilder, String decoderClassName, String indent, String validateMethod, CharSequence typeName, String lengthAccessor, String formattedPropertyName) {
        StringBuilder validateBuilder = classBuilder.appendPrivate().append("\n").append(indent).append("private static void ").append(validateMethod).append("(").append(typeName).append(" value)\n").append(indent).append("{\n");
        validateBuilder.append(indent).append(INDENT).append("if (value").append(lengthAccessor).append(" > ").append(decoderClassName).append(".").append(formattedPropertyName).append("Length())\n").append(indent).append(INDENT).append("{\n").append(indent).append(INDENT).append(INDENT).append("throw new IllegalArgumentException(\"").append(formattedPropertyName).append(": too many elements: \" + ").append("value").append(lengthAccessor).append(");\n").append(indent).append(INDENT).append("}\n").append(indent).append("}\n");
    }

    private void generateSingleValueProperty(ClassBuilder classBuilder, String decoderClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String typeName = JavaUtil.javaTypeName(typeToken.encoding().primitiveType());
        String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
        String fieldName = JavaDtoGenerator.formatFieldName(propertyName);
        String validateMethod = "validate" + Generators.toUpperFirstChar(propertyName);
        boolean representedWithinJavaType = typeToken.encoding().primitiveType() != PrimitiveType.UINT64;
        StringBuilder validationCall = new StringBuilder();
        if (representedWithinJavaType) {
            StringBuilder validateBuilder = classBuilder.appendPrivate().append("\n").append(indent).append("private static void ").append(validateMethod).append("(").append(typeName).append(" value)\n").append(indent).append("{\n");
            validateBuilder.append(indent).append(INDENT).append("if (value < ").append(decoderClassName).append(".").append(formattedPropertyName).append("MinValue() || ").append("value").append(" > ").append(decoderClassName).append(".").append(formattedPropertyName).append("MaxValue())\n").append(indent).append(INDENT).append("{\n").append(indent).append(INDENT).append(INDENT).append("throw new IllegalArgumentException(\"").append(propertyName).append(": value is out of allowed range: \" + ").append("value").append(");\n").append(indent).append(INDENT).append("}\n").append(indent).append("}\n");
            validationCall.append(indent).append(INDENT).append(validateMethod).append("(value);\n");
        }
        classBuilder.appendField().append(indent).append("private ").append(typeName).append(" ").append(fieldName).append(";\n");
        classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(typeName).append(" ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
        classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public void ").append(formattedPropertyName).append("(").append(typeName).append(" value)\n").append(indent).append("{\n").append((CharSequence)validationCall).append(indent).append(INDENT).append(fieldName).append(" = value;\n").append(indent).append("}\n");
    }

    private void generateConstPropertyMethods(ClassBuilder classBuilder, String propertyName, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public static String ").append(Generators.toLowerFirstChar(propertyName)).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return \"").append(typeToken.encoding().constValue().toString()).append("\";\n").append(indent).append("}\n");
        } else {
            String literalValue = JavaUtil.generateLiteral(typeToken.encoding().primitiveType(), typeToken.encoding().constValue().toString());
            classBuilder.appendPublic().append("\n").append(JavaDtoGenerator.generateDocumentation(indent, fieldToken)).append(indent).append("public static ").append(JavaUtil.javaTypeName(typeToken.encoding().primitiveType())).append(" ").append(JavaUtil.formatPropertyName(propertyName)).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append((CharSequence)literalValue).append(";\n").append(indent).append("}\n");
        }
    }

    private void generateVarData(ClassBuilder classBuilder, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            String dtoType = characterEncoding == null ? "byte[]" : "String";
            String fieldName = JavaDtoGenerator.formatFieldName(propertyName);
            String formattedPropertyName = JavaUtil.formatPropertyName(propertyName);
            classBuilder.appendField().append(indent).append("private ").append(dtoType).append(" ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(indent).append("public ").append(dtoType).append(" ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(indent).append("public void ").append(formattedPropertyName).append("(").append(dtoType).append(" value)\n").append(indent).append("{\n").append(indent).append(INDENT).append(fieldName).append(" = value;\n").append(indent).append("}\n");
        }
    }

    private static String formatDtoClassName(String name) {
        return JavaUtil.formatClassName(name + "Dto");
    }

    private void generateDtosForTypes() throws IOException {
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateChoiceSet(tokens);
                    break;
                }
            }
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String name = tokens.get(0).applicableTypeName();
        String className = JavaDtoGenerator.formatDtoClassName(name);
        String encoderClassName = JavaUtil.encoderName(name);
        String decoderClassName = JavaUtil.decoderName(name);
        try (Writer out = this.outputManager.createOutput(className);){
            List<Token> compositeTokens = tokens.subList(1, tokens.size() - 1);
            out.append(JavaDtoGenerator.generateDtoFileHeader(this.ir.applicableNamespace()));
            out.append("import org.agrona.DirectBuffer;\n");
            out.append("import org.agrona.MutableDirectBuffer;\n");
            out.append("import org.agrona.concurrent.UnsafeBuffer;\n\n");
            out.append(JavaDtoGenerator.generateDocumentation(BASE_INDENT, tokens.get(0)));
            ClassBuilder classBuilder = new ClassBuilder(className, BASE_INDENT, "public final");
            this.generateCompositePropertyElements(classBuilder, decoderClassName, compositeTokens, INDENT);
            this.generateCompositeDecodeWith(classBuilder, className, decoderClassName, compositeTokens, INDENT);
            this.generateCompositeEncodeWith(classBuilder, className, encoderClassName, compositeTokens, INDENT);
            this.generateDisplay(classBuilder, encoderClassName, encoderClassName + ".ENCODED_LENGTH", INDENT);
            classBuilder.appendTo(out);
        }
    }

    private void generateChoiceSet(List<Token> tokens) throws IOException {
        String name = tokens.get(0).applicableTypeName();
        String className = JavaDtoGenerator.formatDtoClassName(name);
        String encoderClassName = JavaUtil.encoderName(name);
        String decoderClassName = JavaUtil.decoderName(name);
        try (Writer out = this.outputManager.createOutput(className);){
            List<Token> setTokens = tokens.subList(1, tokens.size() - 1);
            out.append(JavaDtoGenerator.generateDtoFileHeader(this.ir.applicableNamespace()));
            out.append(JavaDtoGenerator.generateDocumentation(BASE_INDENT, tokens.get(0)));
            ClassBuilder classBuilder = new ClassBuilder(className, BASE_INDENT, "public final");
            this.generateChoices(classBuilder, className, setTokens, INDENT);
            this.generateChoiceSetDecodeWith(classBuilder, className, decoderClassName, setTokens, INDENT);
            this.generateChoiceSetEncodeWith(classBuilder, className, encoderClassName, setTokens, INDENT);
            classBuilder.appendTo(out);
        }
    }

    private void generateChoiceSetEncodeWith(ClassBuilder classBuilder, String dtoClassName, String encoderClassName, List<Token> setTokens, String indent) {
        StringBuilder encodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("public static void encodeWith(\n").append(indent).append(INDENT).append(encoderClassName).append(" encoder, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n");
        encodeBuilder.append(indent).append(INDENT).append("encoder.clear();\n");
        for (Token token : setTokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String formattedPropertyName = JavaUtil.formatPropertyName(token.name());
            encodeBuilder.append(indent).append(INDENT).append("encoder.").append(formattedPropertyName).append("(dto.").append(formattedPropertyName).append("());\n");
        }
        encodeBuilder.append(indent).append("}\n");
    }

    private void generateChoiceSetDecodeWith(ClassBuilder classBuilder, String dtoClassName, String decoderClassName, List<Token> setTokens, String indent) {
        StringBuilder decodeBuilder = classBuilder.appendPublic().append("\n").append(indent).append("public static void decodeWith(\n").append(indent).append(INDENT).append(decoderClassName).append(" decoder, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n");
        for (Token token : setTokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String formattedPropertyName = JavaUtil.formatPropertyName(token.name());
            decodeBuilder.append(indent).append(INDENT).append("dto.").append(formattedPropertyName).append("(decoder.").append(formattedPropertyName).append("());\n");
        }
        decodeBuilder.append(indent).append("}\n");
    }

    private void generateChoices(ClassBuilder classBuilder, String dtoClassName, List<Token> setTokens, String indent) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Token token : setTokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String fieldName = JavaDtoGenerator.formatFieldName(token.name());
            String formattedPropertyName = JavaUtil.formatPropertyName(token.name());
            fields.add(fieldName);
            classBuilder.appendField().append(indent).append("boolean ").append(fieldName).append(";\n");
            classBuilder.appendPublic().append("\n").append(indent).append("public boolean ").append(formattedPropertyName).append("()\n").append(indent).append("{\n").append(indent).append(INDENT).append("return ").append(fieldName).append(";\n").append(indent).append("}\n");
            classBuilder.appendPublic().append("\n").append(indent).append(dtoClassName).append(" ").append(formattedPropertyName).append("(boolean value)\n").append(indent).append("{\n").append(indent).append(INDENT).append(fieldName).append(" = value;\n").append(indent).append(INDENT).append("return this;\n").append(indent).append("}\n");
        }
        StringBuilder clearBuilder = classBuilder.appendPublic().append(indent).append(dtoClassName).append(" clear()\n").append(indent).append("{\n");
        for (String field : fields) {
            clearBuilder.append(indent).append(INDENT).append(field).append(" = false;\n");
        }
        clearBuilder.append(indent).append(INDENT).append("return this;\n").append(indent).append("}\n");
    }

    private void generateCompositePropertyElements(ClassBuilder classBuilder, String decoderClassName, List<Token> tokens, String indent) {
        block5: for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            String propertyName = JavaUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case ENCODING: {
                    this.generatePrimitiveProperty(classBuilder, decoderClassName, propertyName, token, token, indent);
                    continue block5;
                }
                case BEGIN_ENUM: {
                    this.generateEnumProperty(classBuilder, propertyName, token, token, indent);
                    continue block5;
                }
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: {
                    this.generateComplexProperty(classBuilder, propertyName, token, token, indent);
                    continue block5;
                }
            }
        }
    }

    private static CharSequence generateDtoFileHeader(String packageName) {
        StringBuilder sb = new StringBuilder();
        sb.append("/* Generated SBE (Simple Binary Encoding) message DTO */\n");
        sb.append("package ").append(packageName).append(";\n\n");
        return sb;
    }

    private static String generateDocumentation(String indent, Token token) {
        String description = token.description();
        if (null == description || description.isEmpty()) {
            return BASE_INDENT;
        }
        return indent + "/**\n" + indent + " * " + description + "\n" + indent + " */\n";
    }

    private static String formatFieldName(String propertyName) {
        return JavaUtil.formatPropertyName(propertyName);
    }

    private static final class ClassBuilder {
        private final StringBuilder fieldSb = new StringBuilder();
        private final StringBuilder privateSb = new StringBuilder();
        private final StringBuilder publicSb = new StringBuilder();
        private final String className;
        private final String indent;
        private final String modifiers;

        private ClassBuilder(String className, String indent, String modifiers) {
            this.className = className;
            this.indent = indent;
            this.modifiers = modifiers.length() == 0 ? modifiers : modifiers + " ";
        }

        public StringBuilder appendField() {
            return this.fieldSb;
        }

        public StringBuilder appendPrivate() {
            return this.privateSb;
        }

        public StringBuilder appendPublic() {
            return this.publicSb;
        }

        public void appendTo(Appendable out) {
            try {
                out.append(this.indent).append(this.modifiers).append("class ").append(this.className).append("\n").append(this.indent).append("{\n").append(this.fieldSb).append(this.privateSb).append(this.publicSb).append(this.indent).append("}\n");
            }
            catch (IOException exception) {
                LangUtil.rethrowUnchecked(exception);
            }
        }
    }
}

