/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe;

import java.util.Set;
import java.util.regex.Pattern;

public class ValidationUtil {
    private static final Pattern PATTERN = Pattern.compile("\\.");
    private static final Set<String> C_KEYWORDS = Set.of("auto", "_Alignas", "_Alignof", "_Atomic", "bool", "_Bool", "break", "case", "_Complex", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "false", "float", "for", "_Generic", "goto", "if", "_Imaginary", "inline", "int", "long", "_Noreturn", "register", "restrict", "return", "short", "signed", "sizeof", "static", "_Static_assert", "struct", "switch", "_Thread_local", "true", "typedef", "union", "unsigned", "void", "volatile", "wchar_t", "while");
    private static final Set<String> CPP_KEYWORDS = Set.of("alignas", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "class", "compl", "const", "const_cast", "continue", "char16_t", "char32_t", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "not", "not_eq", "noexcept", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "return", "short", "signed", "sizeof", "static", "static_cast", "struct", "switch", "template", "this", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq", "override", "alignof", "constexpr", "decltype", "nullptr", "static_assert", "thread_local", "final");
    private static final Set<String> JAVA_KEYWORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "null", "true", "false", "_");
    private static final Set<String> GOLANG_KEYWORDS = Set.of("break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "_", "bool", "byte", "complex64", "complex128", "error", "float32", "float64", "int", "int8", "int16", "int32", "int64", "rune", "string", "uint", "uint8", "uint16", "uint32", "uint64", "uintptr", "true", "false", "iota", "nil", "append", "cap", "close", "complex", "copy", "delete", "imag", "len", "make", "new", "panic", "print", "println", "real", "recover", "String");
    private static final Set<String> CSHARP_KEYWORDS = Set.of("abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while");

    public static boolean isSbeCName(String value) {
        if (ValidationUtil.possibleCKeyword(value)) {
            return !ValidationUtil.isCKeyword(value);
        }
        return false;
    }

    public static boolean isCKeyword(String token) {
        return C_KEYWORDS.contains(token);
    }

    private static boolean possibleCKeyword(String value) {
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (i == 0 && ValidationUtil.isSbeCIdentifierStart(c) || ValidationUtil.isSbeCIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSbeCIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private static boolean isSbeCIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean isSbeCppName(String value) {
        if (ValidationUtil.possibleCppKeyword(value)) {
            return !ValidationUtil.isCppKeyword(value);
        }
        return false;
    }

    public static boolean isCppKeyword(String token) {
        return CPP_KEYWORDS.contains(token);
    }

    private static boolean possibleCppKeyword(String value) {
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (i == 0 && ValidationUtil.isSbeCppIdentifierStart(c) || ValidationUtil.isSbeCppIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSbeCppIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private static boolean isSbeCppIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean isSbeJavaName(String value) {
        for (String token : PATTERN.split(value, -1)) {
            if (ValidationUtil.isJavaIdentifier(token)) {
                if (!ValidationUtil.isJavaKeyword(token)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isJavaKeyword(String token) {
        return JAVA_KEYWORDS.contains(token);
    }

    private static boolean isJavaIdentifier(String token) {
        if (token.isEmpty()) {
            return false;
        }
        int size = token.length();
        for (int i = 0; i < size; ++i) {
            char c = token.charAt(i);
            if (i == 0 && Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSbeGolangName(String value) {
        if (ValidationUtil.possibleGolangKeyword(value)) {
            return !ValidationUtil.isGolangKeyword(value);
        }
        return false;
    }

    public static boolean isGolangKeyword(String token) {
        return GOLANG_KEYWORDS.contains(token);
    }

    private static boolean possibleGolangKeyword(String value) {
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (i == 0 && ValidationUtil.isSbeGolangIdentifierStart(c) || ValidationUtil.isSbeGolangIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSbeGolangIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private static boolean isSbeGolangIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean isSbeCSharpName(String value) {
        if (ValidationUtil.possibleCSharpKeyword(value)) {
            return !ValidationUtil.isCSharpKeyword(value);
        }
        return false;
    }

    public static boolean isCSharpKeyword(String token) {
        return CSHARP_KEYWORDS.contains(token);
    }

    public static boolean possibleCSharpKeyword(String value) {
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (i == 0 && ValidationUtil.isSbeCSharpIdentifierStart(c) || ValidationUtil.isSbeCSharpIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSbeCSharpIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_' || c == '@';
    }

    private static boolean isSbeCSharpIdentifierPart(char c) {
        if (ValidationUtil.isSbeCSharpIdentifierStart(c)) {
            return true;
        }
        switch (Character.getType(c)) {
            case 6: 
            case 8: 
            case 9: 
            case 16: 
            case 23: {
                return true;
            }
        }
        return false;
    }
}

