/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.c;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ValidationUtil;
import uk.co.real_logic.sbe.generation.Generators;

public class CUtil {
    private static final Map<PrimitiveType, String> PRIMITIVE_TYPE_STRING_ENUM_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String cTypeName(PrimitiveType primitiveType) {
        return PRIMITIVE_TYPE_STRING_ENUM_MAP.get((Object)primitiveType);
    }

    public static String formatPropertyName(String value) {
        Object formattedValue = Generators.toLowerFirstChar(value);
        if (ValidationUtil.isCKeyword((String)formattedValue)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + (String)formattedValue + "' please correct the schema or consider setting system property: sbe.keyword.append.token");
            }
            formattedValue = (String)formattedValue + keywordAppendToken;
        }
        return formattedValue;
    }

    public static String formatName(String value) {
        return Generators.toLowerFirstChar(value);
    }

    public static String formatScopedName(CharSequence[] scope, String value) {
        return String.join((CharSequence)"_", scope).toLowerCase() + "_" + CUtil.formatName(value);
    }

    public static String formatByteOrderEncoding(ByteOrder byteOrder, PrimitiveType primitiveType) {
        switch (primitiveType.size()) {
            case 2: {
                return "SBE_" + String.valueOf(byteOrder) + "_ENCODE_16";
            }
            case 4: {
                return "SBE_" + String.valueOf(byteOrder) + "_ENCODE_32";
            }
            case 8: {
                return "SBE_" + String.valueOf(byteOrder) + "_ENCODE_64";
            }
        }
        return "";
    }

    static {
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.CHAR, "char");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT8, "int8_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT16, "int16_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT32, "int32_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT64, "int64_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT8, "uint8_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT16, "uint16_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT32, "uint32_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT64, "uint64_t");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.FLOAT, "float");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.DOUBLE, "double");
    }
}

