/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir.generated;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.sbe.ir.generated.ByteOrderCodec;
import uk.co.real_logic.sbe.ir.generated.MessageHeaderEncoder;
import uk.co.real_logic.sbe.ir.generated.MetaAttribute;
import uk.co.real_logic.sbe.ir.generated.PresenceCodec;
import uk.co.real_logic.sbe.ir.generated.PrimitiveTypeCodec;
import uk.co.real_logic.sbe.ir.generated.SignalCodec;
import uk.co.real_logic.sbe.ir.generated.TokenCodecDecoder;

public final class TokenCodecEncoder {
    private static final boolean ENABLE_BOUNDS_CHECKS = !Boolean.getBoolean("agrona.disable.bounds.checks");
    private static final boolean SBE_ENABLE_IR_PRECEDENCE_CHECKS = Boolean.parseBoolean(System.getProperty("sbe.enable.ir.precedence.checks", Boolean.toString(ENABLE_BOUNDS_CHECKS)));
    private int codecState = 0;
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final TokenCodecEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    private int codecState() {
        return this.codecState;
    }

    private void codecState(int newState) {
        this.codecState = newState;
    }

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return SEMANTIC_VERSION;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public TokenCodecEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 28);
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.codecState(1);
        }
        return this;
    }

    public TokenCodecEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(28).templateId(2).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int tokenOffsetId() {
        return 1;
    }

    public static int tokenOffsetSinceVersion() {
        return 0;
    }

    public static int tokenOffsetEncodingOffset() {
        return 0;
    }

    public static int tokenOffsetEncodingLength() {
        return 4;
    }

    public static String tokenOffsetMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onTokenOffsetAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"tokenOffset\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public static int tokenOffsetNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenOffsetMinValue() {
        return -2147483647;
    }

    public static int tokenOffsetMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder tokenOffset(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTokenOffsetAccessed();
        }
        this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int tokenSizeId() {
        return 2;
    }

    public static int tokenSizeSinceVersion() {
        return 0;
    }

    public static int tokenSizeEncodingOffset() {
        return 4;
    }

    public static int tokenSizeEncodingLength() {
        return 4;
    }

    public static String tokenSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onTokenSizeAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"tokenSize\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public static int tokenSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenSizeMinValue() {
        return -2147483647;
    }

    public static int tokenSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder tokenSize(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTokenSizeAccessed();
        }
        this.buffer.putInt(this.offset + 4, value, BYTE_ORDER);
        return this;
    }

    public static int fieldIdId() {
        return 3;
    }

    public static int fieldIdSinceVersion() {
        return 0;
    }

    public static int fieldIdEncodingOffset() {
        return 8;
    }

    public static int fieldIdEncodingLength() {
        return 4;
    }

    public static String fieldIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onFieldIdAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"fieldId\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public static int fieldIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int fieldIdMinValue() {
        return -2147483647;
    }

    public static int fieldIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder fieldId(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onFieldIdAccessed();
        }
        this.buffer.putInt(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int tokenVersionId() {
        return 4;
    }

    public static int tokenVersionSinceVersion() {
        return 0;
    }

    public static int tokenVersionEncodingOffset() {
        return 12;
    }

    public static int tokenVersionEncodingLength() {
        return 4;
    }

    public static String tokenVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onTokenVersionAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"tokenVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public static int tokenVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenVersionMinValue() {
        return -2147483647;
    }

    public static int tokenVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder tokenVersion(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTokenVersionAccessed();
        }
        this.buffer.putInt(this.offset + 12, value, BYTE_ORDER);
        return this;
    }

    public static int componentTokenCountId() {
        return 5;
    }

    public static int componentTokenCountSinceVersion() {
        return 0;
    }

    public static int componentTokenCountEncodingOffset() {
        return 16;
    }

    public static int componentTokenCountEncodingLength() {
        return 4;
    }

    public static String componentTokenCountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onComponentTokenCountAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"componentTokenCount\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public static int componentTokenCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int componentTokenCountMinValue() {
        return -2147483647;
    }

    public static int componentTokenCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder componentTokenCount(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onComponentTokenCountAccessed();
        }
        this.buffer.putInt(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int signalId() {
        return 6;
    }

    public static int signalSinceVersion() {
        return 0;
    }

    public static int signalEncodingOffset() {
        return 20;
    }

    public static int signalEncodingLength() {
        return 1;
    }

    public static String signalMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onSignalAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"signal\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public TokenCodecEncoder signal(SignalCodec value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSignalAccessed();
        }
        this.buffer.putByte(this.offset + 20, (byte)value.value());
        return this;
    }

    public static int primitiveTypeId() {
        return 7;
    }

    public static int primitiveTypeSinceVersion() {
        return 0;
    }

    public static int primitiveTypeEncodingOffset() {
        return 21;
    }

    public static int primitiveTypeEncodingLength() {
        return 1;
    }

    public static String primitiveTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onPrimitiveTypeAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"primitiveType\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public TokenCodecEncoder primitiveType(PrimitiveTypeCodec value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPrimitiveTypeAccessed();
        }
        this.buffer.putByte(this.offset + 21, (byte)value.value());
        return this;
    }

    public static int byteOrderId() {
        return 8;
    }

    public static int byteOrderSinceVersion() {
        return 0;
    }

    public static int byteOrderEncodingOffset() {
        return 22;
    }

    public static int byteOrderEncodingLength() {
        return 1;
    }

    public static String byteOrderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onByteOrderAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"byteOrder\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public TokenCodecEncoder byteOrder(ByteOrderCodec value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onByteOrderAccessed();
        }
        this.buffer.putByte(this.offset + 22, (byte)value.value());
        return this;
    }

    public static int presenceId() {
        return 9;
    }

    public static int presenceSinceVersion() {
        return 0;
    }

    public static int presenceEncodingOffset() {
        return 23;
    }

    public static int presenceEncodingLength() {
        return 1;
    }

    public static String presenceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onPresenceAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"presence\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public TokenCodecEncoder presence(PresenceCodec value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPresenceAccessed();
        }
        this.buffer.putByte(this.offset + 23, (byte)value.value());
        return this;
    }

    public static int deprecatedId() {
        return 10;
    }

    public static int deprecatedSinceVersion() {
        return 0;
    }

    public static int deprecatedEncodingOffset() {
        return 24;
    }

    public static int deprecatedEncodingLength() {
        return 4;
    }

    public static String deprecatedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return SEMANTIC_VERSION;
    }

    private void onDeprecatedAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"deprecated\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
        }
    }

    public static int deprecatedNullValue() {
        return 0;
    }

    public static int deprecatedMinValue() {
        return -2147483647;
    }

    public static int deprecatedMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder deprecated(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDeprecatedAccessed();
        }
        this.buffer.putInt(this.offset + 24, value, BYTE_ORDER);
        return this;
    }

    public static int nameId() {
        return 11;
    }

    public static String nameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String nameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int nameHeaderLength() {
        return 2;
    }

    private void onNameAccessed() {
        switch (this.codecState()) {
            case 1: {
                this.codecState(2);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"name\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder name(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int constValueId() {
        return 12;
    }

    public static String constValueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String constValueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int constValueHeaderLength() {
        return 2;
    }

    private void onConstValueAccessed() {
        switch (this.codecState()) {
            case 2: {
                this.codecState(3);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"constValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putConstValue(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putConstValue(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder constValue(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int minValueId() {
        return 13;
    }

    public static String minValueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String minValueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int minValueHeaderLength() {
        return 2;
    }

    private void onMinValueAccessed() {
        switch (this.codecState()) {
            case 3: {
                this.codecState(4);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"minValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putMinValue(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putMinValue(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder minValue(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int maxValueId() {
        return 14;
    }

    public static String maxValueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String maxValueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int maxValueHeaderLength() {
        return 2;
    }

    private void onMaxValueAccessed() {
        switch (this.codecState()) {
            case 4: {
                this.codecState(5);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"maxValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putMaxValue(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putMaxValue(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder maxValue(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int nullValueId() {
        return 15;
    }

    public static String nullValueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String nullValueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int nullValueHeaderLength() {
        return 2;
    }

    private void onNullValueAccessed() {
        switch (this.codecState()) {
            case 5: {
                this.codecState(6);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"nullValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putNullValue(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putNullValue(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder nullValue(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int characterEncodingId() {
        return 16;
    }

    public static String characterEncodingCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String characterEncodingMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int characterEncodingHeaderLength() {
        return 2;
    }

    private void onCharacterEncodingAccessed() {
        switch (this.codecState()) {
            case 6: {
                this.codecState(7);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"characterEncoding\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putCharacterEncoding(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putCharacterEncoding(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder characterEncoding(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int epochId() {
        return 17;
    }

    public static String epochCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String epochMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int epochHeaderLength() {
        return 2;
    }

    private void onEpochAccessed() {
        switch (this.codecState()) {
            case 7: {
                this.codecState(8);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"epoch\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putEpoch(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putEpoch(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder epoch(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int timeUnitId() {
        return 18;
    }

    public static String timeUnitCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String timeUnitMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int timeUnitHeaderLength() {
        return 2;
    }

    private void onTimeUnitAccessed() {
        switch (this.codecState()) {
            case 8: {
                this.codecState(9);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"timeUnit\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putTimeUnit(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putTimeUnit(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder timeUnit(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int semanticTypeId() {
        return 19;
    }

    public static String semanticTypeCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String semanticTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int semanticTypeHeaderLength() {
        return 2;
    }

    private void onSemanticTypeAccessed() {
        switch (this.codecState()) {
            case 9: {
                this.codecState(10);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"semanticType\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putSemanticType(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putSemanticType(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder semanticType(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int descriptionId() {
        return 20;
    }

    public static String descriptionCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String descriptionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int descriptionHeaderLength() {
        return 2;
    }

    private void onDescriptionAccessed() {
        switch (this.codecState()) {
            case 10: {
                this.codecState(11);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"description\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putDescription(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putDescription(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder description(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int referencedNameId() {
        return 21;
    }

    public static String referencedNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String referencedNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int referencedNameHeaderLength() {
        return 2;
    }

    private void onReferencedNameAccessed() {
        switch (this.codecState()) {
            case 11: {
                this.codecState(12);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"referencedName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putReferencedName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putReferencedName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder referencedName(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int packageNameId() {
        return 22;
    }

    public static String packageNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String packageNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int packageNameHeaderLength() {
        return 2;
    }

    private void onPackageNameAccessed() {
        switch (this.codecState()) {
            case 12: {
                this.codecState(13);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"packageName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecEncoder#CodecStates.");
            }
        }
    }

    public TokenCodecEncoder putPackageName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder putPackageName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public TokenCodecEncoder packageName(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return SEMANTIC_VERSION;
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        TokenCodecDecoder decoder = new TokenCodecDecoder();
        decoder.wrap(this.buffer, this.offset, 28, 0);
        return decoder.appendTo(builder);
    }

    public void checkEncodingIsComplete() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            switch (this.codecState) {
                case 13: {
                    return;
                }
            }
            throw new IllegalStateException("Not fully encoded, current state: " + CodecStates.name(this.codecState) + ", allowed transitions: " + CodecStates.transitions(this.codecState));
        }
    }

    private static class CodecStates {
        private static final int NOT_WRAPPED = 0;
        private static final int V0_BLOCK = 1;
        private static final int V0_NAME_DONE = 2;
        private static final int V0_CONSTVALUE_DONE = 3;
        private static final int V0_MINVALUE_DONE = 4;
        private static final int V0_MAXVALUE_DONE = 5;
        private static final int V0_NULLVALUE_DONE = 6;
        private static final int V0_CHARACTERENCODING_DONE = 7;
        private static final int V0_EPOCH_DONE = 8;
        private static final int V0_TIMEUNIT_DONE = 9;
        private static final int V0_SEMANTICTYPE_DONE = 10;
        private static final int V0_DESCRIPTION_DONE = 11;
        private static final int V0_REFERENCEDNAME_DONE = 12;
        private static final int V0_PACKAGENAME_DONE = 13;
        private static final String[] STATE_NAME_LOOKUP = new String[]{"NOT_WRAPPED", "V0_BLOCK", "V0_NAME_DONE", "V0_CONSTVALUE_DONE", "V0_MINVALUE_DONE", "V0_MAXVALUE_DONE", "V0_NULLVALUE_DONE", "V0_CHARACTERENCODING_DONE", "V0_EPOCH_DONE", "V0_TIMEUNIT_DONE", "V0_SEMANTICTYPE_DONE", "V0_DESCRIPTION_DONE", "V0_REFERENCEDNAME_DONE", "V0_PACKAGENAME_DONE"};
        private static final String[] STATE_TRANSITIONS_LOOKUP = new String[]{"\"wrap(version=0)\"", "\"tokenOffset(?)\", \"tokenSize(?)\", \"fieldId(?)\", \"tokenVersion(?)\", \"componentTokenCount(?)\", \"signal(?)\", \"primitiveType(?)\", \"byteOrder(?)\", \"presence(?)\", \"deprecated(?)\", \"nameLength()\", \"name(?)\"", "\"constValueLength()\", \"constValue(?)\"", "\"minValueLength()\", \"minValue(?)\"", "\"maxValueLength()\", \"maxValue(?)\"", "\"nullValueLength()\", \"nullValue(?)\"", "\"characterEncodingLength()\", \"characterEncoding(?)\"", "\"epochLength()\", \"epoch(?)\"", "\"timeUnitLength()\", \"timeUnit(?)\"", "\"semanticTypeLength()\", \"semanticType(?)\"", "\"descriptionLength()\", \"description(?)\"", "\"referencedNameLength()\", \"referencedName(?)\"", "\"packageNameLength()\", \"packageName(?)\"", ""};

        private CodecStates() {
        }

        private static String name(int state) {
            return STATE_NAME_LOOKUP[state];
        }

        private static String transitions(int state) {
            return STATE_TRANSITIONS_LOOKUP[state];
        }
    }
}

