/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.agrona.Verify;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.Generators;

public class RustUtil {
    static final String INDENT = "  ";
    private static final Map<PrimitiveType, String> TYPE_NAME_BY_PRIMITIVE_TYPE_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    static String rustTypeName(PrimitiveType primitiveType) {
        return TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.get((Object)primitiveType);
    }

    static String generateRustLiteral(PrimitiveType type, String value) {
        Verify.notNull((Object)((Object)type), (String)"type");
        Verify.notNull((Object)value, (String)"value");
        String typeName = RustUtil.rustTypeName(type);
        if (typeName == null) {
            throw new IllegalArgumentException("Unknown Rust type name found for primitive " + type.primitiveName());
        }
        switch (type) {
            case CHAR: 
            case UINT8: 
            case INT8: 
            case INT16: 
            case UINT16: 
            case INT32: 
            case INT64: 
            case UINT32: 
            case UINT64: {
                return value + typeName;
            }
            case FLOAT: 
            case DOUBLE: {
                return value.endsWith("NaN") ? typeName + "::NAN" : value + typeName;
            }
        }
        throw new IllegalArgumentException("Unsupported literal generation for type: " + type.primitiveName());
    }

    static byte eightBitCharacter(String asciiCharacter) {
        Verify.notNull((Object)asciiCharacter, (String)"asciiCharacter");
        byte[] bytes = asciiCharacter.getBytes(StandardCharsets.US_ASCII);
        if (bytes.length != 1) {
            throw new IllegalArgumentException(String.format("String value %s did not fit into a single 8-bit character", asciiCharacter));
        }
        return bytes[0];
    }

    static String formatTypeName(String value) {
        return Generators.toUpperFirstChar(value);
    }

    static String formatMethodName(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return RustUtil.sanitizeMethodOrProperty(RustUtil.toLowerUnderscoreFromCamel(value));
    }

    private static String toLowerUnderscoreFromCamel(String value) {
        if (value.isEmpty()) {
            return value;
        }
        String s = Generators.toLowerFirstChar(value);
        StringBuilder out = new StringBuilder(s.length() + 4);
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = RustUtil.indexInUpperAlphaRange(s, j)) == -1) break;
            String word = s.substring(i, j).toLowerCase();
            out.append(word);
            if (!word.endsWith("_")) {
                out.append("_");
            }
            i = j;
        }
        return i == 0 ? s.toLowerCase() : out.append(s.substring(i).toLowerCase()).toString();
    }

    private static int indexInUpperAlphaRange(CharSequence sequence, int start) {
        int length = sequence.length();
        if (start < 0 || start > length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = start; i < length; ++i) {
            char c = sequence.charAt(i);
            if ('A' > c || c > 'Z') continue;
            return i;
        }
        return -1;
    }

    private static String sanitizeMethodOrProperty(String name) {
        if (RustUtil.shadowsKeyword(name)) {
            return name + "_";
        }
        return name;
    }

    private static boolean shadowsKeyword(String name) {
        return ReservedKeyword.anyMatch(name);
    }

    static Appendable indent(Appendable appendable) throws IOException {
        return RustUtil.indent(appendable, 1);
    }

    static Appendable indent(Appendable appendable, int level) throws IOException {
        Appendable out = appendable;
        for (int i = 0; i < level; ++i) {
            out = out.append(INDENT);
        }
        return out;
    }

    static Appendable indent(Appendable appendable, int level, String f, Object ... args) throws IOException {
        return RustUtil.indent(appendable, level).append(String.format(f, args));
    }

    static {
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.CHAR, "i8");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT8, "i8");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT16, "i16");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT32, "i32");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT64, "i64");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT8, "u8");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT16, "u16");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT32, "u32");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT64, "u64");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.FLOAT, "f32");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.DOUBLE, "f64");
    }

    private static enum ReservedKeyword {
        Abstract,
        Alignof,
        As,
        Become,
        Box,
        Break,
        Const,
        Continue,
        Crate,
        Do,
        Else,
        Enum,
        Extern,
        False,
        Final,
        Fn,
        For,
        If,
        Impl,
        In,
        Let,
        Loop,
        Macro,
        Match,
        Mod,
        Move,
        Mut,
        Offsetof,
        Override,
        Priv,
        Proc,
        Pub,
        Pure,
        Ref,
        Return,
        Self,
        Sizeof,
        Static,
        Struct,
        Super,
        Trait,
        True,
        Type,
        Typeof,
        Unsafe,
        Unsized,
        Use,
        Virtual,
        Where,
        While,
        Yield;

        private static final Set<String> LOWER_CASE_NAMES;

        private static boolean anyMatch(String v) {
            return LOWER_CASE_NAMES.contains(v.toLowerCase());
        }

        static {
            LOWER_CASE_NAMES = new HashSet<String>();
            Arrays.stream(ReservedKeyword.values()).map(Enum::name).map(String::toLowerCase).forEach(LOWER_CASE_NAMES::add);
        }
    }
}

