/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.SetType;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class CompositeType
extends Type {
    public static final String COMPOSITE_TYPE = "composite";
    private static final String SUB_TYPES_EXP = "type|enum|set|composite|ref|data|group";
    private final List<String> compositesPath = new ArrayList<String>();
    private final Map<String, Type> containedTypeByNameMap = new LinkedHashMap<String, Type>();

    CompositeType(Node node) throws XPathExpressionException {
        this(node, null, null, new ArrayList<String>());
    }

    CompositeType(Node node, String givenName, String referencedName, List<String> compositesPath) throws XPathExpressionException {
        super(node, givenName, referencedName);
        this.compositesPath.addAll(compositesPath);
        this.compositesPath.add(XmlSchemaParser.getAttributeValue(node, "name"));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList list = (NodeList)xPath.compile(SUB_TYPES_EXP).evaluate(node, XPathConstants.NODESET);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node subTypeNode = list.item(i);
            String subTypeName = XmlSchemaParser.getAttributeValue(subTypeNode, "name");
            this.processType(subTypeNode, subTypeName, null, null);
        }
        this.checkForValidOffsets(node);
    }

    public Type getType(String name) {
        return this.containedTypeByNameMap.get(name);
    }

    @Override
    public int encodedLength() {
        int length = 0;
        for (Type t : this.containedTypeByNameMap.values()) {
            if (t.isVariableLength()) {
                return -1;
            }
            if (t.offsetAttribute() != -1) {
                length = t.offsetAttribute();
            }
            if (t.presence() == Presence.CONSTANT) continue;
            length += t.encodedLength();
        }
        return length;
    }

    public List<Type> getTypeList() {
        return new ArrayList<Type>(this.containedTypeByNameMap.values());
    }

    public void makeDataFieldCompositeType() {
        EncodedDataType edt = (EncodedDataType)this.containedTypeByNameMap.get("varData");
        if (edt != null) {
            edt.variableLength(true);
        }
    }

    public void checkForWellFormedGroupSizeEncoding(Node node) {
        EncodedDataType blockLengthType = (EncodedDataType)this.containedTypeByNameMap.get("blockLength");
        EncodedDataType numInGroupType = (EncodedDataType)this.containedTypeByNameMap.get("numInGroup");
        if (blockLengthType == null) {
            XmlSchemaParser.handleError(node, "composite for group encodedLength encoding must have \"blockLength\"");
        } else if (!PrimitiveType.isUnsigned(blockLengthType.primitiveType())) {
            XmlSchemaParser.handleError(node, "\"blockLength\" must be unsigned type");
        } else {
            if (blockLengthType.primitiveType() != PrimitiveType.UINT8 && blockLengthType.primitiveType() != PrimitiveType.UINT16) {
                XmlSchemaParser.handleWarning(node, "\"blockLength\" should be UINT8 or UINT16");
            }
            PrimitiveValue blockLengthTypeMaxValue = blockLengthType.maxValue();
            CompositeType.validateGroupMaxValue(node, blockLengthType.primitiveType(), blockLengthTypeMaxValue);
        }
        if (numInGroupType == null) {
            XmlSchemaParser.handleError(node, "composite for group encodedLength encoding must have \"numInGroup\"");
        } else if (!PrimitiveType.isUnsigned(numInGroupType.primitiveType())) {
            XmlSchemaParser.handleWarning(node, "\"numInGroup\" should be unsigned type");
            PrimitiveValue numInGroupMinValue = numInGroupType.minValue();
            if (null == numInGroupMinValue) {
                XmlSchemaParser.handleError(node, "\"numInGroup\" minValue must be set for signed types");
            } else if (numInGroupMinValue.longValue() < 0L) {
                XmlSchemaParser.handleError(node, String.format("\"numInGroup\" minValue=%s must be greater than zero for signed \"numInGroup\" types", numInGroupMinValue));
            }
        } else {
            if (numInGroupType.primitiveType() != PrimitiveType.UINT8 && numInGroupType.primitiveType() != PrimitiveType.UINT16) {
                XmlSchemaParser.handleWarning(node, "\"numInGroup\" should be UINT8 or UINT16");
            }
            PrimitiveValue numInGroupMaxValue = numInGroupType.maxValue();
            CompositeType.validateGroupMaxValue(node, numInGroupType.primitiveType(), numInGroupMaxValue);
            PrimitiveValue numInGroupMinValue = numInGroupType.minValue();
            if (null != numInGroupMinValue) {
                long max;
                long l = max = numInGroupMaxValue != null ? numInGroupMaxValue.longValue() : numInGroupType.primitiveType().maxValue().longValue();
                if (numInGroupMinValue.longValue() > max) {
                    XmlSchemaParser.handleError(node, String.format("\"numInGroup\" minValue=%s greater than maxValue=%d", numInGroupMinValue, max));
                }
            }
        }
    }

    public void checkForWellFormedVariableLengthDataEncoding(Node node) {
        EncodedDataType lengthType = (EncodedDataType)this.containedTypeByNameMap.get("length");
        if (lengthType == null) {
            XmlSchemaParser.handleError(node, "composite for variable length data encoding must have \"length\"");
        } else {
            PrimitiveType primitiveType = lengthType.primitiveType();
            if (!PrimitiveType.isUnsigned(primitiveType)) {
                XmlSchemaParser.handleError(node, "\"length\" must be unsigned type");
            } else if (primitiveType != PrimitiveType.UINT8 && primitiveType != PrimitiveType.UINT16 && primitiveType != PrimitiveType.UINT32) {
                XmlSchemaParser.handleWarning(node, "\"length\" should be UINT8, UINT16, or UINT32");
            }
            CompositeType.validateGroupMaxValue(node, primitiveType, lengthType.maxValue());
        }
        if ("optional".equals(XmlSchemaParser.getAttributeValueOrNull(node, "presence"))) {
            XmlSchemaParser.handleError(node, "composite for variable length data encoding cannot have presence=\"optional\"");
        }
        if (this.containedTypeByNameMap.get("varData") == null) {
            XmlSchemaParser.handleError(node, "composite for variable length data encoding must have \"varData\"");
        }
    }

    private static void validateGroupMaxValue(Node node, PrimitiveType primitiveType, PrimitiveValue value) {
        if (null != value) {
            long allowedValue;
            long longValue = value.longValue();
            if (longValue > (allowedValue = primitiveType.maxValue().longValue())) {
                XmlSchemaParser.handleError(node, String.format("maxValue greater than allowed for type: maxValue=%d allowed=%d", longValue, allowedValue));
            }
            long maxInt = PrimitiveType.INT32.maxValue().longValue();
            if (primitiveType == PrimitiveType.UINT32 && longValue > maxInt) {
                XmlSchemaParser.handleError(node, String.format("maxValue greater than allowed for type: maxValue=%d allowed=%d", longValue, maxInt));
            }
        } else if (primitiveType == PrimitiveType.UINT32) {
            long maxInt = PrimitiveType.INT32.maxValue().longValue();
            XmlSchemaParser.handleError(node, String.format("maxValue must be set for varData UINT32 type: max value allowed=%d", maxInt));
        }
    }

    public void checkForWellFormedMessageHeader(Node node) {
        boolean shouldGenerateInterfaces = Boolean.getBoolean("sbe.java.generate.interfaces");
        EncodedDataType blockLengthType = (EncodedDataType)this.containedTypeByNameMap.get("blockLength");
        EncodedDataType templateIdType = (EncodedDataType)this.containedTypeByNameMap.get("templateId");
        EncodedDataType schemaIdType = (EncodedDataType)this.containedTypeByNameMap.get("schemaId");
        EncodedDataType versionType = (EncodedDataType)this.containedTypeByNameMap.get("version");
        if (blockLengthType == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"blockLength\"");
        } else if (!PrimitiveType.isUnsigned(blockLengthType.primitiveType())) {
            XmlSchemaParser.handleError(node, "\"blockLength\" must be unsigned");
        }
        this.validateHeaderField(node, "blockLength", blockLengthType, PrimitiveType.UINT16, shouldGenerateInterfaces);
        this.validateHeaderField(node, "templateId", templateIdType, PrimitiveType.UINT16, shouldGenerateInterfaces);
        this.validateHeaderField(node, "schemaId", schemaIdType, PrimitiveType.UINT16, shouldGenerateInterfaces);
        this.validateHeaderField(node, "version", versionType, PrimitiveType.UINT16, shouldGenerateInterfaces);
    }

    private void validateHeaderField(Node node, String fieldName, EncodedDataType actualType, PrimitiveType expectedType, boolean shouldGenerateInterfaces) {
        if (actualType == null) {
            XmlSchemaParser.handleError(node, String.format("composite for message header must have \"%s\"", fieldName));
        } else if (actualType.primitiveType() != expectedType) {
            XmlSchemaParser.handleWarning(node, String.format("\"%s\" should be %s", fieldName, expectedType.name()));
            if (shouldGenerateInterfaces) {
                if (actualType.primitiveType().size() > expectedType.size()) {
                    XmlSchemaParser.handleError(node, String.format("\"%s\" must be less than %s bytes to use %s", fieldName, expectedType.size(), "sbe.java.generate.interfaces"));
                } else {
                    XmlSchemaParser.handleWarning(node, String.format("\"%s\" will be cast to %s to use %s", fieldName, expectedType.name(), "sbe.java.generate.interfaces"));
                }
            }
        }
    }

    public void checkForValidOffsets(Node node) {
        int offset = 0;
        for (Type edt : this.containedTypeByNameMap.values()) {
            int offsetAttribute = edt.offsetAttribute();
            if (-1 != offsetAttribute) {
                if (offsetAttribute < offset) {
                    XmlSchemaParser.handleError(node, String.format("composite element \"%s\" has incorrect offset specified", edt.name()));
                }
                offset = offsetAttribute;
            }
            offset += edt.encodedLength();
        }
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    private Type processType(Node subTypeNode, String subTypeName, String givenName, String referencedName) throws XPathExpressionException {
        String nodeName = subTypeNode.getNodeName();
        Type type = null;
        switch (nodeName) {
            case "type": {
                type = this.addType(subTypeNode, subTypeName, new EncodedDataType(subTypeNode, givenName, referencedName));
                break;
            }
            case "enum": {
                type = this.addType(subTypeNode, subTypeName, new EnumType(subTypeNode, givenName, referencedName));
                break;
            }
            case "set": {
                type = this.addType(subTypeNode, subTypeName, new SetType(subTypeNode, givenName, referencedName));
                break;
            }
            case "composite": {
                type = this.addType(subTypeNode, subTypeName, new CompositeType(subTypeNode, givenName, referencedName, this.compositesPath));
                break;
            }
            case "ref": {
                XPath xPath = XPathFactory.newInstance().newXPath();
                String refName = XmlSchemaParser.getAttributeValue(subTypeNode, "name");
                String refTypeName = XmlSchemaParser.getAttributeValue(subTypeNode, "type");
                int refOffset = Integer.parseInt(XmlSchemaParser.getAttributeValue(subTypeNode, "offset", "-1"));
                Node refTypeNode = (Node)xPath.compile("/*[local-name() = 'messageSchema']/types/*[@name='" + refTypeName + "']").evaluate(subTypeNode.getOwnerDocument(), XPathConstants.NODE);
                if (refTypeNode == null) {
                    XmlSchemaParser.handleError(subTypeNode, "ref type not found: " + refTypeName);
                    break;
                }
                if (this.compositesPath.contains(refTypeName)) {
                    XmlSchemaParser.handleError(refTypeNode, "ref types cannot create circular dependencies.");
                    throw new IllegalStateException("ref types cannot create circular dependencies");
                }
                type = this.processType(refTypeNode, refName, refName, refTypeName);
                if (-1 == refOffset) break;
                type.offsetAttribute(refOffset);
                break;
            }
            case "data": 
            case "group": {
                XmlSchemaParser.handleError(subTypeNode, nodeName + " not valid within composite");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown node type: name=" + nodeName);
            }
        }
        return type;
    }

    private Type addType(Node subTypeNode, String name, Type type) {
        if (this.containedTypeByNameMap.put(name, type) != null) {
            XmlSchemaParser.handleError(subTypeNode, "composite already contains a type named: " + name);
        }
        return type;
    }

    public String toString() {
        return "CompositeType{compositesPath=" + this.compositesPath + ", containedTypeByNameMap=" + this.containedTypeByNameMap + '}';
    }
}

