/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation;

import java.util.List;
import java.util.function.BiConsumer;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class Generators {
    public static void forEachField(List<Token> tokens, BiConsumer<Token, Token> consumer) {
        int i = 0;
        int size = tokens.size();
        while (i < size) {
            Token fieldToken = tokens.get(i);
            if (fieldToken.signal() == Signal.BEGIN_FIELD) {
                Token typeToken = tokens.get(i + 1);
                consumer.accept(fieldToken, typeToken);
                i += fieldToken.componentTokenCount();
                continue;
            }
            ++i;
        }
    }

    public static String toUpperFirstChar(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String toLowerFirstChar(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static Token findFirst(String name, List<Token> tokens, int index) {
        int size = tokens.size();
        for (int i = index; i < size; ++i) {
            Token token = tokens.get(i);
            if (!token.name().equals(name)) continue;
            return token;
        }
        throw new IllegalStateException("name not found: " + name);
    }
}

