/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.IntStream;
import uk.co.real_logic.sbe.generation.common.FieldPrecedenceModel;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Token;

public final class PrecedenceChecks {
    private static final Function<IntStream, IntStream> SELECT_LATEST_VERSION_ONLY = versions -> {
        OptionalInt max = versions.max();
        return max.isPresent() ? IntStream.of(max.getAsInt()) : IntStream.empty();
    };
    private final Context context;

    private PrecedenceChecks(Context context) {
        context.conclude();
        this.context = context;
    }

    public FieldPrecedenceModel createEncoderModel(String stateClassName, List<Token> msgTokens) {
        return this.createModel(stateClassName, msgTokens, SELECT_LATEST_VERSION_ONLY);
    }

    public FieldPrecedenceModel createDecoderModel(String stateClassName, List<Token> msgTokens) {
        return this.createModel(stateClassName, msgTokens, Function.identity());
    }

    public FieldPrecedenceModel createCodecModel(String stateClassName, List<Token> msgTokens) {
        return this.createModel(stateClassName, msgTokens, Function.identity());
    }

    public Context context() {
        return this.context;
    }

    public static PrecedenceChecks newInstance(Context context) {
        return new PrecedenceChecks(context);
    }

    private FieldPrecedenceModel createModel(String stateClassName, List<Token> tokens, Function<IntStream, IntStream> versionsSelector) {
        if (this.context.shouldGeneratePrecedenceChecks()) {
            Token msgToken = tokens.get(0);
            List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
            int i = 0;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(messageBody, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(messageBody, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            GenerationUtil.collectVarData(messageBody, i, varData);
            return FieldPrecedenceModel.newInstance(stateClassName, msgToken, fields, groups, varData, versionsSelector);
        }
        return null;
    }

    public static final class Context {
        private boolean shouldGeneratePrecedenceChecks;
        private String precedenceChecksFlagName = "SBE_ENABLE_PRECEDENCE_CHECKS";
        private String precedenceChecksPropName = "sbe.enable.precedence.checks";

        public boolean shouldGeneratePrecedenceChecks() {
            return this.shouldGeneratePrecedenceChecks;
        }

        public Context shouldGeneratePrecedenceChecks(boolean shouldGeneratePrecedenceChecks) {
            this.shouldGeneratePrecedenceChecks = shouldGeneratePrecedenceChecks;
            return this;
        }

        public String precedenceChecksFlagName() {
            return this.precedenceChecksFlagName;
        }

        public Context precedenceChecksFlagName(String precedenceChecksFlagName) {
            this.precedenceChecksFlagName = precedenceChecksFlagName;
            return this;
        }

        public String precedenceChecksPropName() {
            return this.precedenceChecksPropName;
        }

        public Context precedenceChecksPropName(String precedenceChecksPropName) {
            this.precedenceChecksPropName = precedenceChecksPropName;
            return this;
        }

        public void conclude() {
            Objects.requireNonNull(this.precedenceChecksFlagName, "precedenceChecksFlagName");
            Objects.requireNonNull(this.precedenceChecksPropName, "precedenceChecksPropName");
        }
    }
}

