/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir.generated;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.sbe.ir.generated.MessageHeaderDecoder;
import uk.co.real_logic.sbe.ir.generated.MetaAttribute;

public final class FrameCodecDecoder {
    private static final boolean ENABLE_BOUNDS_CHECKS = !Boolean.getBoolean("agrona.disable.bounds.checks");
    private static final boolean SBE_ENABLE_IR_PRECEDENCE_CHECKS = Boolean.parseBoolean(System.getProperty("sbe.enable.ir.precedence.checks", Boolean.toString(ENABLE_BOUNDS_CHECKS)));
    private int codecState = 0;
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final FrameCodecDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    private int codecState() {
        return this.codecState;
    }

    private void codecState(int newState) {
        this.codecState = newState;
    }

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return SEMANTIC_VERSION;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    private void onWrap(int actingVersion) {
        switch (actingVersion) {
            case 0: {
                this.codecState(1);
                break;
            }
            default: {
                this.codecState(1);
            }
        }
    }

    public FrameCodecDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onWrap(actingVersion);
        }
        return this;
    }

    public FrameCodecDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (1 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public FrameCodecDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        int currentCodecState = this.codecState();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.codecState(currentCodecState);
        }
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int irIdId() {
        return 1;
    }

    public static int irIdSinceVersion() {
        return 0;
    }

    public static int irIdEncodingOffset() {
        return 0;
    }

    public static int irIdEncodingLength() {
        return 4;
    }

    public static String irIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onIrIdAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"irId\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
        }
    }

    public static int irIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int irIdMinValue() {
        return -2147483647;
    }

    public static int irIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int irId() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onIrIdAccessed();
        }
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int irVersionId() {
        return 2;
    }

    public static int irVersionSinceVersion() {
        return 0;
    }

    public static int irVersionEncodingOffset() {
        return 4;
    }

    public static int irVersionEncodingLength() {
        return 4;
    }

    public static String irVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onIrVersionAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"irVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
        }
    }

    public static int irVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int irVersionMinValue() {
        return -2147483647;
    }

    public static int irVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int irVersion() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onIrVersionAccessed();
        }
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int schemaVersionId() {
        return 3;
    }

    public static int schemaVersionSinceVersion() {
        return 0;
    }

    public static int schemaVersionEncodingOffset() {
        return 8;
    }

    public static int schemaVersionEncodingLength() {
        return 4;
    }

    public static String schemaVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onSchemaVersionAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"schemaVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
        }
    }

    public static int schemaVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int schemaVersionMinValue() {
        return -2147483647;
    }

    public static int schemaVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int schemaVersion() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSchemaVersionAccessed();
        }
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int packageNameId() {
        return 4;
    }

    public static int packageNameSinceVersion() {
        return 0;
    }

    public static String packageNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String packageNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int packageNameHeaderLength() {
        return 2;
    }

    void onPackageNameLengthAccessed() {
        switch (this.codecState()) {
            case 1: {
                this.codecState(1);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"packageName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
            }
        }
    }

    private void onPackageNameAccessed() {
        switch (this.codecState()) {
            case 1: {
                this.codecState(2);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"packageName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
            }
        }
    }

    public int packageNameLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int skipPackageName() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getPackageName(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getPackageName(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapPackageName(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String packageName() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int namespaceNameId() {
        return 5;
    }

    public static int namespaceNameSinceVersion() {
        return 0;
    }

    public static String namespaceNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String namespaceNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int namespaceNameHeaderLength() {
        return 2;
    }

    void onNamespaceNameLengthAccessed() {
        switch (this.codecState()) {
            case 2: {
                this.codecState(2);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"namespaceName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
            }
        }
    }

    private void onNamespaceNameAccessed() {
        switch (this.codecState()) {
            case 2: {
                this.codecState(3);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"namespaceName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
            }
        }
    }

    public int namespaceNameLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int skipNamespaceName() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getNamespaceName(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getNamespaceName(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapNamespaceName(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String namespaceName() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int semanticVersionId() {
        return 6;
    }

    public static int semanticVersionSinceVersion() {
        return 0;
    }

    public static String semanticVersionCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String semanticVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int semanticVersionHeaderLength() {
        return 2;
    }

    void onSemanticVersionLengthAccessed() {
        switch (this.codecState()) {
            case 3: {
                this.codecState(3);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"semanticVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
            }
        }
    }

    private void onSemanticVersionAccessed() {
        switch (this.codecState()) {
            case 3: {
                this.codecState(4);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"semanticVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecDecoder#CodecStates.");
            }
        }
    }

    public int semanticVersionLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int skipSemanticVersion() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getSemanticVersion(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSemanticVersion(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapSemanticVersion(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String semanticVersion() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return SEMANTIC_VERSION;
        }
        FrameCodecDecoder decoder = new FrameCodecDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[FrameCodec](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 12) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(12);
        builder.append("):");
        builder.append("irId=");
        builder.append(this.irId());
        builder.append('|');
        builder.append("irVersion=");
        builder.append(this.irVersion());
        builder.append('|');
        builder.append("schemaVersion=");
        builder.append(this.schemaVersion());
        builder.append('|');
        builder.append("packageName=");
        builder.append('\'').append(this.packageName()).append('\'');
        builder.append('|');
        builder.append("namespaceName=");
        builder.append('\'').append(this.namespaceName()).append('\'');
        builder.append('|');
        builder.append("semanticVersion=");
        builder.append('\'').append(this.semanticVersion()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public FrameCodecDecoder sbeSkip() {
        this.sbeRewind();
        this.skipPackageName();
        this.skipNamespaceName();
        this.skipSemanticVersion();
        return this;
    }

    private static class CodecStates {
        private static final int NOT_WRAPPED = 0;
        private static final int V0_BLOCK = 1;
        private static final int V0_PACKAGENAME_DONE = 2;
        private static final int V0_NAMESPACENAME_DONE = 3;
        private static final int V0_SEMANTICVERSION_DONE = 4;
        private static final String[] STATE_NAME_LOOKUP = new String[]{"NOT_WRAPPED", "V0_BLOCK", "V0_PACKAGENAME_DONE", "V0_NAMESPACENAME_DONE", "V0_SEMANTICVERSION_DONE"};
        private static final String[] STATE_TRANSITIONS_LOOKUP = new String[]{"\"wrap(version=0)\"", "\"irId(?)\", \"irVersion(?)\", \"schemaVersion(?)\", \"packageNameLength()\", \"packageName(?)\"", "\"namespaceNameLength()\", \"namespaceName(?)\"", "\"semanticVersionLength()\", \"semanticVersion(?)\"", ""};

        private CodecStates() {
        }

        private static String name(int state) {
            return STATE_NAME_LOOKUP[state];
        }

        private static String transitions(int state) {
            return STATE_TRANSITIONS_LOOKUP[state];
        }
    }
}

