/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir.generated;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.sbe.ir.generated.VarDataEncodingDecoder;

public final class VarDataEncodingEncoder {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "";
    public static final int ENCODED_LENGTH = -1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public VarDataEncodingEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return -1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 2;
    }

    public static int lengthNullValue() {
        return 65535;
    }

    public static int lengthMinValue() {
        return 0;
    }

    public static int lengthMaxValue() {
        return 65534;
    }

    public VarDataEncodingEncoder length(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int varDataEncodingOffset() {
        return 2;
    }

    public static int varDataEncodingLength() {
        return -1;
    }

    public static short varDataNullValue() {
        return 255;
    }

    public static short varDataMinValue() {
        return 0;
    }

    public static short varDataMaxValue() {
        return 254;
    }

    public String toString() {
        if (null == this.buffer) {
            return SEMANTIC_VERSION;
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        VarDataEncodingDecoder decoder = new VarDataEncodingDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

