/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation;

import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.SbeTool;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.TargetCodeGenerator;
import uk.co.real_logic.sbe.generation.c.CGenerator;
import uk.co.real_logic.sbe.generation.c.COutputManager;
import uk.co.real_logic.sbe.generation.common.PrecedenceChecks;
import uk.co.real_logic.sbe.generation.cpp.CppDtoGenerator;
import uk.co.real_logic.sbe.generation.cpp.CppGenerator;
import uk.co.real_logic.sbe.generation.cpp.NamespaceOutputManager;
import uk.co.real_logic.sbe.generation.golang.GolangGenerator;
import uk.co.real_logic.sbe.generation.golang.GolangOutputManager;
import uk.co.real_logic.sbe.generation.java.JavaDtoGenerator;
import uk.co.real_logic.sbe.generation.java.JavaGenerator;
import uk.co.real_logic.sbe.generation.java.JavaOutputManager;
import uk.co.real_logic.sbe.generation.rust.RustGenerator;
import uk.co.real_logic.sbe.generation.rust.RustOutputManager;
import uk.co.real_logic.sbe.ir.Ir;

public enum TargetCodeGeneratorLoader implements TargetCodeGenerator
{
    JAVA{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            JavaOutputManager outputManager = new JavaOutputManager(outputDir, ir.applicableNamespace());
            JavaGenerator codecGenerator = new JavaGenerator(ir, System.getProperty("sbe.java.encoding.buffer.type", SbeTool.JAVA_DEFAULT_ENCODING_BUFFER_TYPE), System.getProperty("sbe.java.decoding.buffer.type", SbeTool.JAVA_DEFAULT_DECODING_BUFFER_TYPE), "true".equals(System.getProperty("sbe.java.generate.group-order.annotation")), "true".equals(System.getProperty("sbe.java.generate.interfaces")), "true".equals(System.getProperty("sbe.decode.unknown.enum.values")), "true".equals(System.getProperty("sbe.types.package.override")), 1.precedenceChecks(), outputManager);
            JavaDtoGenerator dtoGenerator = new JavaDtoGenerator(ir, (OutputManager)outputManager);
            CodeGenerator combinedGenerator = () -> {
                codecGenerator.generate();
                dtoGenerator.generate();
            };
            boolean generateDtos = "true".equals(System.getProperty("sbe.java.generate.dtos"));
            return generateDtos ? combinedGenerator : codecGenerator;
        }
    }
    ,
    C{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            return new CGenerator(ir, new COutputManager(outputDir, ir.applicableNamespace()));
        }
    }
    ,
    CPP{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            NamespaceOutputManager outputManager = new NamespaceOutputManager(outputDir, ir.applicableNamespace());
            boolean decodeUnknownEnumValues = "true".equals(System.getProperty("sbe.decode.unknown.enum.values"));
            CppGenerator codecGenerator = new CppGenerator(ir, decodeUnknownEnumValues, 3.precedenceChecks(), outputManager);
            CppDtoGenerator dtoGenerator = new CppDtoGenerator(ir, outputManager);
            CodeGenerator combinedGenerator = () -> {
                codecGenerator.generate();
                dtoGenerator.generate();
            };
            boolean generateDtos = "true".equals(System.getProperty("sbe.cpp.generate.dtos"));
            return generateDtos ? combinedGenerator : codecGenerator;
        }
    }
    ,
    GOLANG{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            return new GolangGenerator(ir, new GolangOutputManager(outputDir, ir.applicableNamespace()));
        }
    }
    ,
    RUST{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            return new RustGenerator(ir, new RustOutputManager(outputDir, ir.packageName()));
        }
    };


    public static PrecedenceChecks precedenceChecks() {
        String precedenceChecksPropName;
        String precedenceChecksFlagName;
        PrecedenceChecks.Context context = new PrecedenceChecks.Context();
        String shouldGeneratePrecedenceChecks = System.getProperty("sbe.generate.precedence.checks");
        if (shouldGeneratePrecedenceChecks != null) {
            context.shouldGeneratePrecedenceChecks(Boolean.parseBoolean(shouldGeneratePrecedenceChecks));
        }
        if ((precedenceChecksFlagName = System.getProperty("sbe.precedence.checks.flag.name")) != null) {
            context.precedenceChecksFlagName(precedenceChecksFlagName);
        }
        if ((precedenceChecksPropName = System.getProperty("sbe.java.precedence.checks.property.name")) != null) {
            context.precedenceChecksPropName(precedenceChecksPropName);
        }
        return PrecedenceChecks.newInstance(context);
    }

    public static TargetCodeGenerator get(String name) {
        for (TargetCodeGeneratorLoader target : TargetCodeGeneratorLoader.values()) {
            if (!target.name().equalsIgnoreCase(name)) continue;
            return target;
        }
        try {
            return (TargetCodeGenerator)Class.forName(name).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("No code generator for name: " + name, ex);
        }
    }
}

