/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir.generated;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.sbe.ir.generated.FrameCodecDecoder;
import uk.co.real_logic.sbe.ir.generated.MessageHeaderEncoder;
import uk.co.real_logic.sbe.ir.generated.MetaAttribute;

public final class FrameCodecEncoder {
    private static final boolean ENABLE_BOUNDS_CHECKS = !Boolean.getBoolean("agrona.disable.bounds.checks");
    private static final boolean SBE_ENABLE_IR_PRECEDENCE_CHECKS = Boolean.parseBoolean(System.getProperty("sbe.enable.ir.precedence.checks", Boolean.toString(ENABLE_BOUNDS_CHECKS)));
    private int codecState = 0;
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final FrameCodecEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    private int codecState() {
        return this.codecState;
    }

    private void codecState(int newState) {
        this.codecState = newState;
    }

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return SEMANTIC_VERSION;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public FrameCodecEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 12);
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.codecState(1);
        }
        return this;
    }

    public FrameCodecEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(12).templateId(1).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int irIdId() {
        return 1;
    }

    public static int irIdSinceVersion() {
        return 0;
    }

    public static int irIdEncodingOffset() {
        return 0;
    }

    public static int irIdEncodingLength() {
        return 4;
    }

    public static String irIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onIrIdAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"irId\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecEncoder#CodecStates.");
        }
    }

    public static int irIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int irIdMinValue() {
        return -2147483647;
    }

    public static int irIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FrameCodecEncoder irId(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onIrIdAccessed();
        }
        this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int irVersionId() {
        return 2;
    }

    public static int irVersionSinceVersion() {
        return 0;
    }

    public static int irVersionEncodingOffset() {
        return 4;
    }

    public static int irVersionEncodingLength() {
        return 4;
    }

    public static String irVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onIrVersionAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"irVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecEncoder#CodecStates.");
        }
    }

    public static int irVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int irVersionMinValue() {
        return -2147483647;
    }

    public static int irVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FrameCodecEncoder irVersion(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onIrVersionAccessed();
        }
        this.buffer.putInt(this.offset + 4, value, BYTE_ORDER);
        return this;
    }

    public static int schemaVersionId() {
        return 3;
    }

    public static int schemaVersionSinceVersion() {
        return 0;
    }

    public static int schemaVersionEncodingOffset() {
        return 8;
    }

    public static int schemaVersionEncodingLength() {
        return 4;
    }

    public static String schemaVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onSchemaVersionAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"schemaVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecEncoder#CodecStates.");
        }
    }

    public static int schemaVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int schemaVersionMinValue() {
        return -2147483647;
    }

    public static int schemaVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FrameCodecEncoder schemaVersion(int value) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSchemaVersionAccessed();
        }
        this.buffer.putInt(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int packageNameId() {
        return 4;
    }

    public static String packageNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String packageNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int packageNameHeaderLength() {
        return 2;
    }

    private void onPackageNameAccessed() {
        switch (this.codecState()) {
            case 1: {
                this.codecState(2);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"packageName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecEncoder#CodecStates.");
            }
        }
    }

    public FrameCodecEncoder putPackageName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder putPackageName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder packageName(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPackageNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int namespaceNameId() {
        return 5;
    }

    public static String namespaceNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String namespaceNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int namespaceNameHeaderLength() {
        return 2;
    }

    private void onNamespaceNameAccessed() {
        switch (this.codecState()) {
            case 2: {
                this.codecState(3);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"namespaceName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecEncoder#CodecStates.");
            }
        }
    }

    public FrameCodecEncoder putNamespaceName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder putNamespaceName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder namespaceName(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNamespaceNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int semanticVersionId() {
        return 6;
    }

    public static String semanticVersionCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String semanticVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int semanticVersionHeaderLength() {
        return 2;
    }

    private void onSemanticVersionAccessed() {
        switch (this.codecState()) {
            case 3: {
                this.codecState(4);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"semanticVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class FrameCodecEncoder#CodecStates.");
            }
        }
    }

    public FrameCodecEncoder putSemanticVersion(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder putSemanticVersion(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder semanticVersion(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticVersionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return SEMANTIC_VERSION;
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        FrameCodecDecoder decoder = new FrameCodecDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 12, 0);
        return decoder.appendTo(builder);
    }

    public void checkEncodingIsComplete() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            switch (this.codecState) {
                case 4: {
                    return;
                }
            }
            throw new IllegalStateException("Not fully encoded, current state: " + CodecStates.name(this.codecState) + ", allowed transitions: " + CodecStates.transitions(this.codecState));
        }
    }

    private static class CodecStates {
        private static final int NOT_WRAPPED = 0;
        private static final int V0_BLOCK = 1;
        private static final int V0_PACKAGENAME_DONE = 2;
        private static final int V0_NAMESPACENAME_DONE = 3;
        private static final int V0_SEMANTICVERSION_DONE = 4;
        private static final String[] STATE_NAME_LOOKUP = new String[]{"NOT_WRAPPED", "V0_BLOCK", "V0_PACKAGENAME_DONE", "V0_NAMESPACENAME_DONE", "V0_SEMANTICVERSION_DONE"};
        private static final String[] STATE_TRANSITIONS_LOOKUP = new String[]{"\"wrap(version=0)\"", "\"irId(?)\", \"irVersion(?)\", \"schemaVersion(?)\", \"packageNameLength()\", \"packageName(?)\"", "\"namespaceNameLength()\", \"namespaceName(?)\"", "\"semanticVersionLength()\", \"semanticVersion(?)\"", ""};

        private CodecStates() {
        }

        private static String name(int state) {
            return STATE_NAME_LOOKUP[state];
        }

        private static String transitions(int state) {
            return STATE_TRANSITIONS_LOOKUP[state];
        }
    }
}

