/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.csharp;

import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ValidationUtil;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.ir.Token;

public class CSharpUtil {
    private static final Map<PrimitiveType, String> PRIMITIVE_TYPE_STRING_ENUM_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    static String generateLiteral(PrimitiveType type, String value) {
        Object literal = "";
        String castType = CSharpUtil.cSharpTypeName(type);
        switch (type) {
            case CHAR: 
            case UINT8: 
            case INT8: 
            case INT16: 
            case UINT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case INT32: {
                literal = value;
                break;
            }
            case UINT32: {
                literal = value + "U";
                break;
            }
            case FLOAT: {
                if (value.endsWith("NaN")) {
                    literal = "float.NaN";
                    break;
                }
                literal = value + "f";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "UL";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "double.NaN" : value + "d";
            }
        }
        return literal;
    }

    static CharSequence generateFileHeader(String packageName, String ... topLevelStatements) {
        return String.format("// <auto-generated>\n//     Generated SBE (Simple Binary Encoding) message codec\n// </auto-generated>\n\n#pragma warning disable 1591 // disable warning on missing comments\n%1$susing System;\nusing System.Text;\nusing Org.SbeTool.Sbe.Dll;\n\nnamespace %2$s\n{\n", String.join((CharSequence)"", topLevelStatements), CSharpUtil.formatNamespace(packageName));
    }

    static String formatNamespace(String packageName) {
        String[] tokens = packageName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String t : tokens) {
            sb.append(Generators.toUpperFirstChar(t)).append(".");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        tokens = sb.toString().split("-");
        sb.setLength(0);
        for (String t : tokens) {
            sb.append(Generators.toUpperFirstChar(t));
        }
        return sb.toString();
    }

    static String generateDocumentation(String indent, Token token) {
        String description = token.description();
        if (null == description || description.isEmpty()) {
            return "";
        }
        return indent + "/// <summary>\n" + indent + "/// " + description + "\n" + indent + "/// </summary>\n";
    }

    static String cSharpTypeName(PrimitiveType primitiveType) {
        return PRIMITIVE_TYPE_STRING_ENUM_MAP.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String toLowerFirstChar(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String formatPropertyName(String str) {
        return CSharpUtil.toUpperFirstChar(str);
    }

    public static String formatForCSharpKeyword(String value) {
        if (ValidationUtil.isCSharpKeyword(value)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + value + "' please correct the schema or consider setting system property: sbe.keyword.append.token");
            }
            return value + keywordAppendToken;
        }
        return value;
    }

    public static String formatVariableName(String str) {
        return CSharpUtil.toLowerFirstChar(str);
    }

    public static String formatClassName(String str) {
        return CSharpUtil.toUpperFirstChar(str);
    }

    public static String formatGetterName(String propertyName) {
        return "Get" + CSharpUtil.toUpperFirstChar(propertyName);
    }

    public static void append(StringBuilder builder, String indent, String line) {
        builder.append(indent).append(line).append('\n');
    }

    static {
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.CHAR, "byte");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT8, "sbyte");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT16, "short");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT32, "int");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT64, "long");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT8, "byte");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT16, "ushort");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT32, "uint");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT64, "ulong");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.FLOAT, "float");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.DOUBLE, "double");
    }

    static enum Separators {
        BEGIN_GROUP('['),
        END_GROUP(']'),
        BEGIN_COMPOSITE('('),
        END_COMPOSITE(')'),
        BEGIN_SET('{'),
        END_SET('}'),
        BEGIN_ARRAY('['),
        END_ARRAY(']'),
        FIELD('|'),
        KEY_VALUE('='),
        ENTRY(',');

        private final char symbol;

        private Separators(char symbol) {
            this.symbol = symbol;
        }

        void appendToGeneratedBuilder(StringBuilder builder, String indent) {
            builder.append(indent).append("builder.Append('").append(this.symbol).append("');").append('\n');
        }

        public String toString() {
            return String.valueOf(this.symbol);
        }
    }
}

