/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation;

import uk.co.real_logic.sbe.SbeTool;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.TargetCodeGenerator;
import uk.co.real_logic.sbe.generation.c.CGenerator;
import uk.co.real_logic.sbe.generation.c.COutputManager;
import uk.co.real_logic.sbe.generation.common.PrecedenceChecks;
import uk.co.real_logic.sbe.generation.cpp.CppDtoGenerator;
import uk.co.real_logic.sbe.generation.cpp.CppGenerator;
import uk.co.real_logic.sbe.generation.cpp.NamespaceOutputManager;
import uk.co.real_logic.sbe.generation.golang.flyweight.GolangFlyweightGenerator;
import uk.co.real_logic.sbe.generation.golang.flyweight.GolangFlyweightOutputManager;
import uk.co.real_logic.sbe.generation.golang.struct.GolangGenerator;
import uk.co.real_logic.sbe.generation.golang.struct.GolangOutputManager;
import uk.co.real_logic.sbe.generation.java.JavaDtoGenerator;
import uk.co.real_logic.sbe.generation.java.JavaGenerator;
import uk.co.real_logic.sbe.generation.java.JavaOutputManager;
import uk.co.real_logic.sbe.generation.rust.RustGenerator;
import uk.co.real_logic.sbe.generation.rust.RustOutputManager;
import uk.co.real_logic.sbe.ir.Ir;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TargetCodeGeneratorLoader implements TargetCodeGenerator
{
    JAVA{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            JavaOutputManager outputManager = new JavaOutputManager(outputDir, ir.applicableNamespace());
            boolean shouldSupportTypesPackageNames = Boolean.getBoolean("sbe.types.package.override");
            JavaGenerator codecGenerator = new JavaGenerator(ir, System.getProperty("sbe.java.encoding.buffer.type", SbeTool.JAVA_DEFAULT_ENCODING_BUFFER_TYPE), System.getProperty("sbe.java.decoding.buffer.type", SbeTool.JAVA_DEFAULT_DECODING_BUFFER_TYPE), Boolean.getBoolean("sbe.java.generate.group-order.annotation"), Boolean.getBoolean("sbe.java.generate.interfaces"), Boolean.getBoolean("sbe.decode.unknown.enum.values"), shouldSupportTypesPackageNames, 1.precedenceChecks(), outputManager);
            if (Boolean.getBoolean("sbe.java.generate.dtos")) {
                JavaDtoGenerator dtoGenerator = new JavaDtoGenerator(ir, shouldSupportTypesPackageNames, outputManager);
                return () -> {
                    codecGenerator.generate();
                    dtoGenerator.generate();
                };
            }
            return codecGenerator;
        }
    }
    ,
    C{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            return new CGenerator(ir, new COutputManager(outputDir, ir.applicableNamespace()));
        }
    }
    ,
    CPP{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            NamespaceOutputManager outputManager = new NamespaceOutputManager(outputDir, ir.applicableNamespace());
            boolean decodeUnknownEnumValues = Boolean.getBoolean("sbe.decode.unknown.enum.values");
            boolean shouldSupportTypesPackageNames = Boolean.getBoolean("sbe.types.package.override");
            CppGenerator codecGenerator = new CppGenerator(ir, decodeUnknownEnumValues, 3.precedenceChecks(), shouldSupportTypesPackageNames, outputManager);
            if (Boolean.getBoolean("sbe.cpp.generate.dtos")) {
                CppDtoGenerator dtoGenerator = new CppDtoGenerator(ir, shouldSupportTypesPackageNames, outputManager);
                return () -> {
                    codecGenerator.generate();
                    dtoGenerator.generate();
                };
            }
            return codecGenerator;
        }
    }
    ,
    GOLANG{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            if ("true".equals(System.getProperty("sbe.go.generate.generate.flyweights"))) {
                return new GolangFlyweightGenerator(ir, "true".equals(System.getProperty("sbe.decode.unknown.enum.values")), new GolangFlyweightOutputManager(outputDir, ir.applicableNamespace()));
            }
            return new GolangGenerator(ir, new GolangOutputManager(outputDir, ir.applicableNamespace()));
        }
    }
    ,
    RUST{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) {
            return new RustGenerator(ir, System.getProperty("sbe.rust.crate.version", "0.1.0"), new RustOutputManager(outputDir, ir.packageName()));
        }
    };


    public static PrecedenceChecks precedenceChecks() {
        String precedenceChecksPropName;
        String precedenceChecksFlagName;
        PrecedenceChecks.Context context = new PrecedenceChecks.Context();
        String shouldGeneratePrecedenceChecks = System.getProperty("sbe.generate.precedence.checks");
        if (shouldGeneratePrecedenceChecks != null) {
            context.shouldGeneratePrecedenceChecks(Boolean.parseBoolean(shouldGeneratePrecedenceChecks));
        }
        if ((precedenceChecksFlagName = System.getProperty("sbe.precedence.checks.flag.name")) != null) {
            context.precedenceChecksFlagName(precedenceChecksFlagName);
        }
        if ((precedenceChecksPropName = System.getProperty("sbe.java.precedence.checks.property.name")) != null) {
            context.precedenceChecksPropName(precedenceChecksPropName);
        }
        return PrecedenceChecks.newInstance(context);
    }

    public static TargetCodeGenerator get(String name) {
        for (TargetCodeGeneratorLoader target : TargetCodeGeneratorLoader.values()) {
            if (!target.name().equalsIgnoreCase(name)) continue;
            return target;
        }
        try {
            return (TargetCodeGenerator)Class.forName(name).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("No code generator for name: " + name, ex);
        }
    }
}

