/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import uk.co.real_logic.sbe.xml.Field;
import uk.co.real_logic.sbe.xml.Message;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.SchemaTransformer;
import uk.co.real_logic.sbe.xml.Type;

class SinceVersionSchemaTransformer
implements SchemaTransformer {
    private final int sinceVersion;

    SinceVersionSchemaTransformer(int sinceVersion) {
        this.sinceVersion = sinceVersion;
    }

    @Override
    public MessageSchema transform(MessageSchema originalSchema) {
        Collection<Type> types = originalSchema.types();
        HashMap<String, Type> newTypes = new HashMap<String, Type>();
        for (Type type : types) {
            if (type.sinceVersion() > this.sinceVersion) continue;
            newTypes.put(type.name(), type);
        }
        Collection<Message> messages = originalSchema.messages();
        HashMap<Long, Message> newMessages = new HashMap<Long, Message>();
        for (Message message : messages) {
            List<Field> newFields;
            Message newMessage = new Message(message, newFields = this.removeFields(message.fields(), this.sinceVersion));
            if (newMessage.sinceVersion() > this.sinceVersion) continue;
            newMessages.put(Long.valueOf(newMessage.id()), newMessage);
        }
        return new MessageSchema(originalSchema.packageName(), originalSchema.description(), originalSchema.id(), this.sinceVersion, originalSchema.semanticVersion(), originalSchema.byteOrder(), originalSchema.messageHeader().name(), newTypes, newMessages);
    }

    private List<Field> removeFields(List<Field> fields, int sinceVersion) {
        ArrayList<Field> newFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.sinceVersion() > sinceVersion) continue;
            Field newField = field;
            List<Field> groupFields = field.groupFields();
            if (null != groupFields && !groupFields.isEmpty()) {
                groupFields = this.removeFields(groupFields, sinceVersion);
                newField = new Field(field, groupFields);
            }
            newFields.add(newField);
        }
        return newFields;
    }

    int sinceVersion() {
        return this.sinceVersion;
    }
}

