/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.golang.flyweight;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ValidationUtil;
import uk.co.real_logic.sbe.generation.Generators;

public class GolangFlyweightUtil {
    private static final Map<PrimitiveType, String> PRIMITIVE_TYPE_STRING_ENUM_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);
    private static final Map<PrimitiveType, String> MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String goTypeName(PrimitiveType primitiveType) {
        return PRIMITIVE_TYPE_STRING_ENUM_MAP.get((Object)primitiveType);
    }

    public static String formatClassName(String value) {
        return Generators.toUpperFirstChar(value);
    }

    public static String golangMarshalType(PrimitiveType primitiveType) {
        return MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.get((Object)primitiveType);
    }

    public static String formatPropertyName(String value) {
        Object formattedValue = Generators.toUpperFirstChar(value);
        if (ValidationUtil.isGolangKeyword((String)formattedValue)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + (String)formattedValue + "' please correct the schema or consider setting system property: sbe.keyword.append.token");
            }
            formattedValue = (String)formattedValue + keywordAppendToken;
        }
        return formattedValue;
    }

    public static String closingBraces(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("}\n");
        }
        return sb.toString();
    }

    public static String formatReadBytes(ByteOrder byteOrder, PrimitiveType primitiveType) {
        String suffix = byteOrder == ByteOrder.BIG_ENDIAN ? "BigEndian" : "LittleEndian";
        switch (primitiveType) {
            case CHAR: {
                return "Byte" + suffix;
            }
            case FLOAT: {
                return "Float" + suffix;
            }
            case DOUBLE: {
                return "Double" + suffix;
            }
            case INT8: {
                return "Int8" + suffix;
            }
            case INT16: {
                return "Int16" + suffix;
            }
            case INT32: {
                return "Int32" + suffix;
            }
            case INT64: {
                return "Int64" + suffix;
            }
            case UINT8: {
                return "Uint8" + suffix;
            }
            case UINT16: {
                return "Uint16" + suffix;
            }
            case UINT32: {
                return "Uint32" + suffix;
            }
            case UINT64: {
                return "Uint64" + suffix;
            }
        }
        return "";
    }

    public static String formatWriteBytes(ByteOrder byteOrder, PrimitiveType primitiveType) {
        String suffix = byteOrder == ByteOrder.BIG_ENDIAN ? "BigEndian" : "LittleEndian";
        switch (primitiveType) {
            case CHAR: {
                return "PutByte" + suffix;
            }
            case FLOAT: {
                return "PutFloat" + suffix;
            }
            case DOUBLE: {
                return "PutDouble" + suffix;
            }
            case INT8: {
                return "PutInt8" + suffix;
            }
            case INT16: {
                return "PutInt16" + suffix;
            }
            case INT32: {
                return "PutInt32" + suffix;
            }
            case INT64: {
                return "PutInt64" + suffix;
            }
            case UINT8: {
                return "PutUint8" + suffix;
            }
            case UINT16: {
                return "PutUint16" + suffix;
            }
            case UINT32: {
                return "PutUint32" + suffix;
            }
            case UINT64: {
                return "PutUint64" + suffix;
            }
        }
        return "";
    }

    static {
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.CHAR, "byte");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT8, "int8");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT16, "int16");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT32, "int32");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT64, "int64");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT8, "uint8");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT16, "uint16");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT32, "uint32");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT64, "uint64");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.FLOAT, "float32");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.DOUBLE, "float64");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.CHAR, "Bytes");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT8, "Int8");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT16, "Int16");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT32, "Int32");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT64, "Int64");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT8, "Uint8");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT16, "Uint16");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT32, "Uint32");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT64, "Uint64");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.FLOAT, "Float32");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.DOUBLE, "Float64");
    }
}

