/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe;

import uk.co.real_logic.sbe.PrimitiveValue;

public enum PrimitiveType {
    CHAR("char", 1, 32L, 126L, 0L),
    INT8("int8", 1, -127L, 127L, -128L),
    INT16("int16", 2, -32767L, 32767L, -32768L),
    INT32("int32", 4, -2147483647L, Integer.MAX_VALUE, Integer.MIN_VALUE),
    INT64("int64", 8, -9223372036854775807L, Long.MAX_VALUE, Long.MIN_VALUE),
    UINT8("uint8", 1, 0L, 254L, 255L),
    UINT16("uint16", 2, 0L, 65534L, 65535L),
    UINT32("uint32", 4, 0L, 0xFFFFFFFDL, 0xFFFFFFFEL),
    UINT64("uint64", 8, 0L, PrimitiveValue.MAX_VALUE_UINT64, PrimitiveValue.NULL_VALUE_UINT64),
    FLOAT("float", 4, (double)1.4E-45f, 3.4028234663852886E38, Double.NaN),
    DOUBLE("double", 8, Double.MIN_VALUE, Double.MAX_VALUE, Double.NaN);

    private final String name;
    private final int size;
    private final PrimitiveValue minValue;
    private final PrimitiveValue maxValue;
    private final PrimitiveValue nullValue;

    private PrimitiveType(String name, int size, long minValue, long maxValue, long nullValue) {
        this.name = name;
        this.size = size;
        this.minValue = new PrimitiveValue(minValue, size);
        this.maxValue = new PrimitiveValue(maxValue, size);
        this.nullValue = new PrimitiveValue(nullValue, size);
    }

    private PrimitiveType(String name, int size, double minValue, double maxValue, double nullValue) {
        this.name = name;
        this.size = size;
        this.minValue = new PrimitiveValue(minValue, size);
        this.maxValue = new PrimitiveValue(maxValue, size);
        this.nullValue = new PrimitiveValue(nullValue, size);
    }

    public String primitiveName() {
        return this.name;
    }

    public int size() {
        return this.size;
    }

    public PrimitiveValue minValue() {
        return this.minValue;
    }

    public PrimitiveValue maxValue() {
        return this.maxValue;
    }

    public PrimitiveValue nullValue() {
        return this.nullValue;
    }

    public static PrimitiveType get(String name) {
        for (PrimitiveType p : Singleton.VALUES) {
            if (!name.equals(p.name)) continue;
            return p;
        }
        throw new IllegalArgumentException("No PrimitiveType for name: " + name);
    }

    static class Singleton {
        public static final PrimitiveType[] VALUES = PrimitiveType.values();

        Singleton() {
        }
    }
}

