/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import uk.co.real_logic.sbe.PrimitiveType;

public class PrimitiveValue {
    public static final long MIN_VALUE_CHAR = 32L;
    public static final long MAX_VALUE_CHAR = 126L;
    public static final long NULL_VALUE_CHAR = 0L;
    public static final long MIN_VALUE_INT8 = -127L;
    public static final long MAX_VALUE_INT8 = 127L;
    public static final long NULL_VALUE_INT8 = -128L;
    public static final long MIN_VALUE_UINT8 = 0L;
    public static final long MAX_VALUE_UINT8 = 254L;
    public static final long NULL_VALUE_UINT8 = 255L;
    public static final long MIN_VALUE_INT16 = -32767L;
    public static final long MAX_VALUE_INT16 = 32767L;
    public static final long NULL_VALUE_INT16 = -32768L;
    public static final long MIN_VALUE_UINT16 = 0L;
    public static final long MAX_VALUE_UINT16 = 65534L;
    public static final long NULL_VALUE_UINT16 = 65535L;
    public static final long MIN_VALUE_INT32 = -2147483647L;
    public static final long MAX_VALUE_INT32 = Integer.MAX_VALUE;
    public static final long NULL_VALUE_INT32 = Integer.MIN_VALUE;
    public static final long MIN_VALUE_UINT32 = 0L;
    public static final long MAX_VALUE_UINT32 = 0xFFFFFFFDL;
    public static final long NULL_VALUE_UINT32 = 0xFFFFFFFEL;
    public static final long MIN_VALUE_INT64 = -9223372036854775807L;
    public static final long MAX_VALUE_INT64 = Long.MAX_VALUE;
    public static final long NULL_VALUE_INT64 = Long.MIN_VALUE;
    public static final long MIN_VALUE_UINT64 = 0L;
    public static final BigInteger BI_MAX_VALUE_UINT64 = new BigInteger("18446744073709551614");
    public static final long MAX_VALUE_UINT64 = BI_MAX_VALUE_UINT64.longValue();
    public static final BigInteger BI_NULL_VALUE_UINT64 = new BigInteger("18446744073709551615");
    public static final long NULL_VALUE_UINT64 = BI_NULL_VALUE_UINT64.longValue();
    public static final float MIN_VALUE_FLOAT = Float.MIN_VALUE;
    public static final float MAX_VALUE_FLOAT = Float.MAX_VALUE;
    public static final float NULL_VALUE_FLOAT = Float.NaN;
    public static final double MIN_VALUE_DOUBLE = Double.MIN_VALUE;
    public static final double MAX_VALUE_DOUBLE = Double.MAX_VALUE;
    public static final double NULL_VALUE_DOUBLE = Double.NaN;
    private final Representation representation;
    private final long longValue;
    private final double doubleValue;
    private final byte[] byteArrayValue;
    private final String characterEncoding;
    private final int size;
    private final byte[] byteArrayValueForLong = new byte[1];

    public PrimitiveValue(long value, int size) {
        this.representation = Representation.LONG;
        this.longValue = value;
        this.doubleValue = 0.0;
        this.byteArrayValue = null;
        this.characterEncoding = null;
        this.size = size;
    }

    public PrimitiveValue(double value, int size) {
        this.representation = Representation.DOUBLE;
        this.longValue = 0L;
        this.doubleValue = value;
        this.byteArrayValue = null;
        this.characterEncoding = null;
        this.size = size;
    }

    public PrimitiveValue(byte[] value, String characterEncoding, int size) {
        this.representation = Representation.BYTE_ARRAY;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.byteArrayValue = value;
        this.characterEncoding = characterEncoding;
        this.size = size;
    }

    public static PrimitiveValue parse(String value, PrimitiveType primitiveType) {
        switch (primitiveType) {
            case CHAR: {
                if (value.length() > 1) {
                    throw new IllegalArgumentException("Constant char value malformed: " + value);
                }
                return new PrimitiveValue(value.getBytes()[0], 1);
            }
            case INT8: {
                return new PrimitiveValue(Byte.parseByte(value), 1);
            }
            case INT16: {
                return new PrimitiveValue(Short.parseShort(value), 2);
            }
            case INT32: {
                return new PrimitiveValue(Integer.parseInt(value), 4);
            }
            case INT64: {
                return new PrimitiveValue(Long.parseLong(value), 8);
            }
            case UINT8: {
                return new PrimitiveValue(Short.parseShort(value), 1);
            }
            case UINT16: {
                return new PrimitiveValue(Integer.parseInt(value), 2);
            }
            case UINT32: {
                return new PrimitiveValue(Long.parseLong(value), 4);
            }
            case UINT64: {
                BigInteger biValue = new BigInteger(value);
                if (biValue.compareTo(BI_NULL_VALUE_UINT64) > 0) {
                    throw new IllegalArgumentException("Value greater than UINT64 allows: value=" + value);
                }
                return new PrimitiveValue(biValue.longValue(), 8);
            }
            case FLOAT: {
                return new PrimitiveValue(Float.parseFloat(value), 4);
            }
            case DOUBLE: {
                return new PrimitiveValue(Double.parseDouble(value), 8);
            }
        }
        throw new IllegalArgumentException("Unknown PrimitiveType: " + (Object)((Object)primitiveType));
    }

    public static PrimitiveValue parse(String value, PrimitiveType primitiveType, int length, String characterEncoding) {
        return new PrimitiveValue(value.getBytes(Charset.forName(characterEncoding)), characterEncoding, length);
    }

    public long longValue() {
        if (this.representation != Representation.LONG) {
            throw new IllegalStateException("PrimitiveValue is not a long representation");
        }
        return this.longValue;
    }

    public double doubleValue() {
        if (this.representation != Representation.DOUBLE) {
            throw new IllegalStateException("PrimitiveValue is not a double representation");
        }
        return this.doubleValue;
    }

    public byte[] byteArrayValue() {
        if (this.representation != Representation.BYTE_ARRAY) {
            throw new IllegalStateException("PrimitiveValue is not a byte[] representation");
        }
        return this.byteArrayValue;
    }

    public byte[] byteArrayValue(PrimitiveType type) {
        if (this.representation == Representation.BYTE_ARRAY) {
            return this.byteArrayValue;
        }
        if (this.representation == Representation.LONG && this.size == 1 && type == PrimitiveType.CHAR) {
            this.byteArrayValueForLong[0] = (byte)this.longValue;
            return this.byteArrayValueForLong;
        }
        throw new IllegalStateException("PrimitiveValue is not a byte[] representation");
    }

    public int size() {
        return this.size;
    }

    public String characterEncoding() {
        return this.characterEncoding;
    }

    public String toString() {
        switch (this.representation) {
            case LONG: {
                return Long.toString(this.longValue);
            }
            case DOUBLE: {
                return Double.toString(this.doubleValue);
            }
            case BYTE_ARRAY: {
                try {
                    return this.characterEncoding == null ? new String(this.byteArrayValue) : new String(this.byteArrayValue, this.characterEncoding);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        throw new IllegalStateException("Unsupported Representation: " + (Object)((Object)this.representation));
    }

    public boolean equals(Object value) {
        if (null != value && value instanceof PrimitiveValue) {
            PrimitiveValue rhs = (PrimitiveValue)value;
            if (this.representation == rhs.representation) {
                switch (this.representation) {
                    case LONG: {
                        return this.longValue == rhs.longValue;
                    }
                    case DOUBLE: {
                        return Double.doubleToLongBits(this.doubleValue) == Double.doubleToLongBits(rhs.doubleValue);
                    }
                    case BYTE_ARRAY: {
                        return Arrays.equals(this.byteArrayValue, rhs.byteArrayValue);
                    }
                }
            }
        }
        return false;
    }

    public int hashCode() {
        long bits;
        switch (this.representation) {
            case LONG: {
                bits = this.longValue;
                break;
            }
            case DOUBLE: {
                bits = Double.doubleToLongBits(this.doubleValue);
                break;
            }
            case BYTE_ARRAY: {
                return Arrays.hashCode(this.byteArrayValue);
            }
            default: {
                throw new IllegalStateException("Unrecognised representation: " + (Object)((Object)this.representation));
            }
        }
        return (int)(bits ^ bits >>> 32);
    }

    public static enum Representation {
        LONG,
        DOUBLE,
        BYTE_ARRAY;

    }
}

