/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.TargetCodeGenerator;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrDecoder;
import uk.co.real_logic.sbe.ir.IrEncoder;
import uk.co.real_logic.sbe.xml.IrGenerator;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.ParserOptions;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class SbeTool {
    public static final String VALIDATION_STOP_ON_ERROR = "sbe.validation.stop.on.error";
    public static final String VALIDATION_WARNINGS_FATAL = "sbe.validation.warnings.fatal";
    public static final String VALIDATION_XSD = "sbe.validation.xsd";
    public static final String VALIDATION_SUPPRESS_OUTPUT = "sbe.validation.suppress.output";
    public static final String GENERATE_STUBS = "sbe.generate.stubs";
    public static final String GENERATE_IR = "sbe.generate.ir";
    public static final String TARGET_LANGUAGE = "sbe.target.language";
    public static final String OUTPUT_DIR = "sbe.output.dir";
    public static final String TARGET_NAMESPACE = "sbe.target.namespace";

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.format("Usage: %s <filenames>...\n", SbeTool.class.getName());
            System.exit(-1);
        }
        for (String fileName : args) {
            Ir ir;
            if (fileName.endsWith(".xml")) {
                String xsdFilename = System.getProperty(VALIDATION_XSD);
                if (xsdFilename != null) {
                    SbeTool.validateAgainstSchema(fileName, xsdFilename);
                }
                ir = new IrGenerator().generate(SbeTool.parseSchema(fileName), System.getProperty(TARGET_NAMESPACE));
            } else if (fileName.endsWith(".sbeir")) {
                ir = new IrDecoder(fileName).decode();
            } else {
                System.err.println("Input file format not supported: " + fileName);
                System.exit(-1);
                return;
            }
            if (Boolean.parseBoolean(System.getProperty(GENERATE_STUBS, "true"))) {
                String outputDirName = System.getProperty(OUTPUT_DIR, ".");
                String targetLanguage = System.getProperty(TARGET_LANGUAGE, "Java");
                SbeTool.generate(ir, outputDirName, targetLanguage);
            }
            if (!Boolean.parseBoolean(System.getProperty(GENERATE_IR, "false"))) continue;
            File inputFile = new File(fileName);
            String inputFilename = inputFile.getName();
            int nameEnd = inputFilename.lastIndexOf(46);
            String namePart = inputFilename.substring(0, nameEnd);
            String outputDirName = System.getProperty(OUTPUT_DIR, ".");
            File fullPath = new File(outputDirName, namePart + ".sbeir");
            try (IrEncoder irEncoder = new IrEncoder(fullPath.getAbsolutePath(), ir);){
                irEncoder.encode();
            }
        }
    }

    public static void validateAgainstSchema(String sbeSchemaFilename, String xsdFilename) throws Exception {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(sbeSchemaFilename));){
            XmlSchemaParser.validate(xsdFilename, in);
        }
    }

    public static MessageSchema parseSchema(String sbeSchemaFilename) throws Exception {
        ParserOptions.Builder optionsBuilder = ParserOptions.builder().xsdFilename(System.getProperty(VALIDATION_XSD)).stopOnError(Boolean.parseBoolean(System.getProperty(VALIDATION_STOP_ON_ERROR))).warningsFatal(Boolean.parseBoolean(System.getProperty(VALIDATION_WARNINGS_FATAL))).suppressOutput(Boolean.parseBoolean(System.getProperty(VALIDATION_SUPPRESS_OUTPUT)));
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(sbeSchemaFilename));){
            MessageSchema messageSchema = XmlSchemaParser.parse(in, optionsBuilder.build());
            return messageSchema;
        }
    }

    public static void generate(Ir ir, String outputDirName, String targetLanguage) throws Exception {
        TargetCodeGenerator targetCodeGenerator = TargetCodeGenerator.get(targetLanguage);
        CodeGenerator codeGenerator = targetCodeGenerator.newInstance(ir, outputDirName);
        codeGenerator.generate();
    }
}

