/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.codec.java;

import java.nio.ByteOrder;
import uk.co.real_logic.sbe.codec.java.DirectBuffer;

public class CodecUtil {
    public static void charPut(DirectBuffer buffer, int index, byte value) {
        buffer.putByte(index, value);
    }

    public static void charsPut(DirectBuffer buffer, int index, byte[] src, int offset, int length) {
        buffer.putBytes(index, src, offset, length);
    }

    public static void int8Put(DirectBuffer buffer, int index, byte value) {
        buffer.putByte(index, value);
    }

    public static void int8sPut(DirectBuffer buffer, int index, byte[] src, int offset, int length) {
        buffer.putBytes(index, src, offset, length);
    }

    public static void int16Put(DirectBuffer buffer, int index, short value, ByteOrder byteOrder) {
        buffer.putShort(index, value, byteOrder);
    }

    public static void int32Put(DirectBuffer buffer, int index, int value, ByteOrder byteOrder) {
        buffer.putInt(index, value, byteOrder);
    }

    public static void int64Put(DirectBuffer buffer, int index, long value, ByteOrder byteOrder) {
        buffer.putLong(index, value, byteOrder);
    }

    public static void uint8Put(DirectBuffer buffer, int index, short value) {
        buffer.putByte(index, (byte)value);
    }

    public static void uint16Put(DirectBuffer buffer, int index, int value, ByteOrder byteOrder) {
        buffer.putShort(index, (short)value, byteOrder);
    }

    public static void uint32Put(DirectBuffer buffer, int index, long value, ByteOrder byteOrder) {
        buffer.putInt(index, (int)value, byteOrder);
    }

    public static void uint64Put(DirectBuffer buffer, int index, long value, ByteOrder byteOrder) {
        buffer.putLong(index, value, byteOrder);
    }

    public static void floatPut(DirectBuffer buffer, int index, float value, ByteOrder byteOrder) {
        buffer.putFloat(index, value, byteOrder);
    }

    public static void doublePut(DirectBuffer buffer, int index, double value, ByteOrder byteOrder) {
        buffer.putDouble(index, value, byteOrder);
    }

    public static byte charGet(DirectBuffer buffer, int index) {
        return buffer.getByte(index);
    }

    public static void charsGet(DirectBuffer buffer, int index, byte[] dst, int offset, int length) {
        buffer.getBytes(index, dst, offset, length);
    }

    public static byte int8Get(DirectBuffer buffer, int index) {
        return buffer.getByte(index);
    }

    public static void int8sGet(DirectBuffer buffer, int index, byte[] dst, int offset, int length) {
        buffer.getBytes(index, dst, offset, length);
    }

    public static short int16Get(DirectBuffer buffer, int index, ByteOrder byteOrder) {
        return buffer.getShort(index, byteOrder);
    }

    public static int int32Get(DirectBuffer buffer, int index, ByteOrder byteOrder) {
        return buffer.getInt(index, byteOrder);
    }

    public static long int64Get(DirectBuffer buffer, int index, ByteOrder byteOrder) {
        return buffer.getLong(index, byteOrder);
    }

    public static short uint8Get(DirectBuffer buffer, int index) {
        return (short)(buffer.getByte(index) & 0xFF);
    }

    public static int uint16Get(DirectBuffer buffer, int index, ByteOrder byteOrder) {
        return buffer.getShort(index, byteOrder) & 0xFFFF;
    }

    public static long uint32Get(DirectBuffer buffer, int index, ByteOrder byteOrder) {
        return (long)buffer.getInt(index, byteOrder) & 0xFFFFFFFFL;
    }

    public static long uint64Get(DirectBuffer buffer, int index, ByteOrder byteOrder) {
        return buffer.getLong(index, byteOrder);
    }

    public static float floatGet(DirectBuffer buffer, int index, ByteOrder byteOrder) {
        return buffer.getFloat(index, byteOrder);
    }

    public static double doubleGet(DirectBuffer buffer, int index, ByteOrder byteOrder) {
        return buffer.getDouble(index, byteOrder);
    }

    public static boolean uint8GetChoice(DirectBuffer buffer, int index, int bitIndex) {
        return 0 != (buffer.getByte(index) & 1 << bitIndex);
    }

    public static void uint8PutChoice(DirectBuffer buffer, int index, int bitIndex, boolean switchOn) {
        byte bits = buffer.getByte(index);
        bits = (byte)(switchOn ? bits | 1 << bitIndex : bits & ~(1 << bitIndex));
        buffer.putByte(index, bits);
    }

    public static boolean uint16GetChoice(DirectBuffer buffer, int index, int bitIndex, ByteOrder byteOrder) {
        return 0 != (buffer.getShort(index, byteOrder) & 1 << bitIndex);
    }

    public static void uint16PutChoice(DirectBuffer buffer, int index, int bitIndex, boolean switchOn, ByteOrder byteOrder) {
        short bits = buffer.getShort(index, byteOrder);
        bits = (short)(switchOn ? bits | 1 << bitIndex : bits & ~(1 << bitIndex));
        buffer.putShort(index, bits, byteOrder);
    }

    public static boolean uint32GetChoice(DirectBuffer buffer, int index, int bitIndex, ByteOrder byteOrder) {
        return 0 != (buffer.getInt(index, byteOrder) & 1 << bitIndex);
    }

    public static void uint32PutChoice(DirectBuffer buffer, int index, int bitIndex, boolean switchOn, ByteOrder byteOrder) {
        int bits = buffer.getInt(index, byteOrder);
        bits = switchOn ? bits | 1 << bitIndex : bits & ~(1 << bitIndex);
        buffer.putInt(index, bits, byteOrder);
    }

    public static boolean uint64GetChoice(DirectBuffer buffer, int index, int bitIndex, ByteOrder byteOrder) {
        return 0L != (buffer.getLong(index, byteOrder) & 1L << bitIndex);
    }

    public static void uint64PutChoice(DirectBuffer buffer, int index, int bitIndex, boolean switchOn, ByteOrder byteOrder) {
        long bits = buffer.getLong(index, byteOrder);
        bits = switchOn ? bits | 1L << bitIndex : bits & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        buffer.putLong(index, bits, byteOrder);
    }
}

