/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.codec.java;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;
import uk.co.real_logic.sbe.codec.java.BitUtil;

public class DirectBuffer {
    private static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    private static final Unsafe UNSAFE = BitUtil.getUnsafe();
    private static final long BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private byte[] byteArray;
    private ByteBuffer byteBuffer;
    private long addressOffset;
    private int capacity;

    public DirectBuffer(byte[] buffer) {
        this.wrap(buffer);
    }

    public DirectBuffer(ByteBuffer buffer) {
        this.wrap(buffer);
    }

    public DirectBuffer(long address, int capacity) {
        this.wrap(address, capacity);
    }

    public void wrap(byte[] buffer) {
        this.addressOffset = BYTE_ARRAY_OFFSET;
        this.capacity = buffer.length;
        this.byteArray = buffer;
        this.byteBuffer = null;
    }

    public void wrap(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        if (buffer.hasArray()) {
            this.byteArray = buffer.array();
            this.addressOffset = BYTE_ARRAY_OFFSET + (long)buffer.arrayOffset();
        } else {
            this.byteArray = null;
            this.addressOffset = ((sun.nio.ch.DirectBuffer)((Object)buffer)).address();
        }
        this.capacity = buffer.capacity();
    }

    public void wrap(long address, int capacity) {
        this.addressOffset = address;
        this.capacity = capacity;
        this.byteArray = null;
        this.byteBuffer = null;
    }

    public byte[] array() {
        return this.byteArray;
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    public int capacity() {
        return this.capacity;
    }

    public void checkLimit(int limit) {
        if (limit > this.capacity) {
            String msg = String.format("limit=%d is beyond capacity=%d", limit, this.capacity);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public ByteBuffer duplicateByteBuffer() {
        ByteBuffer duplicate = null == this.byteBuffer ? (null != this.byteArray ? ByteBuffer.wrap(this.byteArray) : BitUtil.resetAddressAndCapacity(ByteBuffer.allocateDirect(0), this.addressOffset, this.capacity)) : this.byteBuffer.duplicate();
        duplicate.clear();
        return duplicate;
    }

    public long getLong(int index, ByteOrder byteOrder) {
        long bits = UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    public void putLong(int index, long value, ByteOrder byteOrder) {
        long bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
    }

    public int getInt(int index, ByteOrder byteOrder) {
        int bits = UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    public void putInt(int index, int value, ByteOrder byteOrder) {
        int bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
    }

    public double getDouble(int index, ByteOrder byteOrder) {
        if (NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    public void putDouble(int index, double value, ByteOrder byteOrder) {
        if (NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    public float getFloat(int index, ByteOrder byteOrder) {
        if (NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    public void putFloat(int index, float value, ByteOrder byteOrder) {
        if (NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    public short getShort(int index, ByteOrder byteOrder) {
        short bits = UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    public void putShort(int index, short value, ByteOrder byteOrder) {
        short bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, bits);
    }

    public byte getByte(int index) {
        return UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
    }

    public void putByte(int index, byte value) {
        UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index, value);
    }

    public int getBytes(int index, byte[] dst) {
        return this.getBytes(index, dst, 0, dst.length);
    }

    public int getBytes(int index, byte[] dst, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        count = Math.min(count, dst.length - offset);
        UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, BYTE_ARRAY_OFFSET + (long)offset, count);
        return count;
    }

    public int getBytes(int index, DirectBuffer dst, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        count = Math.min(count, dst.capacity - offset);
        UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst.byteArray, dst.addressOffset + (long)offset, count);
        return count;
    }

    public int getBytes(int index, ByteBuffer dstBuffer, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        int count = Math.min(dstBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        int dstOffset = dstBuffer.position();
        if (dstBuffer.hasArray()) {
            dstByteArray = dstBuffer.array();
            dstBaseOffset = BYTE_ARRAY_OFFSET + (long)dstBuffer.arrayOffset();
        } else {
            dstByteArray = null;
            dstBaseOffset = ((sun.nio.ch.DirectBuffer)((Object)dstBuffer)).address();
        }
        UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, count);
        dstBuffer.position(dstBuffer.position() + count);
        return count;
    }

    public int putBytes(int index, byte[] src) {
        return this.putBytes(index, src, 0, src.length);
    }

    public int putBytes(int index, byte[] src, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        count = Math.min(count, src.length - offset);
        UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + (long)offset, this.byteArray, this.addressOffset + (long)index, count);
        return count;
    }

    public int putBytes(int index, DirectBuffer src, int offset, int length) {
        return src.getBytes(offset, this, index, length);
    }

    public int putBytes(int index, ByteBuffer srcBuffer, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        int count = Math.min(srcBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        int srcOffset = srcBuffer.position();
        if (srcBuffer.hasArray()) {
            srcByteArray = srcBuffer.array();
            srcBaseOffset = BYTE_ARRAY_OFFSET + (long)srcBuffer.arrayOffset();
        } else {
            srcByteArray = null;
            srcBaseOffset = ((sun.nio.ch.DirectBuffer)((Object)srcBuffer)).address();
        }
        UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcOffset, this.byteArray, this.addressOffset + (long)index, count);
        srcBuffer.position(srcBuffer.position() + count);
        return count;
    }
}

