/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation;

import java.io.IOException;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.cpp98.Cpp98Generator;
import uk.co.real_logic.sbe.generation.cpp98.NamespaceOutputManager;
import uk.co.real_logic.sbe.generation.csharp.CSharpGenerator;
import uk.co.real_logic.sbe.generation.csharp.CSharpNamespaceOutputManager;
import uk.co.real_logic.sbe.generation.java.JavaGenerator;
import uk.co.real_logic.sbe.generation.java.PackageOutputManager;
import uk.co.real_logic.sbe.ir.Ir;

public enum TargetCodeGenerator {
    JAVA{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) throws IOException {
            return new JavaGenerator(ir, new PackageOutputManager(outputDir, ir.applicableNamespace()));
        }
    }
    ,
    CPP98{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) throws IOException {
            return new Cpp98Generator(ir, new NamespaceOutputManager(outputDir, ir.applicableNamespace()));
        }
    }
    ,
    CSHARP{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) throws IOException {
            return new CSharpGenerator(ir, new CSharpNamespaceOutputManager(outputDir, ir.applicableNamespace()));
        }
    };


    public abstract CodeGenerator newInstance(Ir var1, String var2) throws IOException;

    public static TargetCodeGenerator get(String name) {
        for (TargetCodeGenerator target : TargetCodeGenerator.values()) {
            if (!name.equalsIgnoreCase(target.name())) continue;
            return target;
        }
        throw new IllegalArgumentException("No code generator for name: " + name);
    }
}

