/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.cpp98;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.OutputManager;
import uk.co.real_logic.sbe.generation.cpp98.Cpp98Util;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.util.Verify;

public class Cpp98Generator
implements CodeGenerator {
    private static final String BASE_INDENT = "";
    private static final String INDENT = "    ";
    private final Ir ir;
    private final OutputManager outputManager;

    public Cpp98Generator(Ir ir, OutputManager outputManager) throws IOException {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    public void generateMessageHeaderStub() throws IOException {
        try (Writer out = this.outputManager.createOutput("MessageHeader");){
            List<Token> tokens = this.ir.headerStructure().tokens();
            out.append(this.generateFileHeader(this.ir.applicableNamespace().replace('.', '_'), "MessageHeader", null));
            out.append(this.generateClassDeclaration("MessageHeader"));
            out.append(this.generateFixedFlyweightCode("MessageHeader", tokens.get(0).size()));
            out.append(this.generatePrimitivePropertyEncodings("MessageHeader", tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append("};\n}\n#endif\n");
        }
    }

    public List<String> generateTypeStubs() throws IOException {
        ArrayList<String> typesToInclude = new ArrayList<String>();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateChoiceSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                }
            }
            typesToInclude.add(tokens.get(0).name());
        }
        return typesToInclude;
    }

    @Override
    public void generate() throws IOException {
        this.generateMessageHeaderStub();
        List<String> typesToInclude = this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String className = Cpp98Util.formatClassName(msgToken.name());
            Writer out = this.outputManager.createOutput(className);
            Throwable throwable = null;
            try {
                out.append(this.generateFileHeader(this.ir.applicableNamespace().replace('.', '_'), className, typesToInclude));
                out.append(this.generateClassDeclaration(className));
                out.append(this.generateMessageFlyweightCode(className, msgToken));
                List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
                int offset = 0;
                ArrayList<Token> rootFields = new ArrayList<Token>();
                offset = this.collectRootFields(messageBody, offset, rootFields);
                out.append(this.generateFields(className, rootFields, BASE_INDENT));
                ArrayList<Token> groups = new ArrayList<Token>();
                offset = this.collectGroups(messageBody, offset, groups);
                StringBuilder sb = new StringBuilder();
                this.generateGroups(sb, groups, 0, BASE_INDENT);
                out.append(sb);
                List<Token> varData = messageBody.subList(offset, messageBody.size());
                out.append(this.generateVarData(varData));
                out.append("};\n}\n#endif\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private int collectRootFields(List<Token> tokens, int index, List<Token> rootFields) {
        int size = tokens.size();
        while (index < size) {
            Token token = tokens.get(index);
            if (Signal.BEGIN_GROUP == token.signal() || Signal.END_GROUP == token.signal() || Signal.BEGIN_VAR_DATA == token.signal()) {
                return index;
            }
            rootFields.add(token);
            ++index;
        }
        return index;
    }

    private int collectGroups(List<Token> tokens, int index, List<Token> groups) {
        int size = tokens.size();
        while (index < size) {
            Token token = tokens.get(index);
            if (Signal.BEGIN_VAR_DATA == token.signal()) {
                return index;
            }
            groups.add(token);
            ++index;
        }
        return index;
    }

    private int generateGroups(StringBuilder sb, List<Token> tokens, int index, String indent) {
        int size = tokens.size();
        while (index < size) {
            if (tokens.get(index).signal() == Signal.BEGIN_GROUP) {
                Token groupToken = tokens.get(index);
                String groupName = groupToken.name();
                this.generateGroupClassHeader(sb, groupName, tokens, index, indent + INDENT);
                ArrayList<Token> rootFields = new ArrayList<Token>();
                ++index;
                index = this.collectRootFields(tokens, index, rootFields);
                sb.append(this.generateFields(groupName, rootFields, indent + INDENT));
                if (tokens.get(index).signal() == Signal.BEGIN_GROUP) {
                    index = this.generateGroups(sb, tokens, index, indent + INDENT);
                }
                sb.append(indent).append("    };\n");
                sb.append(this.generateGroupProperty(groupName, groupToken, indent));
            }
            ++index;
        }
        return index;
    }

    private void generateGroupClassHeader(StringBuilder sb, String groupName, List<Token> tokens, int index, String indent) {
        String dimensionsClassName = Cpp98Util.formatClassName(tokens.get(index + 1).name());
        Integer dimensionHeaderSize = tokens.get(index + 1).size();
        sb.append(String.format("\n" + indent + "class %1$s\n" + indent + "{\n" + indent + "private:\n" + indent + "    char *buffer_;\n" + indent + "    int bufferLength_;\n" + indent + "    int *positionPtr_;\n" + indent + "    int blockLength_;\n" + indent + "    int count_;\n" + indent + "    int index_;\n" + indent + "    int offset_;\n" + indent + "    int actingVersion_;\n" + indent + "    %2$s dimensions_;\n\n" + indent + "public:\n\n", Cpp98Util.formatClassName(groupName), dimensionsClassName));
        sb.append(String.format(indent + "    void wrapForDecode(char *buffer, int *pos, const int actingVersion, const int bufferLength)\n" + indent + "    {\n" + indent + "        buffer_ = buffer;\n" + indent + "        bufferLength_ = bufferLength;\n" + indent + "        dimensions_.wrap(buffer_, *pos, actingVersion, bufferLength);\n" + indent + "        blockLength_ = dimensions_.blockLength();\n" + indent + "        count_ = dimensions_.numInGroup();\n" + indent + "        index_ = -1;\n" + indent + "        actingVersion_ = actingVersion;\n" + indent + "        positionPtr_ = pos;\n" + indent + "        *positionPtr_ = *positionPtr_ + %1$d;\n" + indent + "    }\n\n", dimensionHeaderSize));
        Integer blockLength = tokens.get(index).size();
        String cpp98TypeForBlockLength = Cpp98Util.cpp98TypeName(tokens.get(index + 2).encoding().primitiveType());
        String cpp98TypeForNumInGroup = Cpp98Util.cpp98TypeName(tokens.get(index + 3).encoding().primitiveType());
        sb.append(String.format(indent + "    void wrapForEncode(char *buffer, const int count,\n" + indent + "                       int *pos, const int actingVersion, const int bufferLength)\n" + indent + "    {\n" + indent + "        buffer_ = buffer;\n" + indent + "        bufferLength_ = bufferLength;\n" + indent + "        dimensions_.wrap(buffer_, *pos, actingVersion, bufferLength);\n" + indent + "        dimensions_.blockLength((%1$s)%2$d);\n" + indent + "        dimensions_.numInGroup((%3$s)count);\n" + indent + "        index_ = -1;\n" + indent + "        count_ = count;\n" + indent + "        blockLength_ = %2$d;\n" + indent + "        actingVersion_ = actingVersion;\n" + indent + "        positionPtr_ = pos;\n" + indent + "        *positionPtr_ = *positionPtr_ + %4$d;\n" + indent + "    }\n\n", cpp98TypeForBlockLength, blockLength, cpp98TypeForNumInGroup, dimensionHeaderSize));
        sb.append(String.format(indent + "    static int sbeHeaderSize()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n\n", dimensionHeaderSize));
        sb.append(String.format(indent + "    static int sbeBlockLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n\n", blockLength));
        sb.append(String.format(indent + "    int count(void) const\n" + indent + "    {\n" + indent + "        return count_;\n" + indent + "    }\n\n" + indent + "    bool hasNext(void) const\n" + indent + "    {\n" + indent + "        return index_ + 1 < count_;\n" + indent + "    }\n\n", new Object[0]));
        sb.append(String.format(indent + "    %1$s &next(void)\n" + indent + "    {\n" + indent + "        offset_ = *positionPtr_;\n" + indent + "        if (SBE_BOUNDS_CHECK_EXPECT(( (offset_ + blockLength_) > bufferLength_ ),0))\n" + indent + "        {\n" + indent + "            throw \"buffer too short to support next group index\";\n" + indent + "        }\n" + indent + "        *positionPtr_ = offset_ + blockLength_;\n" + indent + "        ++index_;\n\n" + indent + "        return *this;\n" + indent + "    }\n\n", Cpp98Util.formatClassName(groupName)));
    }

    private CharSequence generateGroupProperty(String groupName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String className = Cpp98Util.formatClassName(groupName);
        String propertyName = Cpp98Util.formatPropertyName(groupName);
        sb.append(String.format("\nprivate:\n" + indent + "    %1$s %2$s_;\n\n" + "public:\n", className, propertyName));
        sb.append(String.format("\n" + indent + "    static int %1$sId(void)\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n", groupName, (long)token.id()));
        sb.append(String.format("\n" + indent + "    %1$s &%2$s(void)\n" + indent + "    {\n" + indent + "        %2$s_.wrapForDecode(buffer_, positionPtr_, actingVersion_, bufferLength_);\n" + indent + "        return %2$s_;\n" + indent + "    }\n", className, propertyName));
        sb.append(String.format("\n" + indent + "    %1$s &%2$sCount(const int count)\n" + indent + "    {\n" + indent + "        %2$s_.wrapForEncode(buffer_, count, positionPtr_, actingVersion_, bufferLength_);\n" + indent + "        return %2$s_;\n" + indent + "    }\n", className, propertyName));
        return sb;
    }

    private CharSequence generateVarData(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = Cpp98Util.toUpperFirstChar(token.name());
            String characterEncoding = tokens.get(i + 3).encoding().characterEncoding();
            Token lengthToken = tokens.get(i + 2);
            Integer sizeOfLengthField = lengthToken.size();
            String lengthCpp98Type = Cpp98Util.cpp98TypeName(lengthToken.encoding().primitiveType());
            this.generateFieldMetaAttributeMethod(sb, token, BASE_INDENT);
            this.generateVarDataDecriptors(sb, token, propertyName, characterEncoding, lengthToken, sizeOfLengthField, lengthCpp98Type);
            sb.append(String.format("    const char *%1$s(void)\n    {\n%2$s         const char *fieldPtr = (buffer_ + position() + %3$d);\n         position(position() + %3$d + *((%4$s *)(buffer_ + position())));\n         return fieldPtr;\n    }\n\n", Cpp98Util.formatPropertyName(propertyName), this.generateTypeFieldNotPresentCondition(token.version(), BASE_INDENT), sizeOfLengthField, lengthCpp98Type));
            sb.append(String.format("    int get%1$s(char *dst, const int length)\n    {\n%2$s        sbe_uint64_t sizeOfLengthField = %3$d;\n        sbe_uint64_t lengthPosition = position();\n        position(lengthPosition + sizeOfLengthField);\n        sbe_int64_t dataLength = %4$s(*((%5$s *)(buffer_ + lengthPosition)));\n        int bytesToCopy = (length < dataLength) ? length : dataLength;\n        sbe_uint64_t pos = position();\n        position(position() + (sbe_uint64_t)dataLength);\n        ::memcpy(dst, buffer_ + pos, bytesToCopy);\n        return bytesToCopy;\n    }\n\n", propertyName, this.generateArrayFieldNotPresentCondition(token.version(), BASE_INDENT), sizeOfLengthField, Cpp98Util.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType()), lengthCpp98Type));
            sb.append(String.format("    int put%1$s(const char *src, const int length)\n    {\n        sbe_uint64_t sizeOfLengthField = %2$d;\n        sbe_uint64_t lengthPosition = position();\n        *((%3$s *)(buffer_ + lengthPosition)) = %4$s((%3$s)length);\n        position(lengthPosition + sizeOfLengthField);\n        sbe_uint64_t pos = position();\n        position(position() + (sbe_uint64_t)length);\n        ::memcpy(buffer_ + pos, src, length);\n        return length;\n    }\n", propertyName, sizeOfLengthField, lengthCpp98Type, Cpp98Util.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType())));
        }
        return sb;
    }

    private void generateVarDataDecriptors(StringBuilder sb, Token token, String propertyName, String characterEncoding, Token lengthToken, Integer sizeOfLengthField, String lengthCpp98Type) {
        sb.append(String.format("\n    static const char *%1$sCharacterEncoding()\n    {\n        return \"%2$s\";\n    }\n\n", Cpp98Util.formatPropertyName(propertyName), characterEncoding));
        sb.append(String.format("    static int %1$sSinceVersion(void)\n    {\n         return %2$d;\n    }\n\n    bool %1$sInActingVersion(void)\n    {\n        return (actingVersion_ >= %2$s) ? true : false;\n    }\n\n    static int %1$sId(void)\n    {\n        return %3$d;\n    }\n\n", Cpp98Util.formatPropertyName(propertyName), (long)token.version(), token.id()));
        sb.append(String.format("\n    static int %sHeaderSize()\n    {\n        return %d;\n    }\n", Cpp98Util.toLowerFirstChar(propertyName), sizeOfLengthField));
        sb.append(String.format("\n    sbe_int64_t %1$sLength(void) const\n    {\n%2$s        return %3$s(*((%4$s *)(buffer_ + position())));\n    }\n\n", Cpp98Util.formatPropertyName(propertyName), this.generateArrayFieldNotPresentCondition(token.version(), BASE_INDENT), Cpp98Util.formatByteOrderEncoding(lengthToken.encoding().byteOrder(), lengthToken.encoding().primitiveType()), lengthCpp98Type));
    }

    private void generateChoiceSet(List<Token> tokens) throws IOException {
        String bitSetName = Cpp98Util.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(bitSetName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace().replace('.', '_'), bitSetName, null));
            out.append(this.generateClassDeclaration(bitSetName));
            out.append(this.generateFixedFlyweightCode(bitSetName, tokens.get(0).size()));
            out.append(String.format("\n    %1$s &clear(void)\n    {\n        *((%2$s *)(buffer_ + offset_)) = 0;\n        return *this;\n    }\n\n", bitSetName, Cpp98Util.cpp98TypeName(tokens.get(0).encoding().primitiveType())));
            out.append(this.generateChoices(bitSetName, tokens.subList(1, tokens.size() - 1)));
            out.append("};\n}\n#endif\n");
        }
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = Cpp98Util.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace().replace('.', '_'), enumName, null));
            out.append(this.generateEnumDeclaration(enumName));
            out.append(this.generateEnumValues(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append(this.generateEnumLookupMethod(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append("};\n}\n#endif\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String compositeName = Cpp98Util.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(compositeName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace().replace('.', '_'), compositeName, null));
            out.append(this.generateClassDeclaration(compositeName));
            out.append(this.generateFixedFlyweightCode(compositeName, tokens.get(0).size()));
            out.append(this.generatePrimitivePropertyEncodings(compositeName, tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append("};\n}\n#endif\n");
        }
    }

    private CharSequence generateChoiceNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion_ < %1$d)\n" + indent + "        {\n" + indent + "            return false;\n" + indent + "        }\n\n", sinceVersion);
    }

    private CharSequence generateChoices(String bitsetClassName, List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String choiceName = token.name();
            String typeName = Cpp98Util.cpp98TypeName(token.encoding().primitiveType());
            String choiceBitPosition = token.encoding().constValue().toString();
            String byteOrderStr = Cpp98Util.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType());
            sb.append(String.format("\n    bool %1$s(void) const\n    {\n%2$s        return (%3$s(*((%4$s *)(buffer_ + offset_))) & (0x1L << %5$s)) ? true : false;\n    }\n\n", choiceName, this.generateChoiceNotPresentCondition(token.version(), BASE_INDENT), byteOrderStr, typeName, choiceBitPosition));
            sb.append(String.format("    %1$s &%2$s(const bool value)\n    {\n        %3$s bits = %4$s(*((%3$s *)(buffer_ + offset_)));\n        bits = value ? (bits | (0x1L << %5$s)) : (bits & ~(0x1L << %5$s));\n        *((%3$s *)(buffer_ + offset_)) = %4$s(bits);\n        return *this;\n    }\n", bitsetClassName, choiceName, typeName, byteOrderStr, choiceBitPosition));
        }
        return sb;
    }

    private CharSequence generateEnumValues(List<Token> tokens, Token encodingToken) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = encodingToken.encoding();
        sb.append("    enum Value \n    {\n");
        for (Token token : tokens) {
            CharSequence constVal = this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString());
            sb.append("        ").append(token.name()).append(" = ").append(constVal).append(",\n");
        }
        sb.append(String.format("        NULL_VALUE = %1$s", this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString())));
        sb.append("\n    };\n\n");
        return sb;
    }

    private CharSequence generateEnumLookupMethod(List<Token> tokens, Token encodingToken) {
        String enumName = Cpp98Util.formatClassName(encodingToken.name());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("    static %1$s::Value get(const %2$s value)\n    {\n        switch (value)\n        {\n", enumName, Cpp98Util.cpp98TypeName(tokens.get(0).encoding().primitiveType())));
        for (Token token : tokens) {
            sb.append(String.format("            case %1$s: return %2$s;\n", token.encoding().constValue().toString(), token.name()));
        }
        sb.append(String.format("            case %1$s: return NULL_VALUE;\n        }\n\n        throw \"unknown value for enum %2$s\";\n    }\n", encodingToken.encoding().applicableNullValue().toString(), enumName));
        return sb;
    }

    private CharSequence generateFieldNotPresentCondition(int sinceVersion, Encoding encoding, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion_ < %1$d)\n" + indent + "        {\n" + indent + "            return %2$s;\n" + indent + "        }\n\n", sinceVersion, this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()));
    }

    private CharSequence generateArrayFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion_ < %1$d)\n" + indent + "        {\n" + indent + "            return 0;\n" + indent + "        }\n\n", sinceVersion);
    }

    private CharSequence generateTypeFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion_ < %1$d)\n" + indent + "        {\n" + indent + "            return NULL;\n" + indent + "        }\n\n", sinceVersion);
    }

    private CharSequence generateFileHeader(String namespaceName, String className, List<String> typesToInclude) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("/* Generated SBE (Simple Binary Encoding) message codec */\n", new Object[0]));
        sb.append(String.format("#ifndef _%1$s_HPP_\n#define _%1$s_HPP_\n\n#if defined(SBE_HAVE_CMATH)\n/* cmath needed for std::numeric_limits<double>::quiet_NaN() */\n#  include <cmath>\n#  define SBE_FLOAT_NAN std::numeric_limits<float>::quiet_NaN()\n#  define SBE_DOUBLE_NAN std::numeric_limits<double>::quiet_NaN()\n#else\n/* math.h needed for NAN */\n#  include <math.h>\n#  define SBE_FLOAT_NAN NAN\n#  define SBE_DOUBLE_NAN NAN\n#endif\n\n#include <sbe/sbe.hpp>\n\n", className.toUpperCase()));
        if (typesToInclude != null) {
            for (String incName : typesToInclude) {
                sb.append(String.format("#include <%1$s/%2$s.hpp>\n", namespaceName, Cpp98Util.toUpperFirstChar(incName)));
            }
            sb.append("\n");
        }
        sb.append(String.format("using namespace sbe;\n\nnamespace %1$s {\n\n", namespaceName));
        return sb;
    }

    private CharSequence generateClassDeclaration(String className) {
        return String.format("class %s\n{\n", className);
    }

    private CharSequence generateEnumDeclaration(String name) {
        return "class " + name + "\n{\npublic:\n\n";
    }

    private CharSequence generatePrimitivePropertyEncodings(String containingClassName, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (token.signal() != Signal.ENCODING) continue;
            sb.append(this.generatePrimitiveProperty(containingClassName, token.name(), token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitiveProperty(String containingClassName, String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatePrimitiveFieldMetaData(propertyName, token, indent));
        if (Encoding.Presence.CONSTANT == token.encoding().presence()) {
            sb.append(this.generateConstPropertyMethods(propertyName, token, indent));
        } else {
            sb.append(this.generatePrimitivePropertyMethods(containingClassName, propertyName, token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitivePropertyMethods(String containingClassName, String propertyName, Token token, String indent) {
        int arrayLength = token.arrayLength();
        if (arrayLength == 1) {
            return this.generateSingleValueProperty(containingClassName, propertyName, token, indent);
        }
        if (arrayLength > 1) {
            return this.generateArrayProperty(containingClassName, propertyName, token, indent);
        }
        return BASE_INDENT;
    }

    private CharSequence generatePrimitiveFieldMetaData(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        PrimitiveType primitiveType = token.encoding().primitiveType();
        String cpp98TypeName = Cpp98Util.cpp98TypeName(primitiveType);
        sb.append(String.format("\n" + indent + "    static %1$s %2$sNullValue()\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cpp98TypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableNullValue().toString())));
        sb.append(String.format("\n" + indent + "    static %1$s %2$sMinValue()\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cpp98TypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString())));
        sb.append(String.format("\n" + indent + "    static %1$s %2$sMaxValue()\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cpp98TypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString())));
        return sb;
    }

    private CharSequence generateSingleValueProperty(String containingClassName, String propertyName, Token token, String indent) {
        String cpp98TypeName = Cpp98Util.cpp98TypeName(token.encoding().primitiveType());
        Integer offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    %1$s %2$s(void) const\n" + indent + "    {\n" + "%3$s" + indent + "        return %4$s(*((%1$s *)(buffer_ + offset_ + %5$d)));\n" + indent + "    }\n\n", cpp98TypeName, propertyName, this.generateFieldNotPresentCondition(token.version(), token.encoding(), indent), Cpp98Util.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType()), offset));
        sb.append(String.format(indent + "    %1$s &%2$s(const %3$s value)\n" + indent + "    {\n" + indent + "        *((%3$s *)(buffer_ + offset_ + %4$d)) = %5$s(value);\n" + indent + "        return *this;\n" + indent + "    }\n", Cpp98Util.formatClassName(containingClassName), propertyName, cpp98TypeName, offset, Cpp98Util.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType())));
        return sb;
    }

    private CharSequence generateArrayProperty(String containingClassName, String propertyName, Token token, String indent) {
        String cpp98TypeName = Cpp98Util.cpp98TypeName(token.encoding().primitiveType());
        Integer offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    static int %1$sLength(void)\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n", propertyName, token.arrayLength()));
        sb.append(String.format(indent + "    const char *%1$s(void) const\n" + indent + "    {\n" + "%2$s" + indent + "        return (buffer_ + offset_ + %3$d);\n" + indent + "    }\n\n", propertyName, this.generateTypeFieldNotPresentCondition(token.version(), indent), offset));
        sb.append(String.format(indent + "    %1$s %2$s(const int index) const\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %3$d)\n" + indent + "        {\n" + indent + "            throw \"index out of range for %2$s\";\n" + indent + "        }\n\n" + "%4$s" + indent + "        return %5$s(*((%1$s *)(buffer_ + offset_ + %6$d + (index * %7$d))));\n" + indent + "    }\n\n", cpp98TypeName, propertyName, token.arrayLength(), this.generateFieldNotPresentCondition(token.version(), token.encoding(), indent), Cpp98Util.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType()), offset, token.encoding().primitiveType().size()));
        sb.append(String.format(indent + "    void %1$s(const int index, const %2$s value)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %3$d)\n" + indent + "        {\n" + indent + "            throw \"index out of range for %1$s\";\n" + indent + "        }\n\n" + indent + "        *((%2$s *)(buffer_ + offset_ + %4$d + (index * %5$d))) = %6$s(value);\n" + indent + "    }\n\n", propertyName, cpp98TypeName, token.arrayLength(), offset, token.encoding().primitiveType().size(), Cpp98Util.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType())));
        sb.append(String.format(indent + "    int get%1$s(char *dst, const int length) const\n" + indent + "    {\n" + indent + "        if (length > %2$d)\n" + indent + "        {\n" + indent + "             throw \"length too large for get%1$s\";\n" + indent + "        }\n\n" + "%3$s" + indent + "        ::memcpy(dst, buffer_ + offset_ + %4$d, length);\n" + indent + "        return length;\n" + indent + "    }\n\n", Cpp98Util.toUpperFirstChar(propertyName), token.arrayLength(), this.generateArrayFieldNotPresentCondition(token.version(), indent), offset));
        sb.append(String.format(indent + "    %1$s &put%2$s(const char *src)\n" + indent + "    {\n" + indent + "        ::memcpy(buffer_ + offset_ + %3$d, src, %4$d);\n" + indent + "        return *this;\n" + indent + "    }\n", containingClassName, Cpp98Util.toUpperFirstChar(propertyName), offset, token.arrayLength()));
        return sb;
    }

    private CharSequence generateConstPropertyMethods(String propertyName, Token token, String indent) {
        String cpp98TypeName = Cpp98Util.cpp98TypeName(token.encoding().primitiveType());
        if (token.encoding().primitiveType() != PrimitiveType.CHAR) {
            return String.format("\n" + indent + "    %1$s %2$s(void) const\n" + indent + "    {\n" + indent + "        return %3$s;\n" + indent + "    }\n", cpp98TypeName, propertyName, this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString()));
        }
        StringBuilder sb = new StringBuilder();
        byte[] constantValue = token.encoding().constValue().byteArrayValue(token.encoding().primitiveType());
        StringBuilder values = new StringBuilder();
        for (byte b : constantValue) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        sb.append(String.format("\n" + indent + "    static int %1$sLength(void)\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n", propertyName, constantValue.length));
        sb.append(String.format(indent + "    const char *%1$s(void) const\n" + indent + "    {\n" + indent + "        static sbe_uint8_t %1$sValues[] = {%2$s};\n\n" + indent + "        return (const char *)%1$sValues;\n" + indent + "    }\n\n", propertyName, values));
        sb.append(String.format(indent + "    %1$s %2$s(const int index) const\n" + indent + "    {\n" + indent + "        static sbe_uint8_t %2$sValues[] = {%3$s};\n\n" + indent + "        return %2$sValues[index];\n" + indent + "    }\n\n", cpp98TypeName, propertyName, values));
        sb.append(String.format(indent + "    int get%1$s(char *dst, const int length) const\n" + indent + "    {\n" + indent + "        static sbe_uint8_t %2$sValues[] = {%3$s};\n" + indent + "        int bytesToCopy = (length < sizeof(%2$sValues)) ? length : sizeof(%2$sValues);\n\n" + indent + "        ::memcpy(dst, %2$sValues, bytesToCopy);\n" + indent + "        return bytesToCopy;\n" + indent + "    }\n", Cpp98Util.toUpperFirstChar(propertyName), propertyName, values));
        return sb;
    }

    private CharSequence generateFixedFlyweightCode(String className, int size) {
        return String.format("private:\n    char *buffer_;\n    int offset_;\n    int actingVersion_;\n\npublic:\n    %1$s &wrap(char *buffer, const int offset, const int actingVersion, const int bufferLength)\n    {\n        if (SBE_BOUNDS_CHECK_EXPECT((offset > (bufferLength - %2$s)), 0))\n        {\n            throw \"buffer too short for flyweight\";\n        }\n        buffer_ = buffer;\n        offset_ = offset;\n        actingVersion_ = actingVersion;\n        return *this;\n    }\n\n    static int size(void)\n    {\n        return %2$s;\n    }\n\n", className, size);
    }

    private CharSequence generateMessageFlyweightCode(String className, Token token) {
        String blockLengthType = Cpp98Util.cpp98TypeName(this.ir.headerStructure().blockLengthType());
        String templateIdType = Cpp98Util.cpp98TypeName(this.ir.headerStructure().templateIdType());
        String schemaIdType = Cpp98Util.cpp98TypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = Cpp98Util.cpp98TypeName(this.ir.headerStructure().schemaVersionType());
        String semanticType = token.encoding().semanticType() == null ? BASE_INDENT : token.encoding().semanticType();
        return String.format("private:\n    char *buffer_;\n    int bufferLength_;\n    int *positionPtr_;\n    int offset_;\n    int position_;\n    int actingBlockLength_;\n    int actingVersion_;\n\n    %10$s(const %10$s&) {}\n\npublic:\n\n    %10$s(void) : buffer_(NULL), bufferLength_(0), offset_(0) {}\n\n    static %1$s sbeBlockLength(void)\n    {\n        return %2$s;\n    }\n\n    static %3$s sbeTemplateId(void)\n    {\n        return %4$s;\n    }\n\n    static %5$s sbeSchemaId(void)\n    {\n        return %6$s;\n    }\n\n    static %7$s sbeSchemaVersion(void)\n    {\n        return %8$s;\n    }\n\n    static const char *sbeSemanticType(void)\n    {\n        return \"%9$s\";\n    }\n\n    sbe_uint64_t offset(void) const\n    {\n        return offset_;\n    }\n\n    %10$s &wrapForEncode(char *buffer, const int offset, const int bufferLength)\n    {\n        buffer_ = buffer;\n        offset_ = offset;\n        bufferLength_ = bufferLength;\n        actingBlockLength_ = sbeBlockLength();\n        actingVersion_ = sbeSchemaVersion();\n        position(offset + actingBlockLength_);\n        positionPtr_ = &position_;\n        return *this;\n    }\n\n    %10$s &wrapForDecode(char *buffer, const int offset, const int actingBlockLength, const int actingVersion,\n                         const int bufferLength)\n    {\n        buffer_ = buffer;\n        offset_ = offset;\n        bufferLength_ = bufferLength;\n        actingBlockLength_ = actingBlockLength;\n        actingVersion_ = actingVersion;\n        positionPtr_ = &position_;\n        position(offset + actingBlockLength_);\n        return *this;\n    }\n\n    sbe_uint64_t position(void) const\n    {\n        return position_;\n    }\n\n    void position(const sbe_uint64_t position)\n    {\n        if (SBE_BOUNDS_CHECK_EXPECT((position > bufferLength_), 0))\n        {\n            throw \"buffer too short\";\n        }\n        position_ = position;\n    }\n\n    int size(void) const\n    {\n        return position() - offset_;\n    }\n\n    char *buffer(void)\n    {\n        return buffer_;\n    }\n\n    int actingVersion(void) const\n    {\n        return actingVersion_;\n    }\n", blockLengthType, this.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.size())), templateIdType, this.generateLiteral(this.ir.headerStructure().templateIdType(), Integer.toString(token.id())), schemaIdType, this.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(token.version())), semanticType, className);
    }

    private CharSequence generateFields(String containingClassName, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = Cpp98Util.formatPropertyName(signalToken.name());
            sb.append(String.format("\n" + indent + "    static int %1$sId(void)\n" + indent + "    {\n" + indent + "        return %2$d;\n" + indent + "    }\n\n", propertyName, signalToken.id()));
            sb.append(String.format(indent + "    static int %1$sSinceVersion(void)\n" + indent + "    {\n" + indent + "         return %2$d;\n" + indent + "    }\n\n" + indent + "    bool %1$sInActingVersion(void)\n" + indent + "    {\n" + indent + "        return (actingVersion_ >= %2$d) ? true : false;\n" + indent + "    }\n\n", propertyName, (long)signalToken.version()));
            this.generateFieldMetaAttributeMethod(sb, signalToken, indent);
            switch (encodingToken.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(containingClassName, propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(containingClassName, propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitsetProperty(propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, encodingToken, indent));
                }
            }
        }
        return sb;
    }

    private void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? BASE_INDENT : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? BASE_INDENT : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? BASE_INDENT : encoding.semanticType();
        sb.append(String.format("\n" + indent + "    static const char *%sMetaAttribute(const MetaAttribute::Attribute metaAttribute)\n" + indent + "    {\n" + indent + "        switch (metaAttribute)\n" + indent + "        {\n" + indent + "            case MetaAttribute::EPOCH: return \"%s\";\n" + indent + "            case MetaAttribute::TIME_UNIT: return \"%s\";\n" + indent + "            case MetaAttribute::SEMANTIC_TYPE: return \"%s\";\n" + indent + "        }\n\n" + indent + "        return \"\";\n" + indent + "    }\n", token.name(), epoch, timeUnit, semanticType));
    }

    private CharSequence generateEnumFieldNotPresentCondition(int sinceVersion, String enumName, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion_ < %1$d)\n" + indent + "        {\n" + indent + "            return %2$s::NULL_VALUE;\n" + indent + "        }\n\n", sinceVersion, enumName);
    }

    private CharSequence generateEnumProperty(String containingClassName, String propertyName, Token token, String indent) {
        String enumName = token.name();
        String typeName = Cpp98Util.cpp98TypeName(token.encoding().primitiveType());
        Integer offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    %1$s::Value %2$s(void) const\n" + indent + "    {\n" + "%3$s" + indent + "        return %1$s::get(%4$s(*((%5$s *)(buffer_ + offset_ + %6$d))));\n" + indent + "    }\n\n", enumName, propertyName, this.generateEnumFieldNotPresentCondition(token.version(), enumName, indent), Cpp98Util.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType()), typeName, offset));
        sb.append(String.format(indent + "    %1$s &%2$s(const %3$s::Value value)\n" + indent + "    {\n" + indent + "        *((%4$s *)(buffer_ + offset_ + %5$d)) = %6$s(value);\n" + indent + "        return *this;\n" + indent + "    }\n", Cpp98Util.formatClassName(containingClassName), propertyName, enumName, typeName, offset, Cpp98Util.formatByteOrderEncoding(token.encoding().byteOrder(), token.encoding().primitiveType())));
        return sb;
    }

    private Object generateBitsetProperty(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String bitsetName = Cpp98Util.formatClassName(token.name());
        Integer offset = token.offset();
        sb.append(String.format("\n" + indent + "private:\n" + indent + "    %1$s %2$s_;\n\n" + indent + "public:\n", bitsetName, propertyName));
        sb.append(String.format("\n" + indent + "    %1$s &%2$s()\n" + indent + "    {\n" + indent + "        %2$s_.wrap(buffer_, offset_ + %3$d, actingVersion_, bufferLength_);\n" + indent + "        return %2$s_;\n" + indent + "    }\n", bitsetName, propertyName, offset));
        return sb;
    }

    private Object generateCompositeProperty(String propertyName, Token token, String indent) {
        String compositeName = Cpp98Util.formatClassName(token.name());
        Integer offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\nprivate:\n" + indent + "    %1$s %2$s_;\n\n" + "public:\n", compositeName, propertyName));
        sb.append(String.format("\n" + indent + "    %1$s &%2$s(void)\n" + indent + "    {\n" + indent + "        %2$s_.wrap(buffer_, offset_ + %3$d, actingVersion_, bufferLength_);\n" + indent + "        return %2$s_;\n" + indent + "    }\n", compositeName, propertyName, offset));
        return sb;
    }

    private CharSequence generateLiteral(PrimitiveType type, String value) {
        String literal = BASE_INDENT;
        String castType = Cpp98Util.cpp98TypeName(type);
        switch (type) {
            case CHAR: 
            case UINT8: 
            case UINT16: 
            case INT8: 
            case INT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case UINT32: 
            case INT32: {
                literal = value;
                break;
            }
            case FLOAT: {
                if (value.endsWith("NaN")) {
                    literal = "SBE_FLOAT_NAN";
                    break;
                }
                literal = value + "f";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "SBE_DOUBLE_NAN" : value;
            }
        }
        return literal;
    }
}

