/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.cpp98;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;

public class Cpp98Util {
    private static Map<PrimitiveType, String> typeNameByPrimitiveTypeMap = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String cpp98TypeName(PrimitiveType primitiveType) {
        return typeNameByPrimitiveTypeMap.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String toLowerFirstChar(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String formatPropertyName(String str) {
        return Cpp98Util.toLowerFirstChar(str);
    }

    public static String formatClassName(String str) {
        return Cpp98Util.toUpperFirstChar(str);
    }

    public static String formatByteOrderEncoding(ByteOrder byteOrder, PrimitiveType primitiveType) {
        switch (primitiveType.size()) {
            case 2: {
                return "SBE_" + byteOrder + "_ENCODE_16";
            }
            case 4: {
                return "SBE_" + byteOrder + "_ENCODE_32";
            }
            case 8: {
                return "SBE_" + byteOrder + "_ENCODE_64";
            }
        }
        return "";
    }

    static {
        typeNameByPrimitiveTypeMap.put(PrimitiveType.CHAR, "sbe_char_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT8, "sbe_int8_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT16, "sbe_int16_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT32, "sbe_int32_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT64, "sbe_int64_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT8, "sbe_uint8_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT16, "sbe_uint16_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT32, "sbe_uint32_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT64, "sbe_uint64_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.FLOAT, "sbe_float_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.DOUBLE, "sbe_double_t");
    }
}

