/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.csharp;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.OutputManager;
import uk.co.real_logic.sbe.generation.csharp.CSharpUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.util.Verify;

public class CSharpGenerator
implements CodeGenerator {
    private static final String META_ATTRIBUTE_ENUM = "MetaAttribute";
    private static final String BASE_INDENT = "";
    private static final String INDENT = "    ";
    private final Ir ir;
    private final OutputManager outputManager;

    public CSharpGenerator(Ir ir, OutputManager outputManager) throws IOException {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    public void generateMessageHeaderStub() throws IOException {
        try (Writer out = this.outputManager.createOutput("MessageHeader");){
            List<Token> tokens = this.ir.headerStructure().tokens();
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(this.generateClassDeclaration("MessageHeader"));
            out.append(this.generateFixedFlyweightCode(tokens.get(0).size()));
            out.append(this.generatePrimitivePropertyEncodings(tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append("    }\n");
            out.append("}\n");
        }
    }

    public void generateTypeStubs() throws IOException {
        this.generateMetaAttributeEnum();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateBitSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                }
            }
        }
    }

    @Override
    public void generate() throws IOException {
        this.generateMessageHeaderStub();
        this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String className = CSharpUtil.formatClassName(msgToken.name());
            Writer out = this.outputManager.createOutput(className);
            Throwable throwable = null;
            try {
                out.append(this.generateFileHeader(this.ir.applicableNamespace()));
                out.append(this.generateClassDeclaration(className));
                out.append(this.generateMessageFlyweightCode(className, msgToken));
                List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
                int offset = 0;
                ArrayList<Token> rootFields = new ArrayList<Token>();
                offset = this.collectRootFields(messageBody, offset, rootFields);
                out.append(this.generateFields(rootFields, BASE_INDENT));
                ArrayList<Token> groups = new ArrayList<Token>();
                offset = this.collectGroups(messageBody, offset, groups);
                StringBuilder sb = new StringBuilder();
                this.generateGroups(sb, className, groups, 0, BASE_INDENT);
                out.append(sb);
                List<Token> varData = messageBody.subList(offset, messageBody.size());
                out.append(this.generateVarData(varData));
                out.append("    }\n");
                out.append("}\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private int collectRootFields(List<Token> tokens, int index, List<Token> rootFields) {
        int size = tokens.size();
        while (index < size) {
            Token token = tokens.get(index);
            if (Signal.BEGIN_GROUP == token.signal() || Signal.END_GROUP == token.signal() || Signal.BEGIN_VAR_DATA == token.signal()) {
                return index;
            }
            rootFields.add(token);
            ++index;
        }
        return index;
    }

    private int collectGroups(List<Token> tokens, int index, List<Token> groups) {
        int size = tokens.size();
        while (index < size) {
            Token token = tokens.get(index);
            if (Signal.BEGIN_VAR_DATA == token.signal()) {
                return index;
            }
            groups.add(token);
            ++index;
        }
        return index;
    }

    private int generateGroups(StringBuilder sb, String parentMessageClassName, List<Token> tokens, int index, String indent) {
        int size = tokens.size();
        while (index < size) {
            if (tokens.get(index).signal() == Signal.BEGIN_GROUP) {
                Token groupToken = tokens.get(index);
                String groupName = groupToken.name();
                sb.append(this.generateGroupProperty(groupName, groupToken, indent));
                this.generateGroupClassHeader(sb, groupName, parentMessageClassName, tokens, index, indent + INDENT);
                ArrayList<Token> rootFields = new ArrayList<Token>();
                ++index;
                index = this.collectRootFields(tokens, index, rootFields);
                sb.append(this.generateFields(rootFields, indent + INDENT));
                if (tokens.get(index).signal() == Signal.BEGIN_GROUP) {
                    index = this.generateGroups(sb, parentMessageClassName, tokens, index, indent + INDENT);
                }
                sb.append(indent).append("    }\n");
            }
            ++index;
        }
        return index;
    }

    private void generateGroupClassHeader(StringBuilder sb, String groupName, String parentMessageClassName, List<Token> tokens, int index, String indent) {
        String dimensionsClassName = CSharpUtil.formatClassName(tokens.get(index + 1).name());
        Integer dimensionHeaderSize = tokens.get(index + 1).size();
        sb.append(String.format("\n" + indent + "public sealed partial class %1$sGroup\n" + indent + "{\n" + indent + "    private readonly %2$s _dimensions = new %2$s();\n" + indent + "    private %3$s _parentMessage;\n" + indent + "    private DirectBuffer _buffer;\n" + indent + "    private int _blockLength;\n" + indent + "    private int _actingVersion;\n" + indent + "    private int _count;\n" + indent + "    private int _index;\n" + indent + "    private int _offset;\n\n", CSharpUtil.formatClassName(groupName), dimensionsClassName, parentMessageClassName));
        sb.append(String.format(indent + "    public void WrapForDecode(%s parentMessage, DirectBuffer buffer, int actingVersion)\n" + indent + "    {\n" + indent + "        _parentMessage = parentMessage;\n" + indent + "        _buffer = buffer;\n" + indent + "        _dimensions.Wrap(buffer, parentMessage.Limit, actingVersion);\n" + indent + "        _blockLength = _dimensions.BlockLength;\n" + indent + "        _count = _dimensions.NumInGroup;\n" + indent + "        _actingVersion = actingVersion;\n" + indent + "        _index = -1;\n" + indent + "        _parentMessage.Limit = parentMessage.Limit + SbeHeaderSize;\n" + indent + "    }\n\n", parentMessageClassName));
        Integer blockLength = tokens.get(index).size();
        String typeForBlockLength = CSharpUtil.cSharpTypeName(tokens.get(index + 2).encoding().primitiveType());
        String typeForNumInGroup = CSharpUtil.cSharpTypeName(tokens.get(index + 3).encoding().primitiveType());
        sb.append(String.format(indent + "    public void WrapForEncode(%1$s parentMessage, DirectBuffer buffer, int count)\n" + indent + "    {\n" + indent + "        _parentMessage = parentMessage;\n" + indent + "        _buffer = buffer;\n" + indent + "        _dimensions.Wrap(buffer, parentMessage.Limit, _actingVersion);\n" + indent + "        _dimensions.BlockLength = (%2$s)%3$d;\n" + indent + "        _dimensions.NumInGroup = (%4$s)count;\n" + indent + "        _index = -1;\n" + indent + "        _count = count;\n" + indent + "        _blockLength = %3$d;\n" + indent + "        parentMessage.Limit = parentMessage.Limit + SbeHeaderSize;\n" + indent + "    }\n\n", parentMessageClassName, typeForBlockLength, blockLength, typeForNumInGroup));
        sb.append(String.format(indent + "    public const int SbeBlockLength = %d;\n" + indent + "    public const int SbeHeaderSize = %d;\n", blockLength, dimensionHeaderSize));
        sb.append(String.format(indent + "    public int ActingBlockLength { get { return _blockLength; } }\n\n" + indent + "    public int Count { get { return _count; } }\n\n" + indent + "    public bool HasNext { get { return (_index + 1) < _count; } }\n\n", new Object[0]));
        sb.append(String.format(indent + "    public %sGroup Next()\n" + indent + "    {\n" + indent + "        if (_index + 1 >= _count)\n" + indent + "        {\n" + indent + "            throw new InvalidOperationException();\n" + indent + "        }\n\n" + indent + "        _offset = _parentMessage.Limit;\n" + indent + "        _parentMessage.Limit = _offset + _blockLength;\n" + indent + "        ++_index;\n\n" + indent + "        return this;\n" + indent + "    }\n", CSharpUtil.formatClassName(groupName)));
    }

    private CharSequence generateGroupProperty(String groupName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String className = CSharpUtil.formatClassName(groupName);
        sb.append(String.format("\n" + indent + "    private readonly %sGroup _%s = new %sGroup();\n", className, CSharpUtil.toLowerFirstChar(groupName), className));
        sb.append(String.format("\n" + indent + "    public const long %sId = %d;\n\n", CSharpUtil.toUpperFirstChar(groupName), token.id()));
        sb.append(String.format("\n" + indent + "    public %1$sGroup %2$s\n" + indent + "    {\n" + indent + "        get\n" + indent + "        {\n" + indent + "            _%3$s.WrapForDecode(_parentMessage, _buffer, _actingVersion);\n" + indent + "            return _%3$s;\n" + indent + "        }\n" + indent + "    }\n", className, CSharpUtil.toUpperFirstChar(groupName), CSharpUtil.toLowerFirstChar(groupName)));
        sb.append(String.format("\n" + indent + "    public %1$sGroup %2$sCount(int count)\n" + indent + "    {\n" + indent + "        _%3$s.WrapForEncode(_parentMessage, _buffer, count);\n" + indent + "        return _%3$s;\n" + indent + "    }\n", className, CSharpUtil.toUpperFirstChar(groupName), CSharpUtil.toLowerFirstChar(groupName)));
        return sb;
    }

    private CharSequence generateVarData(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            this.generateFieldIdMethod(sb, token, BASE_INDENT);
            String characterEncoding = tokens.get(i + 3).encoding().characterEncoding();
            this.generateCharacterEncodingMethod(sb, token.name(), characterEncoding);
            this.generateFieldMetaAttributeMethod(sb, token, BASE_INDENT);
            String propertyName = CSharpUtil.toUpperFirstChar(token.name());
            Token lengthToken = tokens.get(i + 2);
            Integer sizeOfLengthField = lengthToken.size();
            Encoding lengthEncoding = lengthToken.encoding();
            String lengthCsharpType = CSharpUtil.cSharpTypeName(lengthEncoding.primitiveType());
            String lengthTypePrefix = CSharpUtil.toUpperFirstChar(lengthEncoding.primitiveType().primitiveName());
            ByteOrder byteOrder = lengthEncoding.byteOrder();
            String byteOrderStr = this.generateByteOrder(byteOrder, lengthEncoding.primitiveType().size());
            sb.append(String.format("\n    public const int %sHeaderSize = %d;\n", propertyName, sizeOfLengthField));
            sb.append(String.format("\n    public int Get%1$s(byte[] dst, int dstOffset, int length)\n    {\n%2$s        const int sizeOfLengthField = %3$d;\n        int limit = Limit;\n        _buffer.CheckLimit(limit + sizeOfLengthField);\n        int dataLength = _buffer.%4$sGet%5$s(limit);\n        int bytesCopied = Math.Min(length, dataLength);\n        Limit = limit + sizeOfLengthField + dataLength;\n        _buffer.GetBytes(limit + sizeOfLengthField, dst, dstOffset, bytesCopied);\n\n        return bytesCopied;\n    }\n\n", propertyName, this.generateArrayFieldNotPresentCondition(token.version(), BASE_INDENT), sizeOfLengthField, lengthTypePrefix, byteOrderStr));
            sb.append(String.format("    public int Set%1$s(byte[] src, int srcOffset, int length)\n    {\n        const int sizeOfLengthField = %2$d;\n        int limit = Limit;\n        Limit = limit + sizeOfLengthField + length;\n        _buffer.%3$sPut%5$s(limit, (%4$s)length);\n        _buffer.SetBytes(limit + sizeOfLengthField, src, srcOffset, length);\n\n        return length;\n    }\n", propertyName, sizeOfLengthField, lengthTypePrefix, lengthCsharpType, byteOrderStr));
        }
        return sb;
    }

    private void generateBitSet(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = CSharpUtil.formatClassName(enumToken.name());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            String enumPrimitiveType = CSharpUtil.cSharpTypeName(enumToken.encoding().primitiveType());
            out.append(this.generateEnumDeclaration(enumName, enumPrimitiveType, true));
            out.append(this.generateChoices(tokens.subList(1, tokens.size() - 1)));
            out.append(INDENT).append("}\n");
            out.append("}\n");
        }
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = CSharpUtil.formatClassName(enumToken.name());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            String enumPrimitiveType = CSharpUtil.cSharpTypeName(enumToken.encoding().primitiveType());
            out.append(this.generateEnumDeclaration(enumName, enumPrimitiveType, false));
            out.append(this.generateEnumValues(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append(INDENT).append("}\n");
            out.append("}\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String compositeName = CSharpUtil.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(compositeName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(this.generateClassDeclaration(compositeName));
            out.append(this.generateFixedFlyweightCode(tokens.get(0).size()));
            out.append(this.generatePrimitivePropertyEncodings(tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append("    }\n");
            out.append("}\n");
        }
    }

    private CharSequence generateChoices(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String choiceName = CSharpUtil.toUpperFirstChar(token.name());
            String choiceBitPosition = token.encoding().constValue().toString();
            int choiceValue = (int)Math.pow(2.0, Integer.parseInt(choiceBitPosition));
            sb.append(String.format("        %s = %s,\n", choiceName, choiceValue));
        }
        return sb;
    }

    private CharSequence generateEnumValues(List<Token> tokens, Token encodingToken) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = encodingToken.encoding();
        for (Token token : tokens) {
            sb.append(INDENT).append(INDENT).append(token.name()).append(" = ").append(token.encoding().constValue()).append(",\n");
        }
        PrimitiveValue nullVal = encoding.applicableNullValue();
        sb.append(INDENT).append(INDENT).append("NULL_VALUE = ").append(nullVal).append("\n");
        return sb;
    }

    private CharSequence generateFileHeader(String packageName) {
        String[] tokens = packageName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String t : tokens) {
            sb.append(CSharpUtil.toUpperFirstChar(t)).append(".");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return String.format("/* Generated SBE (Simple Binary Encoding) message codec */\n\n#pragma warning disable 1591 // disable warning on missing comments\nusing System;\nusing Adaptive.SimpleBinaryEncoding;\n\nnamespace %s\n{\n", sb);
    }

    private CharSequence generateClassDeclaration(String className) {
        return String.format("    public sealed partial class %s\n    {\n", className);
    }

    private void generateMetaAttributeEnum() throws IOException {
        try (Writer out = this.outputManager.createOutput(META_ATTRIBUTE_ENUM);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(String.format("    public enum MetaAttribute\n    {\n        Epoch,\n        TimeUnit,\n        SemanticType\n    }\n}\n", new Object[0]));
        }
    }

    private CharSequence generateEnumDeclaration(String name, String primitiveType, boolean addFlagsAttribute) {
        String result = BASE_INDENT;
        if (addFlagsAttribute) {
            result = result + "    [Flags]\n";
        }
        result = result + "    public enum " + name + " : " + primitiveType + "\n" + "    {\n";
        return result;
    }

    private CharSequence generatePrimitivePropertyEncodings(List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (token.signal() != Signal.ENCODING) continue;
            sb.append(this.generatePrimitiveProperty(token.name(), token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitiveProperty(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatePrimitiveFieldMetaData(propertyName, token, indent));
        if (Encoding.Presence.CONSTANT == token.encoding().presence()) {
            sb.append(this.generateConstPropertyMethods(propertyName, token, indent));
        } else {
            sb.append(this.generatePrimitivePropertyMethods(propertyName, token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitivePropertyMethods(String propertyName, Token token, String indent) {
        int arrayLength = token.arrayLength();
        if (arrayLength == 1) {
            return this.generateSingleValueProperty(propertyName, token, indent);
        }
        if (arrayLength > 1) {
            return this.generateArrayProperty(propertyName, token, indent);
        }
        return BASE_INDENT;
    }

    private CharSequence generatePrimitiveFieldMetaData(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        PrimitiveType primitiveType = token.encoding().primitiveType();
        String typeName = CSharpUtil.cSharpTypeName(primitiveType);
        sb.append(String.format("\n" + indent + "    public const %s %sNullValue = %s;\n", typeName, CSharpUtil.toUpperFirstChar(propertyName), this.generateLiteral(primitiveType, token.encoding().applicableNullValue().toString())));
        sb.append(String.format("\n" + indent + "    public const %s %sMinValue = %s;\n", typeName, CSharpUtil.toUpperFirstChar(propertyName), this.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString())));
        sb.append(String.format("\n" + indent + "    public const %s %sMaxValue = %s;\n", typeName, CSharpUtil.toUpperFirstChar(propertyName), this.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString())));
        return sb;
    }

    private CharSequence generateSingleValueProperty(String propertyName, Token token, String indent) {
        String typeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        String typePrefix = CSharpUtil.toUpperFirstChar(token.encoding().primitiveType().primitiveName());
        Integer offset = token.offset();
        ByteOrder byteOrder = token.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, token.encoding().primitiveType().size());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    public %1$s %2$s\n" + indent + "    {\n" + indent + "        get\n" + indent + "        {\n" + "%3$s" + indent + "            return _buffer.%4$sGet%6$s(_offset + %5$d);\n" + indent + "        }\n" + indent + "        set\n" + indent + "        {\n" + indent + "            _buffer.%4$sPut%6$s(_offset + %5$d, value);\n" + indent + "        }\n" + indent + "    }\n\n", typeName, CSharpUtil.toUpperFirstChar(propertyName), this.generateFieldNotPresentCondition(token.version(), token.encoding(), indent), typePrefix, offset, byteOrderStr));
        return sb;
    }

    private CharSequence generateFieldNotPresentCondition(int sinceVersion, Encoding encoding, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (_actingVersion < %1$d) return %2$s;\n\n", sinceVersion, sinceVersion > 0 ? this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()) : "(byte)0");
    }

    private CharSequence generateArrayFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d) return 0;\n\n", sinceVersion);
    }

    private CharSequence generateTypeFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d) return null;\n\n", sinceVersion);
    }

    private CharSequence generateArrayProperty(String propertyName, Token token, String indent) {
        String typeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        String typePrefix = CSharpUtil.toUpperFirstChar(token.encoding().primitiveType().primitiveName());
        Integer offset = token.offset();
        ByteOrder byteOrder = token.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, token.encoding().primitiveType().size());
        Integer fieldLength = token.arrayLength();
        Integer typeSize = token.encoding().primitiveType().size();
        String propName = CSharpUtil.toUpperFirstChar(propertyName);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    public const int %sLength  = %d;\n\n", propName, fieldLength));
        sb.append(String.format(indent + "    public %1$s Get%2$s(int index)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %3$d)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfRangeException(\"index out of range: index=\" + index);\n" + indent + "        }\n\n" + "%4$s" + indent + "        return _buffer.%5$sGet%8$s(_offset + %6$d + (index * %7$d));\n" + indent + "    }\n\n", typeName, propName, fieldLength, this.generateFieldNotPresentCondition(token.version(), token.encoding(), indent), typePrefix, offset, typeSize, byteOrderStr));
        sb.append(String.format(indent + "    public void Set%1$s(int index, %2$s value)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %3$d)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfRangeException(\"index out of range: index=\" + index);\n" + indent + "        }\n\n" + indent + "        _buffer.%4$sPut%7$s(_offset + %5$d + (index * %6$d), value);\n" + indent + "    }\n", propName, typeName, fieldLength, typePrefix, offset, typeSize, byteOrderStr));
        if (token.encoding().primitiveType() == PrimitiveType.CHAR) {
            this.generateCharacterEncodingMethod(sb, propertyName, token.encoding().characterEncoding());
            sb.append(String.format(indent + "    public int Get%1$s(byte[] dst, int dstOffset)\n" + indent + "    {\n" + indent + "        const int length = %2$d;\n" + indent + "        if (dstOffset < 0 || dstOffset > (dst.Length - length))\n" + indent + "        {\n" + indent + "            throw new IndexOutOfRangeException(\"dstOffset out of range for copy: offset=\" + dstOffset);\n" + indent + "        }\n\n" + "%3$s" + indent + "        _buffer.GetBytes(_offset + %4$d, dst, dstOffset, length);\n" + indent + "        return length;\n" + indent + "    }\n\n", propName, fieldLength, this.generateArrayFieldNotPresentCondition(token.version(), indent), offset));
            sb.append(String.format(indent + "    public void Set%1$s(byte[] src, int srcOffset)\n" + indent + "    {\n" + indent + "        const int length = %2$d;\n" + indent + "        if (srcOffset < 0 || srcOffset > (src.Length - length))\n" + indent + "        {\n" + indent + "            throw new IndexOutOfRangeException(\"srcOffset out of range for copy: offset=\" + srcOffset);\n" + indent + "        }\n\n" + indent + "        _buffer.SetBytes(_offset + %3$d, src, srcOffset, length);\n" + indent + "    }\n", propName, fieldLength, offset));
        }
        return sb;
    }

    private void generateCharacterEncodingMethod(StringBuilder sb, String propertyName, String encoding) {
        sb.append(String.format("\n    public const string %sCharacterEncoding = \"%s\";\n\n", CSharpUtil.formatPropertyName(propertyName), encoding));
    }

    private CharSequence generateConstPropertyMethods(String propertyName, Token token, String indent) {
        if (token.encoding().primitiveType() != PrimitiveType.CHAR) {
            return String.format("\n" + indent + "    public %1$s %2$s { get { return %3$s; } }\n", CSharpUtil.cSharpTypeName(token.encoding().primitiveType()), CSharpUtil.toUpperFirstChar(propertyName), this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString()));
        }
        StringBuilder sb = new StringBuilder();
        String javaTypeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        byte[] constantValue = token.encoding().constValue().byteArrayValue(token.encoding().primitiveType());
        CharSequence values = this.generateByteLiteralList(token.encoding().constValue().byteArrayValue(token.encoding().primitiveType()));
        sb.append(String.format("\n" + indent + "    private static readonly byte[] _%1$sValue = {%2$s};\n", propertyName, values));
        sb.append(String.format("\n" + indent + "    public const int %1$sLength = %2$d;\n", CSharpUtil.toUpperFirstChar(propertyName), constantValue.length));
        sb.append(String.format(indent + "    public %1$s %2$s(int index)\n" + indent + "    {\n" + indent + "        return _%3$sValue[index];\n" + indent + "    }\n\n", javaTypeName, CSharpUtil.toUpperFirstChar(propertyName), propertyName));
        sb.append(String.format(indent + "    public int Get%1$s(byte[] dst, int offset, int length)\n" + indent + "    {\n" + indent + "        int bytesCopied = Math.Min(length, %2$d);\n" + indent + "        Array.Copy(_%3$sValue, 0, dst, offset, bytesCopied);\n" + indent + "        return bytesCopied;\n" + indent + "    }\n", CSharpUtil.toUpperFirstChar(propertyName), constantValue.length, propertyName));
        return sb;
    }

    private CharSequence generateByteLiteralList(byte[] bytes) {
        StringBuilder values = new StringBuilder();
        for (byte b : bytes) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        return values;
    }

    private CharSequence generateFixedFlyweightCode(int size) {
        return String.format("        private DirectBuffer _buffer;\n        private int _offset;\n        private int _actingVersion;\n\n        public void Wrap(DirectBuffer buffer, int offset, int actingVersion)\n        {\n            _offset = offset;\n            _actingVersion = actingVersion;\n            _buffer = buffer;\n        }\n\n        public const int Size = %d;\n", size);
    }

    private CharSequence generateMessageFlyweightCode(String className, Token token) {
        String blockLengthType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().blockLengthType());
        String templateIdType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().templateIdType());
        String schemaIdType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().schemaVersionType());
        String semanticType = token.encoding().semanticType() == null ? BASE_INDENT : token.encoding().semanticType();
        return String.format("    public const %1$s BlockLength = %2$s;\n    public const %3$s TemplateId = %4$s;\n    public const %5$s SchemaId = %6$s;\n    public const %7$s Schema_Version = %8$s;\n    public const string SematicType = \"%9$s\";\n\n    private readonly %10$s _parentMessage;\n    private DirectBuffer _buffer;\n    private int _offset;\n    private int _limit;\n    private int _actingBlockLength;\n    private int _actingVersion;\n\n    public int Offset { get { return _offset; } }\n\n    public %10$s()\n    {\n        _parentMessage = this;\n    }\n\n    public void WrapForEncode(DirectBuffer buffer, int offset)\n    {\n        _buffer = buffer;\n        _offset = offset;\n        _actingBlockLength = BlockLength;\n        _actingVersion = Schema_Version;\n        Limit = offset + _actingBlockLength;\n    }\n\n    public void WrapForDecode(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion)\n    {\n        _buffer = buffer;\n        _offset = offset;\n        _actingBlockLength = actingBlockLength;\n        _actingVersion = actingVersion;\n        Limit = offset + _actingBlockLength;\n    }\n\n    public int Size\n    {\n        get\n        {\n            return _limit - _offset;\n        }\n    }\n\n    public int Limit\n    {\n        get\n        {\n            return _limit;\n        }\n        set\n        {\n            _buffer.CheckLimit(value);\n            _limit = value;\n        }\n    }\n\n", blockLengthType, this.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.size())), templateIdType, this.generateLiteral(this.ir.headerStructure().templateIdType(), Integer.toString(token.id())), schemaIdType, this.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(token.version())), semanticType, className);
    }

    private CharSequence generateFields(List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = signalToken.name();
            this.generateFieldIdMethod(sb, signalToken, indent);
            this.generateFieldMetaAttributeMethod(sb, signalToken, indent);
            switch (encodingToken.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitSetProperty(propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, encodingToken, indent));
                }
            }
        }
        return sb;
    }

    private void generateFieldIdMethod(StringBuilder sb, Token token, String indent) {
        sb.append(String.format("\n" + indent + "    public const int %sId = %d;\n", CSharpUtil.formatPropertyName(token.name()), token.id()));
    }

    private void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? BASE_INDENT : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? BASE_INDENT : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? BASE_INDENT : encoding.semanticType();
        sb.append(String.format("\n" + indent + "    public static string %sMetaAttribute(MetaAttribute metaAttribute)\n" + indent + "    {\n" + indent + "        switch (metaAttribute)\n" + indent + "        {\n" + indent + "            case MetaAttribute.Epoch: return \"%s\";\n" + indent + "            case MetaAttribute.TimeUnit: return \"%s\";\n" + indent + "            case MetaAttribute.SemanticType: return \"%s\";\n" + indent + "        }\n\n" + indent + "        return \"\";\n" + indent + "    }\n", CSharpUtil.toUpperFirstChar(token.name()), epoch, timeUnit, semanticType));
    }

    private CharSequence generateEnumFieldNotPresentCondition(int sinceVersion, String enumName, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (_actingVersion < %d) return %s.NULL_VALUE;\n\n", sinceVersion, enumName);
    }

    private CharSequence generateEnumProperty(String propertyName, Token token, String indent) {
        String enumName = CSharpUtil.formatClassName(token.name());
        String typePrefix = CSharpUtil.toUpperFirstChar(token.encoding().primitiveType().primitiveName());
        String enumUnderlyingType = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        Integer offset = token.offset();
        ByteOrder byteOrder = token.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, token.encoding().primitiveType().size());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    public %1$s %2$s\n" + indent + "    {\n" + indent + "        get\n" + indent + "        {\n" + "%3$s" + indent + "            return (%4$s)_buffer.%5$sGet%7$s(_offset + %6$d);\n" + indent + "        }\n" + indent + "        set\n" + indent + "        {\n" + indent + "            _buffer.%5$sPut%7$s(_offset + %6$d, (%8$s)value);\n" + indent + "        }\n" + indent + "    }\n\n", enumName, CSharpUtil.toUpperFirstChar(propertyName), this.generateEnumFieldNotPresentCondition(token.version(), enumName, indent), enumName, typePrefix, offset, byteOrderStr, enumUnderlyingType));
        return sb;
    }

    private Object generateBitSetProperty(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String bitSetName = CSharpUtil.formatClassName(token.name());
        Integer offset = token.offset();
        String typePrefix = CSharpUtil.toUpperFirstChar(token.encoding().primitiveType().primitiveName());
        ByteOrder byteOrder = token.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, token.encoding().primitiveType().size());
        String typeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        sb.append(String.format("\n" + indent + "    public %1$s %2$s\n" + indent + "    {\n" + indent + "        get\n" + indent + "        {\n" + "%3$s" + indent + "            return (%4$s)_buffer.%5$sGet%7$s(_offset + %6$d);\n" + indent + "        }\n" + indent + "        set\n" + indent + "        {\n" + indent + "            _buffer.%5$sPut%7$s(_offset + %6$d, (%8$s)value);\n" + indent + "        }\n" + indent + "    }\n", bitSetName, CSharpUtil.toUpperFirstChar(propertyName), this.generateTypeFieldNotPresentCondition(token.version(), indent), bitSetName, typePrefix, offset, byteOrderStr, typeName));
        return sb;
    }

    private Object generateCompositeProperty(String propertyName, Token token, String indent) {
        String compositeName = CSharpUtil.formatClassName(token.name());
        Integer offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    private readonly %1$s _%2$s = new %3$s();\n", compositeName, CSharpUtil.toLowerFirstChar(propertyName), compositeName));
        sb.append(String.format("\n" + indent + "    public %1$s %2$s\n" + indent + "    {\n" + indent + "        get\n" + indent + "        {\n" + "%3$s" + indent + "            _%4$s.Wrap(_buffer, _offset + %5$d, _actingVersion);\n" + indent + "            return _%4$s;\n" + indent + "        }\n" + indent + "    }\n", compositeName, CSharpUtil.toUpperFirstChar(propertyName), this.generateTypeFieldNotPresentCondition(token.version(), indent), CSharpUtil.toLowerFirstChar(propertyName), offset));
        return sb;
    }

    private String generateByteOrder(ByteOrder byteOrder, int primitiveTypeSize) {
        if (primitiveTypeSize == 1) {
            return BASE_INDENT;
        }
        switch (byteOrder.toString()) {
            case "BIG_ENDIAN": {
                return "BigEndian";
            }
        }
        return "LittleEndian";
    }

    private String generateLiteral(PrimitiveType type, String value) {
        String literal = BASE_INDENT;
        String castType = CSharpUtil.cSharpTypeName(type);
        switch (type) {
            case CHAR: 
            case UINT8: 
            case INT8: 
            case INT16: 
            case UINT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case INT32: {
                literal = value;
                break;
            }
            case UINT32: {
                literal = value + "U";
                break;
            }
            case FLOAT: {
                if (value.endsWith("NaN")) {
                    literal = "float.NaN";
                    break;
                }
                literal = value + "f";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "UL";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "double.NaN" : value + "d";
            }
        }
        return literal;
    }
}

