/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.csharp;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import uk.co.real_logic.sbe.generation.OutputManager;
import uk.co.real_logic.sbe.util.Verify;

public class CSharpNamespaceOutputManager
implements OutputManager {
    private final File outputDir;

    public CSharpNamespaceOutputManager(String baseDirectoryName, String packageName) throws IOException {
        Verify.notNull(baseDirectoryName, "baseDirectoryName");
        Verify.notNull(packageName, "packageName");
        this.outputDir = new File(baseDirectoryName);
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + baseDirectoryName);
        }
    }

    @Override
    public Writer createOutput(String name) throws IOException {
        File targetFile = new File(this.outputDir, name + ".cs");
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8"));
    }
}

