/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.java;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.OutputManager;
import uk.co.real_logic.sbe.generation.java.JavaUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.util.Verify;

public class JavaGenerator
implements CodeGenerator {
    private static final String META_ATTRIBUTE_ENUM = "MetaAttribute";
    private static final String BASE_INDENT = "";
    private static final String INDENT = "    ";
    private final Ir ir;
    private final OutputManager outputManager;

    public JavaGenerator(Ir ir, OutputManager outputManager) throws IOException {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    public void generateMessageHeaderStub() throws IOException {
        try (Writer out = this.outputManager.createOutput("MessageHeader");){
            List<Token> tokens = this.ir.headerStructure().tokens();
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(this.generateClassDeclaration("MessageHeader"));
            out.append(this.generateFixedFlyweightCode("MessageHeader", tokens.get(0).size()));
            out.append(this.generatePrimitivePropertyEncodings("MessageHeader", tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append("}\n");
        }
    }

    public void generateTypeStubs() throws IOException {
        this.generateMetaAttributeEnum();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateBitSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                }
            }
        }
    }

    @Override
    public void generate() throws IOException {
        this.generateMessageHeaderStub();
        this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String className = JavaUtil.formatClassName(msgToken.name());
            Writer out = this.outputManager.createOutput(className);
            Throwable throwable = null;
            try {
                out.append(this.generateFileHeader(this.ir.applicableNamespace()));
                out.append(this.generateClassDeclaration(className));
                out.append(this.generateMessageFlyweightCode(className, msgToken));
                List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
                int offset = 0;
                ArrayList<Token> rootFields = new ArrayList<Token>();
                offset = this.collectRootFields(messageBody, offset, rootFields);
                out.append(this.generateFields(className, rootFields, BASE_INDENT));
                ArrayList<Token> groups = new ArrayList<Token>();
                offset = this.collectGroups(messageBody, offset, groups);
                StringBuilder sb = new StringBuilder();
                this.generateGroups(sb, className, groups, 0, BASE_INDENT);
                out.append(sb);
                List<Token> varData = messageBody.subList(offset, messageBody.size());
                out.append(this.generateVarData(varData));
                out.append("}\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private int collectRootFields(List<Token> tokens, int index, List<Token> rootFields) {
        int size = tokens.size();
        while (index < size) {
            Token token = tokens.get(index);
            if (Signal.BEGIN_GROUP == token.signal() || Signal.END_GROUP == token.signal() || Signal.BEGIN_VAR_DATA == token.signal()) {
                return index;
            }
            rootFields.add(token);
            ++index;
        }
        return index;
    }

    private int collectGroups(List<Token> tokens, int index, List<Token> groups) {
        int size = tokens.size();
        while (index < size) {
            Token token = tokens.get(index);
            if (Signal.BEGIN_VAR_DATA == token.signal()) {
                return index;
            }
            groups.add(token);
            ++index;
        }
        return index;
    }

    private int generateGroups(StringBuilder sb, String parentMessageClassName, List<Token> tokens, int index, String indent) {
        int size = tokens.size();
        while (index < size) {
            if (tokens.get(index).signal() == Signal.BEGIN_GROUP) {
                Token groupToken = tokens.get(index);
                String groupName = groupToken.name();
                sb.append(this.generateGroupProperty(groupName, groupToken, indent));
                this.generateGroupClassHeader(sb, groupName, parentMessageClassName, tokens, index, indent + INDENT);
                ArrayList<Token> rootFields = new ArrayList<Token>();
                ++index;
                index = this.collectRootFields(tokens, index, rootFields);
                sb.append(this.generateFields(groupName, rootFields, indent + INDENT));
                if (tokens.get(index).signal() == Signal.BEGIN_GROUP) {
                    index = this.generateGroups(sb, parentMessageClassName, tokens, index, indent + INDENT);
                }
                sb.append(indent).append("    }\n");
            }
            ++index;
        }
        return index;
    }

    private void generateGroupClassHeader(StringBuilder sb, String groupName, String parentMessageClassName, List<Token> tokens, int index, String indent) {
        String dimensionsClassName = JavaUtil.formatClassName(tokens.get(index + 1).name());
        Integer dimensionHeaderSize = tokens.get(index + 1).size();
        sb.append(String.format("\n" + indent + "public static class %1$s implements Iterable<%1$s>, java.util.Iterator<%1$s>\n" + indent + "{\n" + indent + "    private static final int HEADER_SIZE = %2$d;\n" + indent + "    private final %3$s dimensions = new %3$s();\n" + indent + "    private %4$s parentMessage;\n" + indent + "    private DirectBuffer buffer;\n" + indent + "    private int blockLength;\n" + indent + "    private int actingVersion;\n" + indent + "    private int count;\n" + indent + "    private int index;\n" + indent + "    private int offset;\n\n", JavaUtil.formatClassName(groupName), dimensionHeaderSize, dimensionsClassName, parentMessageClassName));
        sb.append(String.format(indent + "    public void wrapForDecode(final %s parentMessage, final DirectBuffer buffer, final int actingVersion)\n" + indent + "    {\n" + indent + "        this.parentMessage = parentMessage;\n" + indent + "        this.buffer = buffer;\n" + indent + "        dimensions.wrap(buffer, parentMessage.limit(), actingVersion);\n" + indent + "        blockLength = dimensions.blockLength();\n" + indent + "        count = dimensions.numInGroup();\n" + indent + "        this.actingVersion = actingVersion;\n" + indent + "        index = -1;\n" + indent + "        parentMessage.limit(parentMessage.limit() + HEADER_SIZE);\n" + indent + "    }\n\n", parentMessageClassName));
        Integer blockLength = tokens.get(index).size();
        String javaTypeForBlockLength = JavaUtil.javaTypeName(tokens.get(index + 2).encoding().primitiveType());
        String javaTypeForNumInGroup = JavaUtil.javaTypeName(tokens.get(index + 3).encoding().primitiveType());
        sb.append(String.format(indent + "    public void wrapForEncode(final %1$s parentMessage, final DirectBuffer buffer, final int count)\n" + indent + "    {\n" + indent + "        this.parentMessage = parentMessage;\n" + indent + "        this.buffer = buffer;\n" + indent + "        actingVersion = SCHEMA_VERSION;\n" + indent + "        dimensions.wrap(buffer, parentMessage.limit(), actingVersion);\n" + indent + "        dimensions.blockLength((%2$s)%3$d);\n" + indent + "        dimensions.numInGroup((%4$s)count);\n" + indent + "        index = -1;\n" + indent + "        this.count = count;\n" + indent + "        blockLength = %3$d;\n" + indent + "        parentMessage.limit(parentMessage.limit() + HEADER_SIZE);\n" + indent + "    }\n\n", parentMessageClassName, javaTypeForBlockLength, blockLength, javaTypeForNumInGroup));
        sb.append(String.format(indent + "    public static int sbeHeaderSize()\n" + indent + "    {\n" + indent + "        return HEADER_SIZE;\n" + indent + "    }\n\n", new Object[0]));
        sb.append(String.format(indent + "    public static int sbeBlockLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n\n", blockLength));
        sb.append(String.format(indent + "    public int actingBlockLength()\n" + indent + "    {\n" + indent + "        return blockLength;\n" + indent + "    }\n\n" + indent + "    public int count()\n" + indent + "    {\n" + indent + "        return count;\n" + indent + "    }\n\n" + indent + "    @Override\n" + indent + "    public java.util.Iterator<%s> iterator()\n" + indent + "    {\n" + indent + "        return this;\n" + indent + "    }\n\n" + indent + "    @Override\n" + indent + "    public void remove()\n" + indent + "    {\n" + indent + "        throw new UnsupportedOperationException();\n" + indent + "    }\n\n" + indent + "    @Override\n" + indent + "    public boolean hasNext()\n" + indent + "    {\n" + indent + "        return (index + 1) < count;\n" + indent + "    }\n\n", JavaUtil.formatClassName(groupName)));
        sb.append(String.format(indent + "    @Override\n" + indent + "    public %s next()\n" + indent + "    {\n" + indent + "        if (index + 1 >= count)\n" + indent + "        {\n" + indent + "            throw new java.util.NoSuchElementException();\n" + indent + "        }\n\n" + indent + "        offset = parentMessage.limit();\n" + indent + "        parentMessage.limit(offset + blockLength);\n" + indent + "        ++index;\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(groupName)));
    }

    private CharSequence generateGroupProperty(String groupName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String className = JavaUtil.formatClassName(groupName);
        String propertyName = JavaUtil.formatPropertyName(groupName);
        sb.append(String.format("\n" + indent + "    private final %s %s = new %s();\n", className, propertyName, className));
        sb.append(String.format("\n" + indent + "    public static long %sId()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", groupName, token.id()));
        sb.append(String.format("\n" + indent + "    public %1$s %2$s()\n" + indent + "    {\n" + indent + "        %2$s.wrapForDecode(parentMessage, buffer, actingVersion);\n" + indent + "        return %2$s;\n" + indent + "    }\n", className, propertyName));
        sb.append(String.format("\n" + indent + "    public %1$s %2$sCount(final int count)\n" + indent + "    {\n" + indent + "        %2$s.wrapForEncode(parentMessage, buffer, count);\n" + indent + "        return %2$s;\n" + indent + "    }\n", className, propertyName));
        return sb;
    }

    private CharSequence generateVarData(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            this.generateFieldIdMethod(sb, token, BASE_INDENT);
            String characterEncoding = tokens.get(i + 3).encoding().characterEncoding();
            this.generateCharacterEncodingMethod(sb, token.name(), characterEncoding, BASE_INDENT);
            this.generateFieldMetaAttributeMethod(sb, token, BASE_INDENT);
            String propertyName = JavaUtil.toUpperFirstChar(token.name());
            Token lengthToken = tokens.get(i + 2);
            Integer sizeOfLengthField = lengthToken.size();
            Encoding lengthEncoding = lengthToken.encoding();
            String lengthJavaType = JavaUtil.javaTypeName(lengthEncoding.primitiveType());
            String lengthTypePrefix = lengthEncoding.primitiveType().primitiveName();
            ByteOrder byteOrder = lengthEncoding.byteOrder();
            String byteOrderStr = lengthEncoding.primitiveType().size() == 1 ? BASE_INDENT : ", java.nio.ByteOrder." + byteOrder;
            sb.append(String.format("\n    public static int %sHeaderSize()\n    {\n        return %d;\n    }\n", JavaUtil.toLowerFirstChar(propertyName), sizeOfLengthField));
            sb.append(String.format("\n    public int get%s(final byte[] dst, final int dstOffset, final int length)\n    {\n%s        final int sizeOfLengthField = %d;\n        final int limit = limit();\n        buffer.checkLimit(limit + sizeOfLengthField);\n        final int dataLength = CodecUtil.%sGet(buffer, limit%s);\n        final int bytesCopied = Math.min(length, dataLength);\n        limit(limit + sizeOfLengthField + dataLength);\n        CodecUtil.int8sGet(buffer, limit + sizeOfLengthField, dst, dstOffset, bytesCopied);\n\n        return bytesCopied;\n    }\n", propertyName, this.generateArrayFieldNotPresentCondition(token.version(), BASE_INDENT), sizeOfLengthField, lengthTypePrefix, byteOrderStr));
            sb.append(String.format("\n    public int put%s(final byte[] src, final int srcOffset, final int length)\n    {\n        final int sizeOfLengthField = %d;\n        final int limit = limit();\n        limit(limit + sizeOfLengthField + length);\n        CodecUtil.%sPut(buffer, limit, (%s)length%s);\n        CodecUtil.int8sPut(buffer, limit + sizeOfLengthField, src, srcOffset, length);\n\n        return length;\n    }\n", propertyName, sizeOfLengthField, lengthTypePrefix, lengthJavaType, byteOrderStr));
        }
        return sb;
    }

    private void generateBitSet(List<Token> tokens) throws IOException {
        String bitSetName = JavaUtil.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(bitSetName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(this.generateClassDeclaration(bitSetName));
            out.append(this.generateFixedFlyweightCode(bitSetName, tokens.get(0).size()));
            out.append(this.generateChoiceClear(bitSetName, tokens.get(0)));
            out.append(this.generateChoices(bitSetName, tokens.subList(1, tokens.size() - 1)));
            out.append("}\n");
        }
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        String enumName = JavaUtil.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(this.generateEnumFileHeader(this.ir.applicableNamespace()));
            out.append(this.generateEnumDeclaration(enumName));
            out.append(this.generateEnumValues(tokens.subList(1, tokens.size() - 1)));
            out.append(this.generateEnumBody(tokens.get(0), enumName));
            out.append(this.generateEnumLookupMethod(tokens.subList(1, tokens.size() - 1), enumName));
            out.append("}\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String compositeName = JavaUtil.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(compositeName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(this.generateClassDeclaration(compositeName));
            out.append(this.generateFixedFlyweightCode(compositeName, tokens.get(0).size()));
            out.append(this.generatePrimitivePropertyEncodings(compositeName, tokens.subList(1, tokens.size() - 1), BASE_INDENT));
            out.append("}\n");
        }
    }

    private CharSequence generateChoiceClear(String bitSetClassName, Token token) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = token.encoding();
        String typePrefix = encoding.primitiveType().primitiveName();
        String literalValue = this.generateLiteral(encoding.primitiveType(), "0");
        ByteOrder byteOrder = encoding.byteOrder();
        String byteOrderStr = encoding.primitiveType().size() == 1 ? BASE_INDENT : ", java.nio.ByteOrder." + byteOrder;
        sb.append(String.format("\n    public %s clear()\n    {\n        CodecUtil.%sPut(buffer, offset, %s%s);\n        return this;\n    }\n", bitSetClassName, typePrefix, literalValue, byteOrderStr));
        return sb;
    }

    private CharSequence generateChoices(String bitSetClassName, List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String choiceName = token.name();
            Encoding encoding = token.encoding();
            String typePrefix = encoding.primitiveType().primitiveName();
            String choiceBitPosition = encoding.constValue().toString();
            ByteOrder byteOrder = encoding.byteOrder();
            String byteOrderStr = encoding.primitiveType().size() == 1 ? BASE_INDENT : ", java.nio.ByteOrder." + byteOrder;
            sb.append(String.format("\n    public boolean %s()\n    {\n        return CodecUtil.%sGetChoice(buffer, offset, %s%s);\n    }\n\n    public %s %s(final boolean value)\n    {\n        CodecUtil.%sPutChoice(buffer, offset, %s, value%s);\n        return this;\n    }\n", choiceName, typePrefix, choiceBitPosition, byteOrderStr, bitSetClassName, choiceName, typePrefix, choiceBitPosition, byteOrderStr));
        }
        return sb;
    }

    private CharSequence generateEnumValues(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            Encoding encoding = token.encoding();
            String constVal = this.generateLiteral(encoding.primitiveType(), encoding.constValue().toString());
            sb.append(INDENT).append(token.name()).append('(').append((CharSequence)constVal).append("),\n");
        }
        Token token = tokens.get(0);
        Encoding encoding = token.encoding();
        String nullVal = this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString());
        sb.append(INDENT).append("NULL_VAL").append('(').append((CharSequence)nullVal).append(')');
        sb.append(";\n\n");
        return sb;
    }

    private CharSequence generateEnumBody(Token token, String enumName) {
        String javaEncodingType = JavaUtil.javaTypeName(token.encoding().primitiveType());
        return String.format("    private final %1$s value;\n\n    %2$s(final %1$s value)\n    {\n        this.value = value;\n    }\n\n    public %1$s value()\n    {\n        return value;\n    }\n\n", javaEncodingType, enumName);
    }

    private CharSequence generateEnumLookupMethod(List<Token> tokens, String enumName) {
        StringBuilder sb = new StringBuilder();
        PrimitiveType primitiveType = tokens.get(0).encoding().primitiveType();
        sb.append(String.format("    public static %s get(final %s value)\n    {\n        switch (value)\n        {\n", enumName, JavaUtil.javaTypeName(primitiveType)));
        for (Token token : tokens) {
            sb.append(String.format("            case %s: return %s;\n", token.encoding().constValue().toString(), token.name()));
        }
        sb.append(String.format("        }\n\n        if (%s == value)\n        {\n            return NULL_VAL;\n        }\n\n        throw new IllegalArgumentException(\"Unknown value: \" + value);\n    }\n", this.generateLiteral(primitiveType, tokens.get(0).encoding().applicableNullValue().toString())));
        return sb;
    }

    private CharSequence generateFileHeader(String packageName) {
        return String.format("/* Generated SBE (Simple Binary Encoding) message codec */\npackage %s;\n\nimport uk.co.real_logic.sbe.codec.java.*;\n\n", packageName);
    }

    private CharSequence generateEnumFileHeader(String packageName) {
        return String.format("/* Generated SBE (Simple Binary Encoding) message codec */\npackage %s;\n\n", packageName);
    }

    private CharSequence generateClassDeclaration(String className) {
        return String.format("public class %s\n{\n", className);
    }

    private void generateMetaAttributeEnum() throws IOException {
        try (Writer out = this.outputManager.createOutput(META_ATTRIBUTE_ENUM);){
            out.append(String.format("/* Generated SBE (Simple Binary Encoding) message codec */\npackage %s;\n\npublic enum MetaAttribute\n{\n    EPOCH,\n    TIME_UNIT,\n    SEMANTIC_TYPE\n}\n", this.ir.applicableNamespace()));
        }
    }

    private CharSequence generateEnumDeclaration(String name) {
        return "public enum " + name + "\n{\n";
    }

    private CharSequence generatePrimitivePropertyEncodings(String containingClassName, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (token.signal() != Signal.ENCODING) continue;
            sb.append(this.generatePrimitiveProperty(containingClassName, token.name(), token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitiveProperty(String containingClassName, String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatePrimitiveFieldMetaData(propertyName, token, indent));
        if (Encoding.Presence.CONSTANT == token.encoding().presence()) {
            sb.append(this.generateConstPropertyMethods(propertyName, token, indent));
        } else {
            sb.append(this.generatePrimitivePropertyMethods(containingClassName, propertyName, token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitivePropertyMethods(String containingClassName, String propertyName, Token token, String indent) {
        int arrayLength = token.arrayLength();
        if (arrayLength == 1) {
            return this.generateSingleValueProperty(containingClassName, propertyName, token, indent);
        }
        if (arrayLength > 1) {
            return this.generateArrayProperty(containingClassName, propertyName, token, indent);
        }
        return BASE_INDENT;
    }

    private CharSequence generatePrimitiveFieldMetaData(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        PrimitiveType primitiveType = token.encoding().primitiveType();
        String javaTypeName = JavaUtil.javaTypeName(primitiveType);
        sb.append(String.format("\n" + indent + "    public static %s %sNullValue()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", javaTypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableNullValue().toString())));
        sb.append(String.format("\n" + indent + "    public static %s %sMinValue()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", javaTypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString())));
        sb.append(String.format("\n" + indent + "    public static %s %sMaxValue()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", javaTypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString())));
        return sb;
    }

    private CharSequence generateSingleValueProperty(String containingClassName, String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        String typePrefix = encoding.primitiveType().primitiveName();
        Integer offset = token.offset();
        ByteOrder byteOrder = encoding.byteOrder();
        String byteOrderStr = encoding.primitiveType().size() == 1 ? BASE_INDENT : ", java.nio.ByteOrder." + byteOrder;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + "%s" + indent + "        return CodecUtil.%sGet(buffer, offset + %d%s);\n" + indent + "    }\n\n", javaTypeName, propertyName, this.generateFieldNotPresentCondition(token.version(), encoding, indent), typePrefix, offset, byteOrderStr));
        sb.append(String.format(indent + "    public %s %s(final %s value)\n" + indent + "    {\n" + indent + "        CodecUtil.%sPut(buffer, offset + %d, value%s);\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), propertyName, javaTypeName, typePrefix, offset, byteOrderStr));
        return sb;
    }

    private CharSequence generateFieldNotPresentCondition(int sinceVersion, Encoding encoding, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d)\n" + indent + "        {\n" + indent + "            return %s;\n" + indent + "        }\n\n", sinceVersion, this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()));
    }

    private CharSequence generateArrayFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d)\n" + indent + "        {\n" + indent + "            return 0;\n" + indent + "        }\n\n", sinceVersion);
    }

    private CharSequence generateTypeFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d)\n" + indent + "        {\n" + indent + "            return null;\n" + indent + "        }\n\n", sinceVersion);
    }

    private CharSequence generateArrayProperty(String containingClassName, String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        String typePrefix = encoding.primitiveType().primitiveName();
        Integer offset = token.offset();
        ByteOrder byteOrder = encoding.byteOrder();
        String byteOrderStr = encoding.primitiveType().size() == 1 ? BASE_INDENT : ", java.nio.ByteOrder." + byteOrder;
        Integer fieldLength = token.arrayLength();
        Integer typeSize = encoding.primitiveType().size();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    public static int %sLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n\n", propertyName, fieldLength));
        sb.append(String.format(indent + "    public %s %s(final int index)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %d)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"index out of range: index=\" + index);\n" + indent + "        }\n\n" + "%s" + indent + "        return CodecUtil.%sGet(buffer, this.offset + %d + (index * %d)%s);\n" + indent + "    }\n\n", javaTypeName, propertyName, fieldLength, this.generateFieldNotPresentCondition(token.version(), encoding, indent), typePrefix, offset, typeSize, byteOrderStr));
        sb.append(String.format(indent + "    public void %s(final int index, final %s value)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %d)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"index out of range: index=\" + index);\n" + indent + "        }\n\n" + indent + "        CodecUtil.%sPut(buffer, this.offset + %d + (index * %d), value%s);\n" + indent + "    }\n", propertyName, javaTypeName, fieldLength, typePrefix, offset, typeSize, byteOrderStr));
        if (encoding.primitiveType() == PrimitiveType.CHAR) {
            this.generateCharacterEncodingMethod(sb, propertyName, encoding.characterEncoding(), indent);
            sb.append(String.format("\n" + indent + "    public int get%s(final byte[] dst, final int dstOffset)\n" + indent + "    {\n" + indent + "        final int length = %d;\n" + indent + "        if (dstOffset < 0 || dstOffset > (dst.length - length))\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"dstOffset out of range for copy: offset=\" + dstOffset);\n" + indent + "        }\n\n" + "%s" + indent + "        CodecUtil.charsGet(buffer, this.offset + %d, dst, dstOffset, length);\n" + indent + "        return length;\n" + indent + "    }\n\n", JavaUtil.toUpperFirstChar(propertyName), fieldLength, this.generateArrayFieldNotPresentCondition(token.version(), indent), offset));
            sb.append(String.format(indent + "    public %s put%s(final byte[] src, final int srcOffset)\n" + indent + "    {\n" + indent + "        final int length = %d;\n" + indent + "        if (srcOffset < 0 || srcOffset > (src.length - length))\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"srcOffset out of range for copy: offset=\" + srcOffset);\n" + indent + "        }\n\n" + indent + "        CodecUtil.charsPut(buffer, this.offset + %d, src, srcOffset, length);\n" + indent + "        return this;\n" + indent + "    }\n", containingClassName, JavaUtil.toUpperFirstChar(propertyName), fieldLength, offset));
        }
        return sb;
    }

    private void generateCharacterEncodingMethod(StringBuilder sb, String propertyName, String encoding, String indent) {
        sb.append(String.format("\n" + indent + "    public static String %sCharacterEncoding()\n" + indent + "    {\n" + indent + "        return \"%s\";\n" + indent + "    }\n", JavaUtil.formatPropertyName(propertyName), encoding));
    }

    private CharSequence generateConstPropertyMethods(String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        if (encoding.primitiveType() != PrimitiveType.CHAR) {
            return String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", JavaUtil.javaTypeName(encoding.primitiveType()), propertyName, this.generateLiteral(encoding.primitiveType(), encoding.constValue().toString()));
        }
        StringBuilder sb = new StringBuilder();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        byte[] constantValue = encoding.constValue().byteArrayValue(encoding.primitiveType());
        CharSequence values = this.generateByteLiteralList(encoding.constValue().byteArrayValue(encoding.primitiveType()));
        sb.append(String.format("\n" + indent + "    private static final byte[] %sValue = {%s};\n", propertyName, values));
        sb.append(String.format("\n" + indent + "    public static int %sLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n\n", propertyName, constantValue.length));
        sb.append(String.format(indent + "    public %s %s(final int index)\n" + indent + "    {\n" + indent + "        return %sValue[index];\n" + indent + "    }\n\n", javaTypeName, propertyName, propertyName));
        sb.append(String.format(indent + "    public int get%s(final byte[] dst, final int offset, final int length)\n" + indent + "    {\n" + indent + "        final int bytesCopied = Math.min(length, %d);\n" + indent + "        System.arraycopy(%sValue, 0, dst, offset, bytesCopied);\n" + indent + "        return bytesCopied;\n" + indent + "    }\n", JavaUtil.toUpperFirstChar(propertyName), constantValue.length, propertyName));
        return sb;
    }

    private CharSequence generateByteLiteralList(byte[] bytes) {
        StringBuilder values = new StringBuilder();
        for (byte b : bytes) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        return values;
    }

    private CharSequence generateFixedFlyweightCode(String className, int size) {
        return String.format("    private DirectBuffer buffer;\n    private int offset;\n    private int actingVersion;\n\n    public %s wrap(final DirectBuffer buffer, final int offset, final int actingVersion)\n    {\n        this.buffer = buffer;\n        this.offset = offset;\n        this.actingVersion = actingVersion;\n        return this;\n    }\n\n    public int size()\n    {\n        return %d;\n    }\n", className, size);
    }

    private CharSequence generateMessageFlyweightCode(String className, Token token) {
        String blockLengthType = JavaUtil.javaTypeName(this.ir.headerStructure().blockLengthType());
        String templateIdType = JavaUtil.javaTypeName(this.ir.headerStructure().templateIdType());
        String schemaIdType = JavaUtil.javaTypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = JavaUtil.javaTypeName(this.ir.headerStructure().schemaVersionType());
        String semanticType = token.encoding().semanticType() == null ? BASE_INDENT : token.encoding().semanticType();
        return String.format("    public static final %1$s BLOCK_LENGTH = %2$s;\n    public static final %3$s TEMPLATE_ID = %4$s;\n    public static final %5$s SCHEMA_ID = %6$s;\n    public static final %7$s SCHEMA_VERSION = %8$s;\n\n    private final %9$s parentMessage = this;\n    private DirectBuffer buffer;\n    private int offset;\n    private int limit;\n    private int actingBlockLength;\n    private int actingVersion;\n\n    public %1$s sbeBlockLength()\n    {\n        return BLOCK_LENGTH;\n    }\n\n    public %3$s sbeTemplateId()\n    {\n        return TEMPLATE_ID;\n    }\n\n    public %5$s sbeSchemaId()\n    {\n        return SCHEMA_ID;\n    }\n\n    public %7$s sbeSchemaVersion()\n    {\n        return SCHEMA_VERSION;\n    }\n\n    public String sbeSemanticType()\n    {\n        return \"%10$s\";\n    }\n\n    public int offset()\n    {\n        return offset;\n    }\n\n    public %9$s wrapForEncode(final DirectBuffer buffer, final int offset)\n    {\n        this.buffer = buffer;\n        this.offset = offset;\n        this.actingBlockLength = BLOCK_LENGTH;\n        this.actingVersion = SCHEMA_VERSION;\n        limit(offset + actingBlockLength);\n\n        return this;\n    }\n\n    public %9$s wrapForDecode(final DirectBuffer buffer, final int offset, final int actingBlockLength, final int actingVersion)\n    {\n        this.buffer = buffer;\n        this.offset = offset;\n        this.actingBlockLength = actingBlockLength;\n        this.actingVersion = actingVersion;\n        limit(offset + actingBlockLength);\n\n        return this;\n    }\n\n    public int size()\n    {\n        return limit - offset;\n    }\n\n    public int limit()\n    {\n        return limit;\n    }\n\n    public void limit(final int limit)\n    {\n        buffer.checkLimit(limit);\n        this.limit = limit;\n    }\n", blockLengthType, this.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.size())), templateIdType, this.generateLiteral(this.ir.headerStructure().templateIdType(), Integer.toString(token.id())), schemaIdType, this.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(token.version())), className, semanticType);
    }

    private CharSequence generateFields(String containingClassName, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = JavaUtil.formatPropertyName(signalToken.name());
            this.generateFieldIdMethod(sb, signalToken, indent);
            this.generateFieldMetaAttributeMethod(sb, signalToken, indent);
            switch (encodingToken.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(containingClassName, propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(containingClassName, propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitSetProperty(propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, encodingToken, indent));
                }
            }
        }
        return sb;
    }

    private void generateFieldIdMethod(StringBuilder sb, Token token, String indent) {
        sb.append(String.format("\n" + indent + "    public static int %sId()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", token.name(), token.id()));
    }

    private void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? BASE_INDENT : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? BASE_INDENT : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? BASE_INDENT : encoding.semanticType();
        sb.append(String.format("\n" + indent + "    public static String %sMetaAttribute(final MetaAttribute metaAttribute)\n" + indent + "    {\n" + indent + "        switch (metaAttribute)\n" + indent + "        {\n" + indent + "            case EPOCH: return \"%s\";\n" + indent + "            case TIME_UNIT: return \"%s\";\n" + indent + "            case SEMANTIC_TYPE: return \"%s\";\n" + indent + "        }\n\n" + indent + "        return \"\";\n" + indent + "    }\n", token.name(), epoch, timeUnit, semanticType));
    }

    private CharSequence generateEnumProperty(String containingClassName, String propertyName, Token token, String indent) {
        String enumName = token.name();
        Encoding encoding = token.encoding();
        String typePrefix = encoding.primitiveType().primitiveName();
        Integer offset = token.offset();
        ByteOrder byteOrder = encoding.byteOrder();
        String byteOrderStr = encoding.primitiveType().size() == 1 ? BASE_INDENT : ", java.nio.ByteOrder." + byteOrder;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + "%s" + indent + "        return %s.get(CodecUtil.%sGet(buffer, offset + %d%s));\n" + indent + "    }\n\n", enumName, propertyName, this.generateTypeFieldNotPresentCondition(token.version(), indent), enumName, typePrefix, offset, byteOrderStr));
        sb.append(String.format(indent + "    public %s %s(final %s value)\n" + indent + "    {\n" + indent + "        CodecUtil.%sPut(buffer, offset + %d, value.value()%s);\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), propertyName, enumName, typePrefix, offset, byteOrderStr));
        return sb;
    }

    private Object generateBitSetProperty(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String bitSetName = JavaUtil.formatClassName(token.name());
        Integer offset = token.offset();
        sb.append(String.format("\n" + indent + "    private final %s %s = new %s();\n", bitSetName, propertyName, bitSetName));
        sb.append(String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + "%s" + indent + "        %s.wrap(buffer, offset + %d, actingVersion);\n" + indent + "        return %s;\n" + indent + "    }\n", bitSetName, propertyName, this.generateTypeFieldNotPresentCondition(token.version(), indent), propertyName, offset, propertyName));
        return sb;
    }

    private Object generateCompositeProperty(String propertyName, Token token, String indent) {
        String compositeName = JavaUtil.formatClassName(token.name());
        Integer offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    private final %s %s = new %s();\n", compositeName, propertyName, compositeName));
        sb.append(String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + "%s" + indent + "        %s.wrap(buffer, offset + %d, actingVersion);\n" + indent + "        return %s;\n" + indent + "    }\n", compositeName, propertyName, this.generateTypeFieldNotPresentCondition(token.version(), indent), propertyName, offset, propertyName));
        return sb;
    }

    private String generateLiteral(PrimitiveType type, String value) {
        String literal = BASE_INDENT;
        String castType = JavaUtil.javaTypeName(type);
        switch (type) {
            case CHAR: 
            case UINT8: 
            case INT8: 
            case INT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case UINT16: 
            case INT32: {
                literal = value;
                break;
            }
            case UINT32: {
                literal = value + "L";
                break;
            }
            case FLOAT: {
                if (value.endsWith("NaN")) {
                    literal = "Float.NaN";
                    break;
                }
                literal = value + "f";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "Double.NaN" : value + "d";
            }
        }
        return literal;
    }
}

