/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.co.real_logic.sbe.ir.HeaderStructure;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.util.Verify;

public class Ir {
    private final String packageName;
    private final String namespaceName;
    private final int id;
    private final int version;
    private final String semanticVersion;
    private final HeaderStructure headerStructure;
    private final Map<Long, List<Token>> messagesByIdMap = new HashMap<Long, List<Token>>();
    private final Map<String, List<Token>> typesByNameMap = new HashMap<String, List<Token>>();

    public Ir(String packageName, String namespaceName, int id, int version, String semanticVersion, List<Token> headerTokens) {
        Verify.notNull(packageName, "packageName");
        Verify.notNull(headerTokens, "headerTokens");
        this.packageName = packageName;
        this.namespaceName = namespaceName;
        this.id = id;
        this.version = version;
        this.semanticVersion = semanticVersion;
        this.headerStructure = new HeaderStructure(Collections.unmodifiableList(new ArrayList<Token>(headerTokens)));
    }

    public HeaderStructure headerStructure() {
        return this.headerStructure;
    }

    public void addMessage(long messageId, List<Token> messageTokens) {
        Verify.notNull(messageTokens, "messageTokens");
        this.captureTypes(messageTokens);
        this.messagesByIdMap.put(messageId, Collections.unmodifiableList(new ArrayList<Token>(messageTokens)));
    }

    public List<Token> getMessage(long messageId) {
        return this.messagesByIdMap.get(messageId);
    }

    public List<Token> getType(String name) {
        return this.typesByNameMap.get(name);
    }

    public Collection<List<Token>> types() {
        return this.typesByNameMap.values();
    }

    public Collection<List<Token>> messages() {
        return this.messagesByIdMap.values();
    }

    public String packageName() {
        return this.packageName;
    }

    public String namespaceName() {
        return this.namespaceName;
    }

    public int id() {
        return this.id;
    }

    public int version() {
        return this.version;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public String applicableNamespace() {
        return this.namespaceName == null ? this.packageName : this.namespaceName;
    }

    private void captureTypes(List<Token> tokens) {
        int size = tokens.size();
        block5: for (int i = 0; i < size; ++i) {
            switch (tokens.get(i).signal()) {
                case BEGIN_COMPOSITE: {
                    i = this.captureType(tokens, i, Signal.END_COMPOSITE);
                    continue block5;
                }
                case BEGIN_ENUM: {
                    i = this.captureType(tokens, i, Signal.END_ENUM);
                    continue block5;
                }
                case BEGIN_SET: {
                    i = this.captureType(tokens, i, Signal.END_SET);
                }
            }
        }
    }

    private int captureType(List<Token> tokens, int index, Signal endSignal) {
        ArrayList<Token> typeTokens = new ArrayList<Token>();
        Token token = tokens.get(index);
        typeTokens.add(token);
        do {
            token = tokens.get(++index);
            typeTokens.add(token);
        } while (endSignal != token.signal());
        this.typesByNameMap.put(tokens.get(index).name(), Collections.unmodifiableList(typeTokens));
        return index;
    }
}

