/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.codec.java.DirectBuffer;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrUtil;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.ir.generated.FrameCodec;
import uk.co.real_logic.sbe.ir.generated.TokenCodec;

public class IrDecoder
implements Closeable {
    private static final int CAPACITY = 4096;
    private final FileChannel channel;
    private final DirectBuffer directBuffer;
    private final FrameCodec frameCodec = new FrameCodec();
    private final TokenCodec tokenCodec = new TokenCodec();
    private int offset;
    private final long size;
    private String irPackageName = null;
    private String irNamespaceName = null;
    private String semanticVersion = null;
    private List<Token> irHeader = null;
    private int irId;
    private int irVersion = 0;
    private final byte[] valArray = new byte[4096];
    private final DirectBuffer valBuffer = new DirectBuffer(this.valArray);
    private final byte[] buffer = new byte[1024];

    public IrDecoder(String fileName) throws IOException {
        this.channel = new RandomAccessFile(fileName, "r").getChannel();
        MappedByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
        this.directBuffer = new DirectBuffer(buffer);
        this.size = this.channel.size();
        this.offset = 0;
    }

    public IrDecoder(ByteBuffer buffer) {
        this.channel = null;
        this.size = buffer.limit();
        this.directBuffer = new DirectBuffer(buffer);
        this.offset = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public Ir decode() throws IOException {
        this.decodeFrame();
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((long)this.offset < this.size) {
            tokens.add(this.decodeToken());
        }
        int i = 0;
        int size = tokens.size();
        if (((Token)tokens.get(0)).signal() == Signal.BEGIN_COMPOSITE) {
            i = this.captureHeader(tokens, 0);
        }
        Ir ir = new Ir(this.irPackageName, this.irNamespaceName, this.irId, this.irVersion, this.semanticVersion, this.irHeader);
        while (i < size) {
            if (((Token)tokens.get(i)).signal() == Signal.BEGIN_MESSAGE) {
                i = this.captureMessage(tokens, i, ir);
            }
            ++i;
        }
        return ir;
    }

    private int captureHeader(List<Token> tokens, int index) {
        ArrayList<Token> headerTokens = new ArrayList<Token>();
        Token token = tokens.get(index);
        headerTokens.add(token);
        do {
            token = tokens.get(++index);
            headerTokens.add(token);
        } while (Signal.END_COMPOSITE != token.signal());
        this.irHeader = headerTokens;
        return index;
    }

    private int captureMessage(List<Token> tokens, int index, Ir ir) {
        ArrayList<Token> messageTokens = new ArrayList<Token>();
        Token token = tokens.get(index);
        messageTokens.add(token);
        do {
            token = tokens.get(++index);
            messageTokens.add(token);
        } while (Signal.END_MESSAGE != token.signal());
        ir.addMessage(tokens.get(index).id(), messageTokens);
        return index;
    }

    private void decodeFrame() throws UnsupportedEncodingException {
        this.frameCodec.wrapForDecode(this.directBuffer, this.offset, this.frameCodec.sbeBlockLength(), 0);
        this.irId = this.frameCodec.irId();
        if (this.frameCodec.irVersion() != 0) {
            throw new IllegalStateException("Unknown SBE version: " + this.frameCodec.irVersion());
        }
        this.irVersion = this.frameCodec.schemaVersion();
        this.irPackageName = new String(this.buffer, 0, this.frameCodec.getPackageName(this.buffer, 0, this.buffer.length), FrameCodec.packageNameCharacterEncoding());
        this.irNamespaceName = new String(this.buffer, 0, this.frameCodec.getNamespaceName(this.buffer, 0, this.buffer.length), FrameCodec.namespaceNameCharacterEncoding());
        if (this.irNamespaceName.isEmpty()) {
            this.irNamespaceName = null;
        }
        this.semanticVersion = new String(this.buffer, 0, this.frameCodec.getSemanticVersion(this.buffer, 0, this.buffer.length), FrameCodec.semanticVersionCharacterEncoding());
        if (this.semanticVersion.isEmpty()) {
            this.semanticVersion = null;
        }
        this.offset += this.frameCodec.size();
    }

    private Token decodeToken() throws UnsupportedEncodingException {
        Token.Builder tokenBuilder = new Token.Builder();
        Encoding.Builder encBuilder = new Encoding.Builder();
        this.tokenCodec.wrapForDecode(this.directBuffer, this.offset, this.tokenCodec.sbeBlockLength(), 0);
        tokenBuilder.offset(this.tokenCodec.tokenOffset()).size(this.tokenCodec.tokenSize()).id(this.tokenCodec.fieldId()).version(this.tokenCodec.tokenVersion()).signal(IrUtil.mapSignal(this.tokenCodec.signal()));
        PrimitiveType type = IrUtil.mapPrimitiveType(this.tokenCodec.primitiveType());
        encBuilder.primitiveType(IrUtil.mapPrimitiveType(this.tokenCodec.primitiveType())).byteOrder(IrUtil.mapByteOrder(this.tokenCodec.byteOrder())).presence(IrUtil.mapPresence(this.tokenCodec.presence()));
        tokenBuilder.name(new String(this.buffer, 0, this.tokenCodec.getName(this.buffer, 0, this.buffer.length), TokenCodec.nameCharacterEncoding()));
        encBuilder.constValue(IrUtil.get(this.valBuffer, type, this.tokenCodec.getConstValue(this.valArray, 0, this.valArray.length)));
        encBuilder.minValue(IrUtil.get(this.valBuffer, type, this.tokenCodec.getMinValue(this.valArray, 0, this.valArray.length)));
        encBuilder.maxValue(IrUtil.get(this.valBuffer, type, this.tokenCodec.getMaxValue(this.valArray, 0, this.valArray.length)));
        encBuilder.nullValue(IrUtil.get(this.valBuffer, type, this.tokenCodec.getNullValue(this.valArray, 0, this.valArray.length)));
        String characterEncoding = new String(this.buffer, 0, this.tokenCodec.getCharacterEncoding(this.buffer, 0, this.buffer.length), TokenCodec.characterEncodingCharacterEncoding());
        encBuilder.characterEncoding(characterEncoding.isEmpty() ? null : characterEncoding);
        String epoch = new String(this.buffer, 0, this.tokenCodec.getEpoch(this.buffer, 0, this.buffer.length), TokenCodec.epochCharacterEncoding());
        encBuilder.epoch(epoch.isEmpty() ? null : epoch);
        String timeUnit = new String(this.buffer, 0, this.tokenCodec.getTimeUnit(this.buffer, 0, this.buffer.length), TokenCodec.timeUnitCharacterEncoding());
        encBuilder.timeUnit(timeUnit.isEmpty() ? null : timeUnit);
        String semanticType = new String(this.buffer, 0, this.tokenCodec.getSemanticType(this.buffer, 0, this.buffer.length), TokenCodec.semanticTypeCharacterEncoding());
        encBuilder.semanticType(semanticType.isEmpty() ? null : semanticType);
        this.offset += this.tokenCodec.size();
        return tokenBuilder.encoding(encBuilder.build()).build();
    }
}

