/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.codec.java.DirectBuffer;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrUtil;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.ir.generated.FrameCodec;
import uk.co.real_logic.sbe.ir.generated.TokenCodec;
import uk.co.real_logic.sbe.util.Verify;

public class IrEncoder
implements Closeable {
    private static final int CAPACITY = 4096;
    private final FileChannel channel;
    private final ByteBuffer resultBuffer;
    private final ByteBuffer buffer;
    private final DirectBuffer directBuffer;
    private final Ir ir;
    private final FrameCodec frameCodec = new FrameCodec();
    private final TokenCodec tokenCodec = new TokenCodec();
    private final byte[] valArray = new byte[4096];
    private final DirectBuffer valBuffer = new DirectBuffer(this.valArray);
    private int totalSize = 0;

    public IrEncoder(String fileName, Ir ir) throws FileNotFoundException {
        this.channel = new FileOutputStream(fileName).getChannel();
        this.resultBuffer = null;
        this.buffer = ByteBuffer.allocateDirect(4096);
        this.directBuffer = new DirectBuffer(this.buffer);
        this.ir = ir;
    }

    public IrEncoder(ByteBuffer buffer, Ir ir) {
        this.channel = null;
        this.resultBuffer = buffer;
        this.buffer = ByteBuffer.allocateDirect(4096);
        this.directBuffer = new DirectBuffer(this.buffer);
        this.ir = ir;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public int encode() throws IOException {
        Verify.notNull(this.ir, "ir");
        this.write(this.buffer, this.encodeFrame());
        this.encodeTokenList(this.ir.headerStructure().tokens());
        for (List<Token> tokenList : this.ir.messages()) {
            this.encodeTokenList(tokenList);
        }
        return this.totalSize;
    }

    private void encodeTokenList(List<Token> tokenList) throws IOException {
        for (Token token : tokenList) {
            this.write(this.buffer, this.encodeToken(token));
        }
    }

    private void write(ByteBuffer buffer, int size) throws IOException {
        buffer.position(0);
        buffer.limit(size);
        if (this.channel != null) {
            this.channel.write(buffer);
        } else if (this.resultBuffer != null) {
            this.resultBuffer.put(buffer);
        }
        this.totalSize += size;
    }

    private int encodeFrame() throws UnsupportedEncodingException {
        this.frameCodec.wrapForEncode(this.directBuffer, 0).irId(this.ir.id()).irVersion(0).schemaVersion(this.ir.version());
        byte[] packageBytes = this.ir.packageName().getBytes(FrameCodec.packageNameCharacterEncoding());
        this.frameCodec.putPackageName(packageBytes, 0, packageBytes.length);
        byte[] namespaceBytes = IrUtil.getBytes(this.ir.namespaceName(), FrameCodec.namespaceNameCharacterEncoding());
        this.frameCodec.putNamespaceName(namespaceBytes, 0, namespaceBytes.length);
        byte[] semanticVersionBytes = IrUtil.getBytes(this.ir.semanticVersion(), FrameCodec.semanticVersionCharacterEncoding());
        this.frameCodec.putSemanticVersion(semanticVersionBytes, 0, semanticVersionBytes.length);
        return this.frameCodec.size();
    }

    private int encodeToken(Token token) throws UnsupportedEncodingException {
        Encoding encoding = token.encoding();
        PrimitiveType type = encoding.primitiveType();
        this.tokenCodec.wrapForEncode(this.directBuffer, 0).tokenOffset(token.offset()).tokenSize(token.size()).fieldId(token.id()).tokenVersion(token.version()).signal(IrUtil.mapSignal(token.signal())).primitiveType(IrUtil.mapPrimitiveType(type)).byteOrder(IrUtil.mapByteOrder(encoding.byteOrder())).presence(IrUtil.mapPresence(encoding.presence()));
        byte[] nameBytes = token.name().getBytes(TokenCodec.nameCharacterEncoding());
        this.tokenCodec.putName(nameBytes, 0, nameBytes.length);
        this.tokenCodec.putConstValue(this.valArray, 0, IrUtil.put(this.valBuffer, encoding.constValue(), type));
        this.tokenCodec.putMinValue(this.valArray, 0, IrUtil.put(this.valBuffer, encoding.minValue(), type));
        this.tokenCodec.putMaxValue(this.valArray, 0, IrUtil.put(this.valBuffer, encoding.maxValue(), type));
        this.tokenCodec.putNullValue(this.valArray, 0, IrUtil.put(this.valBuffer, encoding.nullValue(), type));
        byte[] charEncodingBytes = IrUtil.getBytes(encoding.characterEncoding(), TokenCodec.characterEncodingCharacterEncoding());
        this.tokenCodec.putCharacterEncoding(charEncodingBytes, 0, charEncodingBytes.length);
        byte[] epochBytes = IrUtil.getBytes(encoding.epoch(), TokenCodec.epochCharacterEncoding());
        this.tokenCodec.putEpoch(epochBytes, 0, epochBytes.length);
        byte[] timeUnitBytes = IrUtil.getBytes(encoding.timeUnit(), TokenCodec.timeUnitCharacterEncoding());
        this.tokenCodec.putTimeUnit(timeUnitBytes, 0, timeUnitBytes.length);
        byte[] semanticTypeBytes = IrUtil.getBytes(encoding.semanticType(), TokenCodec.semanticTypeCharacterEncoding());
        this.tokenCodec.putSemanticType(semanticTypeBytes, 0, semanticTypeBytes.length);
        return this.tokenCodec.size();
    }
}

