/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.util.Verify;

public class Token {
    public static final int INVALID_ID = -1;
    public static final int VARIABLE_SIZE = -1;
    public static final int UNKNOWN_OFFSET = -1;
    private final Signal signal;
    private final String name;
    private final int id;
    private final int version;
    private final int size;
    private final int offset;
    private final Encoding encoding;

    public Token(Signal signal, String name, int id, int version, int size, int offset, Encoding encoding) {
        Verify.notNull((Object)signal, "signal");
        Verify.notNull(name, "name");
        Verify.notNull(encoding, "encoding");
        this.signal = signal;
        this.name = name;
        this.id = id;
        this.version = version;
        this.size = size;
        this.offset = offset;
        this.encoding = encoding;
    }

    public Signal signal() {
        return this.signal;
    }

    public String name() {
        return this.name;
    }

    public int id() {
        return this.id;
    }

    public int version() {
        return this.version;
    }

    public VersionContext versionContext() {
        if (this.signal == Signal.BEGIN_MESSAGE || this.signal == Signal.END_MESSAGE) {
            return VersionContext.TEMPLATE_VERSION;
        }
        return VersionContext.SINCE_TEMPLATE_VERSION;
    }

    public int size() {
        return this.size;
    }

    public int arrayLength() {
        if (null == this.encoding.primitiveType() || 0 == this.size) {
            return 0;
        }
        return this.size / this.encoding.primitiveType().size();
    }

    public int offset() {
        return this.offset;
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public String toString() {
        return "Token{signal=" + (Object)((Object)this.signal) + ", name='" + this.name + '\'' + ", id=" + this.id + ", version=" + this.version + ", size=" + this.size + ", offset=" + this.offset + ", encoding=" + this.encoding + '}';
    }

    public static class Builder {
        private Signal signal;
        private String name;
        private int id = -1;
        private int version = 0;
        private int size = 0;
        private int offset = 0;
        private Encoding encoding = new Encoding();

        public Builder signal(Signal signal) {
            this.signal = signal;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public Token build() {
            return new Token(this.signal, this.name, this.id, this.version, this.size, this.offset, this.encoding);
        }
    }

    public static enum VersionContext {
        TEMPLATE_VERSION,
        SINCE_TEMPLATE_VERSION;

    }
}

