/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir.generated;

import java.nio.ByteOrder;
import uk.co.real_logic.sbe.codec.java.CodecUtil;
import uk.co.real_logic.sbe.codec.java.DirectBuffer;
import uk.co.real_logic.sbe.ir.generated.MetaAttribute;

public class FrameCodec {
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 0;
    private final FrameCodec parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    private int actingBlockLength;
    private int actingVersion;

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public int offset() {
        return this.offset;
    }

    public FrameCodec wrapForEncode(DirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.actingBlockLength = 12;
        this.actingVersion = 0;
        this.limit(offset + this.actingBlockLength);
        return this;
    }

    public FrameCodec wrapForDecode(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        this.buffer = buffer;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int size() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.buffer.checkLimit(limit);
        this.limit = limit;
    }

    public static int irIdId() {
        return 1;
    }

    public static String irIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int irIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int irIdMinValue() {
        return -2147483647;
    }

    public static int irIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int irId() {
        return CodecUtil.int32Get(this.buffer, this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public FrameCodec irId(int value) {
        CodecUtil.int32Put(this.buffer, this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int irVersionId() {
        return 2;
    }

    public static String irVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int irVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int irVersionMinValue() {
        return -2147483647;
    }

    public static int irVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int irVersion() {
        return CodecUtil.int32Get(this.buffer, this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public FrameCodec irVersion(int value) {
        CodecUtil.int32Put(this.buffer, this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int schemaVersionId() {
        return 3;
    }

    public static String schemaVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int schemaVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int schemaVersionMinValue() {
        return -2147483647;
    }

    public static int schemaVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int schemaVersion() {
        return CodecUtil.int32Get(this.buffer, this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public FrameCodec schemaVersion(int value) {
        CodecUtil.int32Put(this.buffer, this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int packageNameId() {
        return 4;
    }

    public static String packageNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String packageNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int packageNameHeaderSize() {
        return 1;
    }

    public int getPackageName(byte[] dst, int dstOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.limit();
        this.buffer.checkLimit(limit + 1);
        short dataLength = CodecUtil.uint8Get(this.buffer, limit);
        int bytesCopied = Math.min(length, dataLength);
        this.limit(limit + 1 + dataLength);
        CodecUtil.int8sGet(this.buffer, limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int putPackageName(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.limit();
        this.limit(limit + 1 + length);
        CodecUtil.uint8Put(this.buffer, limit, (short)length);
        CodecUtil.int8sPut(this.buffer, limit + 1, src, srcOffset, length);
        return length;
    }

    public static int namespaceNameId() {
        return 5;
    }

    public static String namespaceNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String namespaceNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int namespaceNameHeaderSize() {
        return 1;
    }

    public int getNamespaceName(byte[] dst, int dstOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.limit();
        this.buffer.checkLimit(limit + 1);
        short dataLength = CodecUtil.uint8Get(this.buffer, limit);
        int bytesCopied = Math.min(length, dataLength);
        this.limit(limit + 1 + dataLength);
        CodecUtil.int8sGet(this.buffer, limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int putNamespaceName(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.limit();
        this.limit(limit + 1 + length);
        CodecUtil.uint8Put(this.buffer, limit, (short)length);
        CodecUtil.int8sPut(this.buffer, limit + 1, src, srcOffset, length);
        return length;
    }

    public static int semanticVersionId() {
        return 6;
    }

    public static String semanticVersionCharacterEncoding() {
        return "UTF-8";
    }

    public static String semanticVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int semanticVersionHeaderSize() {
        return 1;
    }

    public int getSemanticVersion(byte[] dst, int dstOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.limit();
        this.buffer.checkLimit(limit + 1);
        short dataLength = CodecUtil.uint8Get(this.buffer, limit);
        int bytesCopied = Math.min(length, dataLength);
        this.limit(limit + 1 + dataLength);
        CodecUtil.int8sGet(this.buffer, limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int putSemanticVersion(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.limit();
        this.limit(limit + 1 + length);
        CodecUtil.uint8Put(this.buffer, limit, (short)length);
        CodecUtil.int8sPut(this.buffer, limit + 1, src, srcOffset, length);
        return length;
    }
}

