/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.otf;

import java.util.List;
import uk.co.real_logic.sbe.codec.java.DirectBuffer;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.otf.TokenListener;
import uk.co.real_logic.sbe.otf.Util;

public class OtfMessageDecoder {
    private static final int GROUP_DIM_TYPE_TOKENS = 5;
    private static final int VAR_DATA_TOKENS = 5;

    public static int decode(DirectBuffer buffer, int bufferIndex, int actingVersion, int blockLength, List<Token> msgTokens, TokenListener listener) {
        int groupsBeginIndex = OtfMessageDecoder.findNextOrLimit(msgTokens, 1, msgTokens.size(), Signal.BEGIN_GROUP);
        int varDataSearchStart = groupsBeginIndex != msgTokens.size() ? groupsBeginIndex : 1;
        int varDataBeginIndex = OtfMessageDecoder.findNextOrLimit(msgTokens, varDataSearchStart, msgTokens.size(), Signal.BEGIN_VAR_DATA);
        listener.onBeginMessage(msgTokens.get(0));
        OtfMessageDecoder.decodeFields(buffer, bufferIndex, actingVersion, msgTokens, 0, groupsBeginIndex, listener);
        bufferIndex += blockLength;
        bufferIndex = OtfMessageDecoder.decodeGroups(buffer, bufferIndex, actingVersion, msgTokens, groupsBeginIndex, varDataBeginIndex, listener);
        bufferIndex = OtfMessageDecoder.decodeVarData(buffer, bufferIndex, msgTokens, varDataBeginIndex, msgTokens.size(), listener);
        listener.onEndMessage(msgTokens.get(msgTokens.size() - 1));
        return bufferIndex;
    }

    private static void decodeFields(DirectBuffer buffer, int bufferIndex, int actingVersion, List<Token> tokens, int fromIndex, int toIndex, TokenListener listener) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (Signal.BEGIN_FIELD != tokens.get(i).signal()) continue;
            i = OtfMessageDecoder.decodeField(buffer, bufferIndex, tokens, i, actingVersion, listener);
        }
    }

    private static int decodeGroups(DirectBuffer buffer, int bufferIndex, int actingVersion, List<Token> tokens, int fromIndex, int toIndex, TokenListener listener) {
        for (int i = fromIndex; i < toIndex; ++i) {
            Token token = tokens.get(i);
            if (Signal.BEGIN_GROUP != token.signal()) continue;
            Token blockLengthToken = tokens.get(i + 2);
            int blockLength = Util.getInt(buffer, bufferIndex + blockLengthToken.offset(), blockLengthToken.encoding().primitiveType(), blockLengthToken.encoding().byteOrder());
            Token numInGroupToken = tokens.get(i + 3);
            int numInGroup = Util.getInt(buffer, bufferIndex + numInGroupToken.offset(), numInGroupToken.encoding().primitiveType(), numInGroupToken.encoding().byteOrder());
            Token dimensionTypeComposite = tokens.get(i + 1);
            bufferIndex += dimensionTypeComposite.size();
            int beginFieldsIndex = i + 5;
            int endGroupIndex = OtfMessageDecoder.findNextOrLimit(tokens, beginFieldsIndex, toIndex, Signal.END_GROUP);
            int nextGroupIndex = OtfMessageDecoder.findNextOrLimit(tokens, beginFieldsIndex, toIndex, Signal.BEGIN_GROUP);
            int endOfFieldsIndex = Math.min(endGroupIndex, nextGroupIndex) - 1;
            for (int g = 0; g < numInGroup; ++g) {
                listener.onBeginGroup(token, g, numInGroup);
                OtfMessageDecoder.decodeFields(buffer, bufferIndex, actingVersion, tokens, beginFieldsIndex, endOfFieldsIndex, listener);
                bufferIndex += blockLength;
                if (nextGroupIndex < endGroupIndex) {
                    bufferIndex = OtfMessageDecoder.decodeGroups(buffer, bufferIndex, actingVersion, tokens, nextGroupIndex, toIndex, listener);
                }
                listener.onEndGroup(token, g, numInGroup);
            }
            i = endGroupIndex;
        }
        return bufferIndex;
    }

    private static int decodeVarData(DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int toIndex, TokenListener listener) {
        for (int i = fromIndex; i < toIndex; ++i) {
            Token token = tokens.get(i);
            if (Signal.BEGIN_VAR_DATA != token.signal()) continue;
            Token lengthToken = tokens.get(i + 2);
            int length = Util.getInt(buffer, bufferIndex + lengthToken.offset(), lengthToken.encoding().primitiveType(), lengthToken.encoding().byteOrder());
            Token varDataToken = tokens.get(i + 3);
            listener.onVarData(token, buffer, bufferIndex += varDataToken.offset(), length, varDataToken);
            bufferIndex += length;
            i += 5;
        }
        return bufferIndex;
    }

    private static int decodeField(DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int actingVersion, TokenListener listener) {
        int toIndex = OtfMessageDecoder.findNextOrLimit(tokens, fromIndex + 1, tokens.size(), Signal.END_FIELD);
        Token fieldToken = tokens.get(fromIndex);
        Token typeToken = tokens.get(fromIndex + 1);
        switch (typeToken.signal()) {
            case BEGIN_COMPOSITE: {
                OtfMessageDecoder.decodeComposite(fieldToken, buffer, bufferIndex + typeToken.offset(), tokens, fromIndex + 1, toIndex - 1, actingVersion, listener);
                break;
            }
            case BEGIN_ENUM: {
                listener.onEnum(fieldToken, buffer, bufferIndex + typeToken.offset(), tokens, fromIndex + 1, toIndex - 1, actingVersion);
                break;
            }
            case BEGIN_SET: {
                listener.onBitSet(fieldToken, buffer, bufferIndex + typeToken.offset(), tokens, fromIndex + 1, toIndex - 1, actingVersion);
                break;
            }
            case ENCODING: {
                listener.onEncoding(fieldToken, buffer, bufferIndex + typeToken.offset(), typeToken, actingVersion);
            }
        }
        return toIndex;
    }

    private static void decodeComposite(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int toIndex, int actingVersion, TokenListener listener) {
        listener.onBeginComposite(fieldToken, tokens, fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            Token token = tokens.get(i);
            listener.onEncoding(token, buffer, bufferIndex + token.offset(), token, actingVersion);
        }
        listener.onEndComposite(fieldToken, tokens, fromIndex, toIndex);
    }

    private static int findNextOrLimit(List<Token> tokens, int fromIndex, int limitIndex, Signal signal) {
        int i;
        for (i = fromIndex; i < limitIndex && tokens.get(i).signal() != signal; ++i) {
        }
        return i;
    }
}

