/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class CompositeType
extends Type {
    private final List<EncodedDataType> containedTypeList = new ArrayList<EncodedDataType>();
    private final Map<String, EncodedDataType> containedTypeByNameMap = new HashMap<String, EncodedDataType>();
    private final int sinceVersion;

    public CompositeType(Node node) throws XPathExpressionException {
        super(node);
        this.sinceVersion = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "sinceVersion", "0"));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList list = (NodeList)xPath.compile("type").evaluate(node, XPathConstants.NODESET);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            EncodedDataType type = new EncodedDataType(list.item(i));
            if (this.containedTypeByNameMap.get(type.name()) != null) {
                XmlSchemaParser.handleError(node, "composite already contains type named: " + type.name());
                continue;
            }
            this.containedTypeList.add(type);
            this.containedTypeByNameMap.put(type.name(), type);
        }
        this.checkForValidOffsets(node);
    }

    public EncodedDataType getType(String name) {
        return this.containedTypeByNameMap.get(name);
    }

    @Override
    public int size() {
        int offset = 0;
        for (EncodedDataType t : this.containedTypeList) {
            if (t.isVariableLength()) {
                return -1;
            }
            if (t.offsetAttribute() != -1) {
                offset = t.offsetAttribute();
            }
            offset += t.size();
        }
        return offset;
    }

    public int sinceVersion() {
        return this.sinceVersion;
    }

    public List<EncodedDataType> getTypeList() {
        return this.containedTypeList;
    }

    public void makeDataFieldCompositeType() {
        EncodedDataType edt = this.containedTypeByNameMap.get("varData");
        if (edt != null) {
            edt.variableLength(true);
        }
    }

    public void checkForWellFormedGroupSizeEncoding(Node node) {
        if (this.containedTypeByNameMap.get("blockLength") == null) {
            XmlSchemaParser.handleError(node, "composite for group size encoding must have \"blockLength\"");
        }
        if (this.containedTypeByNameMap.get("numInGroup") == null) {
            XmlSchemaParser.handleError(node, "composite for group size encoding must have \"numInGroup\"");
        }
    }

    public void checkForWellFormedVariableLengthDataEncoding(Node node) {
        if (this.containedTypeByNameMap.get("length") == null) {
            XmlSchemaParser.handleError(node, "composite for variable length data encoding must have \"length\"");
        }
        if (this.containedTypeByNameMap.get("varData") == null) {
            XmlSchemaParser.handleError(node, "composite for variable length data encoding must have \"varData\"");
        }
    }

    public void checkForWellFormedMessageHeader(Node node) {
        if (this.containedTypeByNameMap.get("blockLength") == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"blockLength\"");
        }
        if (this.containedTypeByNameMap.get("templateId") == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"templateId\"");
        }
        if (this.containedTypeByNameMap.get("schemaId") == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"schemaId\"");
        }
        if (this.containedTypeByNameMap.get("version") == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"version\"");
        }
    }

    public void checkForValidOffsets(Node node) {
        int offset = 0;
        for (EncodedDataType edt : this.containedTypeList) {
            int offsetAttribute = edt.offsetAttribute();
            if (-1 != offsetAttribute) {
                if (offsetAttribute < offset) {
                    XmlSchemaParser.handleError(node, String.format("composite element \"%s\" has incorrect offset specified", edt.name()));
                }
                offset = offsetAttribute;
            }
            offset += edt.size();
        }
    }
}

