/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.Field;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class Message {
    private static final String FIELD_OR_GROUP_OR_DATA_EXPR = "field|group|data";
    private final int id;
    private final String name;
    private final String description;
    private final int blockLength;
    private final List<Field> fieldList;
    private final String semanticType;
    private final String headerType;
    private final int computedBlockLength;
    private final Map<String, Type> typeByNameMap;

    public Message(Node messageNode, Map<String, Type> typeByNameMap) throws XPathExpressionException {
        this.id = Integer.parseInt(XmlSchemaParser.getAttributeValue(messageNode, "id"));
        this.name = XmlSchemaParser.getAttributeValue(messageNode, "name");
        this.description = XmlSchemaParser.getAttributeValueOrNull(messageNode, "description");
        this.blockLength = Integer.parseInt(XmlSchemaParser.getAttributeValue(messageNode, "blockLength", "0"));
        this.semanticType = XmlSchemaParser.getAttributeValueOrNull(messageNode, "semanticType");
        this.headerType = XmlSchemaParser.getAttributeValue(messageNode, "headerType", "messageHeader");
        this.typeByNameMap = typeByNameMap;
        this.fieldList = this.parseFieldsAndGroups(messageNode);
        this.computeAndValidateOffsets(messageNode, this.fieldList, this.blockLength);
        this.computedBlockLength = this.computeMessageRootBlockLength();
        this.validateBlockLength(messageNode, this.blockLength, this.computedBlockLength);
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String semanticType() {
        return this.semanticType;
    }

    public List<Field> fields() {
        return this.fieldList;
    }

    public int blockLength() {
        return this.blockLength > this.computedBlockLength ? this.blockLength : this.computedBlockLength;
    }

    public String headerType() {
        return this.headerType;
    }

    private List<Field> parseFieldsAndGroups(Node node) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList list = (NodeList)xPath.compile(FIELD_OR_GROUP_OR_DATA_EXPR).evaluate(node, XPathConstants.NODESET);
        boolean groupEncountered = false;
        boolean dataEncountered = false;
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Field field;
            String nodeName;
            switch (nodeName = list.item(i).getNodeName()) {
                case "group": {
                    if (dataEncountered) {
                        XmlSchemaParser.handleError(node, "group node specified after data node");
                    }
                    field = this.parseGroupField(list, i);
                    groupEncountered = true;
                    break;
                }
                case "data": {
                    field = this.parseDataField(list, i);
                    dataEncountered = true;
                    break;
                }
                case "field": {
                    if (groupEncountered || dataEncountered) {
                        XmlSchemaParser.handleError(node, "field node specified after group or data node specified");
                    }
                    field = this.parseField(list, i);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown node name: " + nodeName);
                }
            }
            fieldList.add(field);
        }
        return fieldList;
    }

    private Field parseGroupField(NodeList nodeList, int nodeIndex) throws XPathExpressionException {
        String dimensionTypeName = XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "dimensionType", "groupSizeEncoding");
        Type dimensionType = this.typeByNameMap.get(dimensionTypeName);
        if (dimensionType == null) {
            XmlSchemaParser.handleError(nodeList.item(nodeIndex), "could not find dimensionType: " + dimensionTypeName);
        } else if (!(dimensionType instanceof CompositeType)) {
            XmlSchemaParser.handleError(nodeList.item(nodeIndex), "dimensionType should be a composite type: " + dimensionTypeName);
            dimensionType = null;
        } else {
            ((CompositeType)dimensionType).checkForWellFormedGroupSizeEncoding(nodeList.item(nodeIndex));
        }
        Field field = new Field.Builder().name(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "name")).description(XmlSchemaParser.getAttributeValueOrNull(nodeList.item(nodeIndex), "description")).id(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "id"))).blockLength(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "blockLength", "0"))).sinceVersion(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "sinceVersion", "0"))).dimensionType((CompositeType)dimensionType).build();
        XmlSchemaParser.checkForValidName(nodeList.item(nodeIndex), field.name());
        field.groupFields(this.parseFieldsAndGroups(nodeList.item(nodeIndex)));
        return field;
    }

    private Field parseField(NodeList nodeList, int nodeIndex) {
        String typeName = XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "type");
        Type fieldType = this.typeByNameMap.get(typeName);
        if (fieldType == null) {
            XmlSchemaParser.handleError(nodeList.item(nodeIndex), "could not find type: " + typeName);
        }
        Field field = new Field.Builder().name(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "name")).description(XmlSchemaParser.getAttributeValueOrNull(nodeList.item(nodeIndex), "description")).id(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "id"))).offset(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "offset", "0"))).semanticType(XmlSchemaParser.getAttributeValueOrNull(nodeList.item(nodeIndex), "semanticType")).presence(Presence.get(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "presence", "required"))).sinceVersion(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "sinceVersion", "0"))).epoch(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "epoch", "unix")).timeUnit(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "timeUnit", "nanosecond")).type(fieldType).build();
        field.validate(nodeList.item(nodeIndex));
        return field;
    }

    private Field parseDataField(NodeList nodeList, int nodeIndex) {
        String typeName = XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "type");
        Type fieldType = this.typeByNameMap.get(typeName);
        if (fieldType == null) {
            XmlSchemaParser.handleError(nodeList.item(nodeIndex), "could not find type: " + typeName);
        } else if (!(fieldType instanceof CompositeType)) {
            XmlSchemaParser.handleError(nodeList.item(nodeIndex), "data type is not composite type: " + typeName);
        } else {
            ((CompositeType)fieldType).checkForWellFormedVariableLengthDataEncoding(nodeList.item(nodeIndex));
            ((CompositeType)fieldType).makeDataFieldCompositeType();
        }
        Field field = new Field.Builder().name(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "name")).description(XmlSchemaParser.getAttributeValueOrNull(nodeList.item(nodeIndex), "description")).id(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "id"))).offset(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "offset", "0"))).semanticType(XmlSchemaParser.getAttributeValueOrNull(nodeList.item(nodeIndex), "semanticType")).presence(Presence.get(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "presence", "required"))).sinceVersion(Integer.parseInt(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "sinceVersion", "0"))).epoch(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "epoch", "unix")).timeUnit(XmlSchemaParser.getAttributeValue(nodeList.item(nodeIndex), "timeUnit", "nanosecond")).type(fieldType).variableLength(true).build();
        field.validate(nodeList.item(nodeIndex));
        return field;
    }

    private int computeAndValidateOffsets(Node node, List<Field> fields, int blockLength) {
        boolean variableSizedBlock = false;
        int offset = 0;
        for (Field field : fields) {
            if (0 != field.offset() && field.offset() < offset) {
                XmlSchemaParser.handleError(node, "Offset provides insufficient space at field: " + field.name());
            }
            if (-1 != offset) {
                if (0 != field.offset()) {
                    offset = field.offset();
                } else if (null != field.dimensionType() && 0 != blockLength) {
                    offset = blockLength;
                } else if (field.isVariableLength() && 0 != blockLength) {
                    offset = blockLength;
                }
            }
            field.computedOffset(variableSizedBlock ? -1 : offset);
            if (null != field.groupFields()) {
                int groupBlockLength = this.computeAndValidateOffsets(node, field.groupFields(), 0);
                this.validateBlockLength(node, field.blockLength(), groupBlockLength);
                field.computedBlockLength(Math.max(field.blockLength(), groupBlockLength));
                variableSizedBlock = true;
                continue;
            }
            if (null == field.type()) continue;
            int size = field.type().size();
            if (-1 == size) {
                variableSizedBlock = true;
            }
            if (variableSizedBlock) continue;
            offset += size;
        }
        return offset;
    }

    private int computeMessageRootBlockLength() {
        int blockLength = 0;
        for (Field field : this.fieldList) {
            if (field.groupFields() != null) {
                return blockLength;
            }
            if (field.type() == null) continue;
            int fieldSize = field.type().size();
            if (-1 == fieldSize) {
                return blockLength;
            }
            blockLength = field.computedOffset() + fieldSize;
        }
        return blockLength;
    }

    private void validateBlockLength(Node node, long specifiedBlockLength, long computedBlockLength) {
        if (0L != specifiedBlockLength && computedBlockLength > specifiedBlockLength) {
            XmlSchemaParser.handleError(node, "specified blockLength provides insufficient space " + computedBlockLength + " > " + specifiedBlockLength);
        }
    }
}

