/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import org.w3c.dom.Node;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public abstract class Type {
    public static final String DEFAULT_PRESENCE = "required";
    private final String name;
    private final Presence presence;
    private final String description;
    private final String semanticType;

    public Type(Node node) {
        this.name = XmlSchemaParser.getAttributeValue(node, "name");
        this.presence = Presence.get(XmlSchemaParser.getAttributeValue(node, "presence", DEFAULT_PRESENCE));
        this.description = XmlSchemaParser.getAttributeValueOrNull(node, "description");
        this.semanticType = XmlSchemaParser.getAttributeValueOrNull(node, "semanticType");
    }

    public Type(String name, Presence presence, String description, String semanticType) {
        this.name = name;
        this.presence = presence;
        this.description = description;
        this.semanticType = semanticType;
    }

    public String name() {
        return this.name;
    }

    public Presence presence() {
        return this.presence;
    }

    public abstract int size();

    public String description() {
        return this.description;
    }

    public String semanticType() {
        return this.semanticType;
    }
}

