/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.KeyPair;
import java.time.Duration;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebAlgorithm;

public class AlgorithmAndKeyPair {
    private final JsonWebAlgorithm algorithm;
    private final KeyPair keyPair;

    public static Cache<String, AlgorithmAndKeyPair> createCache(Duration keyLifetime) {
        return CacheBuilder.newBuilder().expireAfterWrite(keyLifetime).build();
    }

    public AlgorithmAndKeyPair(JsonWebAlgorithm algorithm, KeyPair keyPair) {
        this.algorithm = algorithm;
        this.keyPair = keyPair;
    }

    public JsonWebAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }
}

