/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public enum JsonWebAlgorithm {
    HS256("HS256", "HMAC using SHA-256", "HMAC", "HmacSHA256", 256, 256, "1.2.840.113549.2.9", null),
    HS384("HS384", "HMAC using SHA-384", "HMAC", "HmacSHA384", 384, 384, "1.2.840.113549.2.10", null),
    HS512("HS512", "HMAC using SHA-512", "HMAC", "HmacSHA512", 512, 512, "1.2.840.113549.2.11", null),
    RS256("RS256", "RSASSA-PKCS-v1_5 using SHA-256", "RSA", "SHA256withRSA", 256, 2048, null, null),
    RS384("RS384", "RSASSA-PKCS-v1_5 using SHA-384", "RSA", "SHA384withRSA", 384, 2048, null, null),
    RS512("RS512", "RSASSA-PKCS-v1_5 using SHA-512", "RSA", "SHA512withRSA", 512, 2048, null, null),
    ES256("ES256", "ECDSA using P-256 and SHA-256", "ECDSA", "SHA256withECDSAinP1363Format", 256, 256, "secp256r1", null),
    ES384("ES384", "ECDSA using P-384 and SHA-384", "ECDSA", "SHA384withECDSAinP1363Format", 384, 384, "secp384r1", null),
    ES512("ES512", "ECDSA using P-521 and SHA-512", "ECDSA", "SHA512withECDSAinP1363Format", 512, 521, "secp521r1", null),
    PS256("PS256", "RSASSA-PSS using SHA-256 and MGF1 with SHA-256", "RSA", "RSASSA-PSS", 256, 2048, null, new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1)),
    PS384("PS384", "RSASSA-PSS using SHA-384 and MGF1 with SHA-384", "RSA", "RSASSA-PSS", 384, 2048, null, new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1)),
    PS512("PS512", "RSASSA-PSS using SHA-512 and MGF1 with SHA-512", "RSA", "RSASSA-PSS", 512, 2048, null, new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1)),
    none("none", "No digital signature or MAC performed", "None", null, 0, 0, null, null),
    EdDSA("EdDSA", "EdDSA signature using SHA-512 and Curve25519", "EdDSA", "Ed25519", 512, 521, "Ed25519", null);

    private final String name;
    private final String description;
    private final String familyName;
    private final String jdkAlgName;
    private final int digestLength;
    private final int minKeyLength;
    private final String subName;
    private final AlgorithmParameterSpec parameterSpec;

    private JsonWebAlgorithm(String name, String description, String familyName, String jdkAlgName, int digestLength, int minKeyLength, String subName, AlgorithmParameterSpec parameterSpec) {
        this.name = name;
        this.description = description;
        this.familyName = familyName;
        this.jdkAlgName = jdkAlgName;
        this.digestLength = digestLength;
        this.minKeyLength = minKeyLength;
        this.subName = subName;
        this.parameterSpec = parameterSpec;
    }

    public String getName() {
        return this.name;
    }

    public String getJdkAlgName() {
        return this.jdkAlgName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getMinKeyLength() {
        return this.minKeyLength;
    }

    public String getSubName() {
        return this.subName;
    }

    public AlgorithmParameterSpec getParameter() {
        return this.parameterSpec;
    }
}

