/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx;

import io.vertx.core.json.JsonObject;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.impl.ECJwkBuilder;
import uk.co.spudsoft.jwtvalidatorvertx.impl.EdECJwkBuilder;
import uk.co.spudsoft.jwtvalidatorvertx.impl.RSAJwkBuilder;

public abstract class JwkBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JwkBuilder.class);
    private static final List<JwkBuilder> BUILDERS = Arrays.asList(new RSAJwkBuilder(), new EdECJwkBuilder(), new ECJwkBuilder());
    protected static final Base64.Encoder B64ENCODER = Base64.getUrlEncoder().withoutPadding();

    public static JwkBuilder get(PublicKey publicKey) {
        for (JwkBuilder builder : BUILDERS) {
            if (!builder.canHandleKey(publicKey)) continue;
            return builder;
        }
        throw new IllegalArgumentException("Key cannot be handled");
    }

    protected JwkBuilder() {
    }

    public abstract boolean canHandleKey(PublicKey var1);

    public abstract JsonObject toJson(String var1, String var2, PublicKey var3) throws InvalidParameterSpecException, NoSuchAlgorithmException;
}

