/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx;

import com.google.common.base.Strings;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebAlgorithm;

public class Jwt {
    private static final Base64.Decoder B64DECODER = Base64.getUrlDecoder();
    private static final int SPACE = " ".codePointAt(0);
    private final JsonObject header;
    private final JsonObject payload;
    private final String signatureBase;
    private final String signature;

    public Jwt(JsonObject header, JsonObject payload, String signatureBase, String signature) {
        this.header = header == null ? new JsonObject() : header;
        this.payload = payload == null ? new JsonObject() : payload;
        this.signatureBase = signatureBase;
        this.signature = signature;
    }

    public static Jwt parseJws(String token) {
        String[] segments = token.split("\\.");
        if (segments.length < 2 || segments.length > 3) {
            throw new IllegalArgumentException("Not enough or too many segments [" + segments.length + "]");
        }
        String headerSeg = segments[0];
        String payloadSeg = segments[1];
        String signatureSeg = segments.length == 2 ? null : segments[2];
        JsonObject header = new JsonObject(new String(B64DECODER.decode(headerSeg), StandardCharsets.UTF_8));
        JsonObject payload = new JsonObject(new String(B64DECODER.decode(payloadSeg), StandardCharsets.UTF_8));
        return new Jwt(header, payload, headerSeg + "." + payloadSeg, signatureSeg);
    }

    public int getPayloadSize() {
        return this.payload.size();
    }

    public Object getClaim(String claim) {
        return this.payload.getValue(claim);
    }

    public List<String> getClaimAsList(String claim) {
        ArrayList<String> result = new ArrayList<String>();
        Object value = this.payload.getValue(claim);
        if (value instanceof String) {
            result.add((String)value);
        } else if (value instanceof Iterable) {
            ((Iterable)value).forEach(a -> {
                if (a instanceof String) {
                    result.add((String)a);
                } else if (a != null) {
                    result.add(a.toString());
                }
            });
        } else if (value instanceof Object[]) {
            Object[] objArray = (Object[])value;
            for (int i = 0; i < objArray.length; ++i) {
                if (objArray[i] instanceof String) {
                    result.add((String)objArray[i]);
                    continue;
                }
                if (objArray[i] == null) continue;
                result.add(objArray[i].toString());
            }
        }
        return result;
    }

    public boolean has(String claim, String requiredValue) {
        block4: {
            Object value;
            block3: {
                value = this.payload.getValue(claim);
                if (value instanceof String) {
                    return requiredValue.equals(value);
                }
                if (!(value instanceof Iterable)) break block3;
                for (Object item : (Iterable)value) {
                    if (item == null || !(item instanceof String ? requiredValue.equals(item) : requiredValue.equals(item.toString()))) continue;
                    return true;
                }
                break block4;
            }
            if (!(value instanceof Object[])) break block4;
            Object[] objArray = (Object[])value;
            for (int i = 0; i < objArray.length; ++i) {
                Object item = objArray[i];
                if (item == null || !(item instanceof String ? requiredValue.equals(item) : requiredValue.equals(item.toString()))) continue;
                return true;
            }
        }
        return false;
    }

    public String getSignatureBase() {
        return this.signatureBase;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getAlgorithm() {
        return this.header.getString("alg");
    }

    public JsonWebAlgorithm getJsonWebAlgorithm() {
        String alg = this.getAlgorithm();
        if (Strings.isNullOrEmpty((String)alg)) {
            return null;
        }
        return JsonWebAlgorithm.valueOf(alg);
    }

    public String getKid() {
        return this.header.getString("kid");
    }

    public String getSubject() {
        return this.payload.getString("sub");
    }

    public String getIssuer() {
        return this.payload.getString("iss");
    }

    public List<String> getAudience() {
        return this.getClaimAsList("aud");
    }

    public boolean hasAudience(String requiredValue) {
        return this.has("aud", requiredValue);
    }

    public List<String> getScope() {
        String scopeString = this.payload.getString("scope");
        if (Strings.isNullOrEmpty((String)scopeString)) {
            return Collections.emptyList();
        }
        return Arrays.asList(scopeString.split(" "));
    }

    public boolean hasScope(String requiredValue) {
        String scopeString = this.payload.getString("scope");
        if (Strings.isNullOrEmpty((String)scopeString)) {
            return false;
        }
        int idx = scopeString.indexOf(requiredValue);
        if (idx < 0) {
            return false;
        }
        if (idx == 0 || scopeString.codePointBefore(idx) == SPACE) {
            int reqLen = requiredValue.length();
            if (idx == scopeString.length() - reqLen || scopeString.codePointAt(idx + reqLen) == SPACE) {
                return true;
            }
        }
        return false;
    }

    public List<String> getGroups() {
        return this.getClaimAsList("groups");
    }

    public boolean hasGroup(String requiredValue) {
        return this.has("groups", requiredValue);
    }

    public List<String> getRoles() {
        return this.getClaimAsList("roles");
    }

    public boolean hasRole(String requiredValue) {
        return this.has("roles", requiredValue);
    }

    public Long getExpiration() {
        return this.payload.getLong("exp");
    }

    public LocalDateTime getExpirationLocalDateTime() {
        Long exp = this.getExpiration();
        if (exp != null) {
            return LocalDateTime.ofEpochSecond(this.getExpiration(), 0, ZoneOffset.UTC);
        }
        return null;
    }

    public Long getNotBefore() {
        return this.payload.getLong("nbf");
    }

    public LocalDateTime getNotBeforeLocalDateTime() {
        Long nbf = this.getNotBefore();
        if (nbf != null) {
            return LocalDateTime.ofEpochSecond(this.getNotBefore(), 0, ZoneOffset.UTC);
        }
        return null;
    }

    public String getPayloadAsString() {
        return this.payload.encode();
    }
}

