/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx;

import io.vertx.core.Future;
import io.vertx.ext.web.client.WebClient;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import uk.co.spudsoft.jwtvalidatorvertx.IssuerAcceptabilityHandler;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebKeySetHandler;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebKeySetKnownJwksHandler;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebKeySetOpenIdDiscoveryHandler;
import uk.co.spudsoft.jwtvalidatorvertx.Jwt;
import uk.co.spudsoft.jwtvalidatorvertx.impl.JwtValidatorVertxImpl;

public interface JwtValidator {
    public static JwtValidator createDynamic(WebClient webClient, IssuerAcceptabilityHandler issuerAcceptabilityHandler, Duration defaultJwkCacheDuration) {
        JsonWebKeySetOpenIdDiscoveryHandler openIdDiscoveryHandler = JsonWebKeySetOpenIdDiscoveryHandler.create(webClient, issuerAcceptabilityHandler, defaultJwkCacheDuration);
        return JwtValidator.create(openIdDiscoveryHandler, issuerAcceptabilityHandler);
    }

    public static JwtValidator createStatic(WebClient webClient, Collection<String> jwksEndpoints, Duration defaultJwkCacheDuration, IssuerAcceptabilityHandler issuerAcceptabilityHandler) {
        JsonWebKeySetKnownJwksHandler staticHandler = JsonWebKeySetKnownJwksHandler.create(webClient, jwksEndpoints, defaultJwkCacheDuration);
        return JwtValidator.create(staticHandler, issuerAcceptabilityHandler);
    }

    public static JwtValidator create(JsonWebKeySetHandler jsonWebKeySetHandler, IssuerAcceptabilityHandler issuerAcceptabilityHandler) {
        jsonWebKeySetHandler.optimize();
        return new JwtValidatorVertxImpl(jsonWebKeySetHandler, issuerAcceptabilityHandler);
    }

    public Set<String> getPermittedAlgorithms();

    public JwtValidator setPermittedAlgorithms(Set<String> var1) throws NoSuchAlgorithmException;

    public JwtValidator addPermittedAlgorithm(String var1) throws NoSuchAlgorithmException;

    public JwtValidator setRequireExp(boolean var1);

    public JwtValidator setRequireNbf(boolean var1);

    public JwtValidator setTimeLeeway(Duration var1);

    public Future<Jwt> validateToken(String var1, String var2, List<String> var3, boolean var4);
}

