/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import com.google.common.cache.Cache;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.AlgorithmAndKeyPair;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebAlgorithm;
import uk.co.spudsoft.jwtvalidatorvertx.TokenBuilder;

public abstract class AbstractTokenBuilder
implements TokenBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTokenBuilder.class);
    protected static final Base64.Encoder BASE64 = Base64.getUrlEncoder().withoutPadding();
    protected static final SecureRandom RANDOM = new SecureRandom();
    private boolean headerNotValidBase64 = false;
    private boolean payloadNotValidBase64 = false;
    private boolean signatureNotValidBase64 = false;
    private boolean headerNotJson = false;
    private boolean payloadNotJson = false;
    private boolean signatureNotValidHash = false;
    private boolean kidInvalid = false;
    protected final Cache<String, AlgorithmAndKeyPair> keyCache;

    public AbstractTokenBuilder(Cache<String, AlgorithmAndKeyPair> keyCache) {
        this.keyCache = keyCache;
    }

    @Override
    public TokenBuilder setHeaderNotValidBase64(boolean headerNotValidBase64) {
        this.headerNotValidBase64 = headerNotValidBase64;
        return this;
    }

    @Override
    public TokenBuilder setPayloadNotValidBase64(boolean payloadNotValidBase64) {
        this.payloadNotValidBase64 = payloadNotValidBase64;
        return this;
    }

    @Override
    public TokenBuilder setSignatureNotValidBase64(boolean signatureNotValidBase64) {
        this.signatureNotValidBase64 = signatureNotValidBase64;
        return this;
    }

    @Override
    public TokenBuilder setHeaderNotJson(boolean headerNotJson) {
        this.headerNotJson = headerNotJson;
        return this;
    }

    @Override
    public TokenBuilder setPayloadNotJson(boolean payloadNotJson) {
        this.payloadNotJson = payloadNotJson;
        return this;
    }

    @Override
    public TokenBuilder setSignatureNotValidHash(boolean signatureNotValidHash) {
        this.signatureNotValidHash = signatureNotValidHash;
        return this;
    }

    @Override
    public TokenBuilder setKidInvalid(boolean kidInvalid) {
        this.kidInvalid = kidInvalid;
        return this;
    }

    @Override
    public String buildToken(JsonWebAlgorithm jwa, String kid, String iss, String sub, List<String> aud, Long nbf, Long exp, Map<String, Object> otherClaims) throws Exception {
        String signatureBase64;
        JsonObject header = this.generateHeaderNode(kid, jwa);
        logger.debug("header: {}", (Object)header);
        JsonObject claims = this.generateClaimsNode(iss, sub, exp, nbf, aud, otherClaims);
        logger.debug("claims: {}", (Object)claims);
        String headerBase64 = this.base64Header(header);
        String claimsBase64 = this.base64Claims(claims);
        if (kid != null && jwa != JsonWebAlgorithm.none) {
            byte[] signature = this.generateSignature(kid, jwa, headerBase64, claimsBase64);
            if (this.signatureNotValidHash) {
                signature = Arrays.copyOf(signature, signature.length - 1);
            }
            signatureBase64 = this.base64Signature(signature);
        } else {
            signatureBase64 = "";
        }
        String token = this.constructToken(headerBase64, claimsBase64, signatureBase64);
        logger.debug("Result: {}", (Object)token);
        return token;
    }

    protected JsonObject generateHeaderNode(String kid, JsonWebAlgorithm algorithm) {
        JsonObject header = new JsonObject();
        header.put("typ", (Object)"JWT");
        if (kid != null) {
            if (this.kidInvalid) {
                header.put("kid", (Object)"INVALID");
            } else {
                header.put("kid", (Object)kid);
            }
        }
        header.put("alg", (Object)algorithm.getName());
        return header;
    }

    protected JsonObject generateClaimsNode(String iss, String sub, Long exp, Long nbf, List<String> aud, Map<String, Object> otherClaims) {
        JsonObject claims = new JsonObject();
        if (sub != null) {
            claims.put("sub", (Object)sub);
        }
        if (iss != null) {
            claims.put("iss", (Object)iss);
        }
        if (exp != null) {
            claims.put("exp", (Object)exp);
        }
        if (nbf != null) {
            claims.put("nbf", (Object)nbf);
        }
        if (aud != null) {
            if (aud.size() == 1) {
                claims.put("aud", (Object)aud.get(0));
            } else {
                JsonArray array = new JsonArray();
                claims.put("aud", (Object)array);
                for (String member : aud) {
                    array.add((Object)member);
                }
            }
        }
        if (otherClaims != null) {
            for (Map.Entry<String, Object> claim : otherClaims.entrySet()) {
                claims.put(claim.getKey(), claim.getValue());
            }
        }
        return claims;
    }

    protected String base64JSon(boolean notJson, boolean brokenBase64, JsonObject json) {
        String jsonString = json.toString();
        if (notJson) {
            jsonString = jsonString.replaceAll("\"", "");
        }
        String base64 = BASE64.encodeToString(jsonString.getBytes(StandardCharsets.UTF_8));
        if (brokenBase64) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        return base64;
    }

    protected String base64Header(JsonObject header) {
        return this.base64JSon(this.headerNotJson, this.headerNotValidBase64, header);
    }

    protected String base64Claims(JsonObject claims) {
        return this.base64JSon(this.payloadNotJson, this.payloadNotValidBase64, claims);
    }

    protected abstract byte[] generateSignature(String var1, JsonWebAlgorithm var2, String var3, String var4) throws Exception;

    protected String base64Signature(byte[] signature) {
        String signatureBase64 = BASE64.encodeToString(signature);
        if (this.signatureNotValidBase64) {
            signatureBase64 = signatureBase64.substring(0, signatureBase64.length() - 1);
        }
        return signatureBase64;
    }

    protected String constructToken(String headerBase64, String claimsBase64, String signatureBase64) {
        String token = headerBase64 + "." + claimsBase64 + "." + signatureBase64;
        return token;
    }
}

