/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncLoadingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncLoadingCache.class);
    private final Object lock = new Object();
    private final Cache<K, Data> backing = CacheBuilder.newBuilder().build();

    public TimedObject<V> entry(V value, long expiry) {
        return new TimedObject<V>(value, expiry);
    }

    public boolean containsKey(K key) {
        return this.backing.asMap().containsKey(key);
    }

    public void put(K key, TimedObject<V> value) {
        Data data = new Data();
        data.update(true, value);
        this.backing.put(key, (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Future<V> get(K key, Callable<Future<TimedObject<V>>> loader) {
        Promise promise;
        Data data;
        Object object = this.lock;
        synchronized (object) {
            data = (Data)this.backing.getIfPresent(key);
            if (data != null && data.expiry > System.currentTimeMillis()) {
                if (!data.completed) {
                    Promise promise2 = this.createAndAddInitialPromise(data.initialPromises);
                    return promise2.future();
                }
                if (data.succeeded) {
                    return Future.succeededFuture(data.result);
                }
                promise = this.createAndAddInitialPromise(data.initialPromises);
                data.completed = false;
            } else {
                data = new Data();
                promise = this.createAndAddInitialPromise(data.initialPromises);
                this.backing.put(key, (Object)data);
            }
        }
        Data finalData = data;
        try {
            loader.call().onComplete(ar -> this.handleAfterLoaderCall((AsyncResult<TimedObject<V>>)ar, finalData));
            return promise.future();
        }
        catch (Throwable ex) {
            logger.error("Failed to call loader: ", ex);
            return Future.failedFuture((Throwable)ex);
        }
    }

    public Set<K> keySet() {
        return ImmutableSet.copyOf(this.backing.asMap().keySet());
    }

    private Promise<V> createAndAddInitialPromise(List<Promise<V>> initialPromises) {
        Promise promise = Promise.promise();
        initialPromises.add(promise);
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAfterLoaderCall(AsyncResult<TimedObject<V>> asyncResult, Data data) {
        List initialPromises;
        boolean succeeded = asyncResult.succeeded();
        TimedObject result = (TimedObject)asyncResult.result();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            initialPromises = data.initialPromises;
            data.update(succeeded, result);
        }
        if (succeeded) {
            for (Promise initialPromise : initialPromises) {
                initialPromise.complete(result.value);
            }
        } else {
            for (Promise initialPromise : initialPromises) {
                initialPromise.fail(asyncResult.cause());
            }
        }
    }

    public static class TimedObject<U> {
        private final U value;
        private final long expiryMs;

        public TimedObject(U value, long expiryMS) {
            this.value = value;
            this.expiryMs = expiryMS;
        }

        public U getValue() {
            return this.value;
        }

        public long getExpiryMs() {
            return this.expiryMs;
        }

        public boolean expiredBefore(long nowMs) {
            return this.expiryMs < nowMs;
        }
    }

    private class Data {
        private List<Promise<V>> initialPromises = new ArrayList();
        private boolean completed;
        private boolean succeeded;
        private long expiry = Long.MAX_VALUE;
        private V result;

        Data() {
        }

        void update(boolean succeeded, TimedObject<V> value) {
            this.initialPromises = new ArrayList();
            this.completed = true;
            this.succeeded = succeeded;
            if (succeeded) {
                this.expiry = value.expiryMs;
                this.result = value.value;
            }
        }
    }
}

